#ifndef _TABDIALOG_H_
#define _TABDIALOG_H_

#include <qtabdlg.h>
#include "Baseobject.h"


class TabDialog : public QTabDialog, BaseObject
{
  Q_OBJECT
  
public:
    TabDialog( QWidget *parent=0, const char *name=0, bool modal=FALSE,
		unsigned int f=0 ) : QTabDialog(parent,name,modal,f) 
    {
      connect(this, SIGNAL(aboutToShow()), this, SLOT(sigAboutToShow()));
      connect(this, SIGNAL(applyButtonPressed()), this, SLOT(sigApplyButtonPressed()));
      connect(this, SIGNAL(cancelButtonPressed()), this, SLOT(sigCancelButtonPressed()));
      connect(this, SIGNAL(defaultButtonPressed()), this, SLOT(sigDefaultButtonPressed()));
      connect(this, SIGNAL(selected(const char *)), this, SLOT(sigSelected(const char *)));
    }		
   ~TabDialog() {};


protected slots:

    void sigAboutToShow() {
       _emit("aboutToShow", 0);  
    }
    void sigApplyButtonPressed() {
       _emit("applyButtonPressed", 0);  
    }
    void sigCancelButtonPressed() {
       _emit("cancelButtonPressed", 0);  
    }
    void sigDefaultButtonPressed() {
       _emit("defaulButtonPressed", 0);  
    }
    void sigSelected( const char *tab ) {
       PyObject *arg = Py_BuildValue("(s)",tab);
       _emit("selected", arg);  
       Py_DECREF(arg);    
    }
};


#endif