/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.util.LocaleServiceProviderPool;
import sun.util.TimeZoneNameUtility;
import sun.util.resources.LocaleData;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault());
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols dateFormatSymbols;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        if (localeServiceProviderPool.hasProviders() && (dateFormatSymbols = localeServiceProviderPool.getLocalizedObject(DateFormatSymbolsGetter.INSTANCE, locale, new Object[0])) != null) {
            return dateFormatSymbols;
        }
        return new DateFormatSymbols(locale);
    }

    public String[] getEras() {
        return Arrays.copyOf(this.eras, this.eras.length);
    }

    public void setEras(String[] stringArray) {
        this.eras = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public void setMonths(String[] stringArray) {
        this.months = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getWeekdays() {
        return Arrays.copyOf(this.weekdays, this.weekdays.length);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getShortWeekdays() {
        return Arrays.copyOf(this.shortWeekdays, this.shortWeekdays.length);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getAmPmStrings() {
        return Arrays.copyOf(this.ampms, this.ampms.length);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length;
            if (n < 5) {
                throw new IllegalArgumentException();
            }
            stringArrayArray[i] = Arrays.copyOf(stringArray[i], n);
        }
        this.zoneStrings = stringArrayArray;
        this.isZoneStringsSet = true;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = new String(string);
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = 0;
        String[][] stringArray = this.getZoneStringsWrapper();
        for (int i = 0; i < stringArray[0].length; ++i) {
            n ^= stringArray[0][i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return Arrays.equals(this.eras, dateFormatSymbols.eras) && Arrays.equals(this.months, dateFormatSymbols.months) && Arrays.equals(this.shortMonths, dateFormatSymbols.shortMonths) && Arrays.equals(this.weekdays, dateFormatSymbols.weekdays) && Arrays.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && Arrays.equals(this.ampms, dateFormatSymbols.ampms) && Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])dateFormatSymbols.getZoneStringsWrapper()) && (this.localPatternChars != null && this.localPatternChars.equals(dateFormatSymbols.localPatternChars) || this.localPatternChars == null && dateFormatSymbols.localPatternChars == null);
    }

    private static ResourceBundle cacheLookup(Locale locale) {
        ResourceBundle resourceBundle;
        SoftReference<ResourceBundle> softReference = (SoftReference<ResourceBundle>)cachedLocaleData.get(locale);
        if (softReference == null) {
            resourceBundle = LocaleData.getDateFormatData(locale);
            softReference = new SoftReference<ResourceBundle>(resourceBundle);
            cachedLocaleData.put(locale, softReference);
        } else {
            resourceBundle = (ResourceBundle)softReference.get();
            if (resourceBundle == null) {
                resourceBundle = LocaleData.getDateFormatData(locale);
                softReference = new SoftReference<ResourceBundle>(resourceBundle);
            }
        }
        return resourceBundle;
    }

    private void initializeData(Locale locale) {
        int n;
        ResourceBundle resourceBundle = DateFormatSymbols.cacheLookup(locale);
        this.eras = (String[])resourceBundle.getObject("Eras");
        this.months = resourceBundle.getStringArray("MonthNames");
        this.shortMonths = resourceBundle.getStringArray("MonthAbbreviations");
        String[] stringArray = resourceBundle.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        for (n = 0; n < stringArray.length; ++n) {
            this.weekdays[n + 1] = stringArray[n];
        }
        String[] stringArray2 = resourceBundle.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        for (n = 0; n < stringArray2.length; ++n) {
            this.shortWeekdays[n + 1] = stringArray2[n];
        }
        this.ampms = resourceBundle.getStringArray("AmPmMarkers");
        this.localPatternChars = resourceBundle.getString("DateTimePatternChars");
        this.locale = locale;
    }

    final int getZoneIndex(String string) {
        String[][] stringArray = this.getZoneStringsWrapper();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i][0])) continue;
            return i;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private final String[][] getZoneStringsImpl(boolean bl) {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        if (!bl) {
            return this.zoneStrings;
        }
        int n = this.zoneStrings.length;
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Arrays.copyOf(this.zoneStrings[i], this.zoneStrings[i].length);
        }
        return stringArray;
    }

    private final boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private final void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.eras = Arrays.copyOf(dateFormatSymbols.eras, dateFormatSymbols.eras.length);
        dateFormatSymbols2.months = Arrays.copyOf(dateFormatSymbols.months, dateFormatSymbols.months.length);
        dateFormatSymbols2.shortMonths = Arrays.copyOf(dateFormatSymbols.shortMonths, dateFormatSymbols.shortMonths.length);
        dateFormatSymbols2.weekdays = Arrays.copyOf(dateFormatSymbols.weekdays, dateFormatSymbols.weekdays.length);
        dateFormatSymbols2.shortWeekdays = Arrays.copyOf(dateFormatSymbols.shortWeekdays, dateFormatSymbols.shortWeekdays.length);
        dateFormatSymbols2.ampms = Arrays.copyOf(dateFormatSymbols.ampms, dateFormatSymbols.ampms.length);
        dateFormatSymbols2.zoneStrings = dateFormatSymbols.zoneStrings != null ? dateFormatSymbols.getZoneStringsImpl(true) : (String[][])null;
        dateFormatSymbols2.localPatternChars = new String(dateFormatSymbols.localPatternChars);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        objectOutputStream.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFormatSymbolsGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<DateFormatSymbolsProvider, DateFormatSymbols> {
        private static final DateFormatSymbolsGetter INSTANCE = new DateFormatSymbolsGetter();

        private DateFormatSymbolsGetter() {
        }

        @Override
        public DateFormatSymbols getObject(DateFormatSymbolsProvider dateFormatSymbolsProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 0);
            return dateFormatSymbolsProvider.getInstance(locale);
        }
    }
}

