/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import java.io.PrintStream;

public class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr = new byte[4096];
    short[] strNxt = new short[4096];
    short[] strHsh;
    short numStrings;
    int[] strLen = new int[4096];

    public LZWStringTable() {
        this.strHsh = new short[9973];
    }

    public int addCharString(short s, byte by) {
        if (this.numStrings >= 4096) {
            return 65535;
        }
        int n = LZWStringTable.hash(s, by);
        while (this.strHsh[n] != -1) {
            n = (n + 2039) % 9973;
        }
        this.strHsh[n] = this.numStrings;
        this.strChr[this.numStrings] = by;
        if (s == -1) {
            this.strNxt[this.numStrings] = -1;
            this.strLen[this.numStrings] = 1;
        } else {
            this.strNxt[this.numStrings] = s;
            this.strLen[this.numStrings] = this.strLen[s] + 1;
        }
        short s2 = this.numStrings;
        this.numStrings = (short)(s2 + 1);
        return s2;
    }

    public short findCharString(short s, byte by) {
        short s2;
        if (s == -1) {
            return (short)(by & 0xFF);
        }
        int n = LZWStringTable.hash(s, by);
        while ((s2 = this.strHsh[n]) != -1) {
            if (this.strNxt[s2] == s && this.strChr[s2] == by) {
                return s2;
            }
            n = (n + 2039) % 9973;
        }
        return -1;
    }

    public void clearTable(int n) {
        int n2;
        this.numStrings = 0;
        for (n2 = 0; n2 < 9973; ++n2) {
            this.strHsh[n2] = -1;
        }
        n2 = (1 << n) + 2;
        for (int i = 0; i < n2; ++i) {
            this.addCharString((short)-1, (byte)i);
        }
    }

    public static int hash(short s, byte by) {
        return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
    }

    public int expandCode(byte[] byArray, int n, short s, int n2) {
        if (n == -2 && n2 == 1) {
            n2 = 0;
        }
        if (s == -1 || n2 == this.strLen[s]) {
            return 0;
        }
        int n3 = byArray.length - n;
        int n4 = this.strLen[s] - n2;
        int n5 = n3 > n4 ? n4 : n3;
        int n6 = n4 - n5;
        int n7 = n + n5;
        while (n7 > n && s != -1) {
            if (--n6 < 0) {
                byArray[--n7] = this.strChr[s];
            }
            s = this.strNxt[s];
        }
        if (n4 > n5) {
            return -n5;
        }
        return n5;
    }

    public void dump(PrintStream printStream) {
        for (int i = 258; i < this.numStrings; ++i) {
            printStream.println(" strNxt[" + i + "] = " + this.strNxt[i] + " strChr " + Integer.toHexString(this.strChr[i] & 0xFF) + " strLen " + Integer.toHexString(this.strLen[i]));
        }
    }
}

