/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.util.Collection;
import sun.security.jca.GetInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertStore {
    private static final String CERTSTORE_TYPE = "certstore.type";
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;

    protected CertStore(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
        this.storeSpi = certStoreSpi;
        this.provider = provider;
        this.type = string;
        if (certStoreParameters != null) {
            this.params = (CertStoreParameters)certStoreParameters.clone();
        }
    }

    public final Collection<? extends Certificate> getCertificates(CertSelector certSelector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(certSelector);
    }

    public final Collection<? extends CRL> getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(cRLSelector);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertStore", CertStoreSpi.class, string, certStoreParameters);
            return new CertStore((CertStoreSpi)instance.impl, instance.provider, string, certStoreParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return CertStore.handleException(noSuchAlgorithmException);
        }
    }

    private static CertStore handleException(NoSuchAlgorithmException noSuchAlgorithmException) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Throwable throwable = noSuchAlgorithmException.getCause();
        if (throwable instanceof InvalidAlgorithmParameterException) {
            throw (InvalidAlgorithmParameterException)throwable;
        }
        throw noSuchAlgorithmException;
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, String string2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertStore", CertStoreSpi.class, string, (Object)certStoreParameters, string2);
            return new CertStore((CertStoreSpi)instance.impl, instance.provider, string, certStoreParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return CertStore.handleException(noSuchAlgorithmException);
        }
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertStore", CertStoreSpi.class, string, (Object)certStoreParameters, provider);
            return new CertStore((CertStoreSpi)instance.impl, instance.provider, string, certStoreParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return CertStore.handleException(noSuchAlgorithmException);
        }
    }

    public final CertStoreParameters getCertStoreParameters() {
        return this.params == null ? null : (CertStoreParameters)this.params.clone();
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(CertStore.CERTSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "LDAP";
        }
        return string;
    }
}

