<?php

// projects_forms.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

function access_form() {
  global $user_ID, $form_error, $project_name, $categories, $row, $anfang, $ende, $chef, $sql_user_group, $user_group,
         $projekte, $PHPSESSID, $sid, $ID, $notes, $dateien, $parent, $action, $lib_path, $img_path, $proj_text16, $contact,
         $admin_text73, $admin_text70, $proj_name, $proj_stat, $proj_chan, $proj_start, $proj_end, $proj_text10,
         $proj_text12, $proj_text13, $proj_text14, $proj_text29, $proj_text30, $cur_symbol, $proj_prio, $proj_chef, $proj_pers, $proj_text11,
         $admin_text6, $admin_text7, $admin_text8, $confirm, $proj_text15, $back, $print, $admin_text71,
         $type, $sort,$up, $filter, $keyword, $perpage, $page, $subprojects, $adressen, $contacts_nolink, $bgcolor3,
         $budget, $stundensatz, $wichtung, $ziel, $note, $view_param;

  // update project? -> fetch values form record
  if ($action <> "new") { fetch_record(); }

  // set variables for a new project:
  else {
    // new subproject ...
    if ($parent) {
      $row[11] = set_new_subproject($parent);
    }
    // ... or a new project at all
   else { set_new_project(); }
  }

  // check whether the user is a chief or the leader of this project
  if(!check_chief_status())$read_o = "disabled style='background-color:$bgcolor3;'";

  // enable js check, begin form
  echo "<form action='projects.php' method='post' name=frm onSubmit=\"return chkForm('frm','project_name','$admin_text73!')\">\n";
  echo "<table border=0 cellpadding=2 cellspacing=2><tr><td><table border=0 cellpadding=2 cellspacing=2>\n";
  // project name
  echo "<tr><td>$proj_name: </td><td colspan=2><input type='text' name='project_name' size='19' maxlength='19' value='$project_name' $read_o></td></tr>\n";

  // category
  echo "<tr><td>$admin_text70:</td><td><select name=cat $read_o> <option value=0>\n";
  for ($i=1; $i <= count($categories); $i++) {
    echo "<option value='$i'";
    if ($row[14] == $i) { echo " selected"; }
    echo ">$categories[$i]\n";
  }
  echo "</select></td></tr>\n";

  // status
  if ($action <> "new") {
    echo "<tr><td>$proj_stat: $row[5] % </td>\n";
    echo "<td colspan=2> $proj_chan: $row[6]</td></tr>\n";
  }

  // start and end time
  echo "<tr><td>$proj_start [yyyy-mm-dd]:</td>\n";
  echo "<td colspan=2><input type='text' name='anfang' size='10' maxlength='10' value='$anfang' $read_o onBlur=\"chkISODate('frm','anfang','$proj_text30')\"></td></tr>\n";
  echo "<tr><td>$proj_end [yyyy-mm-dd]:</td><td colspan=2>\n";
  echo "<input type='text' name='ende' size='10' maxlength='10' value='$ende' $read_o onBlur=\"chkISODate('frm','ende','$proj_text30','$proj_text29!')\"></td></tr>\n";

  // assing project to a subproject
  echo "<tr><td>$proj_text10:</td><td colspan=2>";
  echo "<select name='parent' $read_o><option value=''>\n";
  // initialize array of subprojects so if it will remain empty, no warning in the in_array function will appear :-)
  $subprojects[] = 0;
  // if it is already a subproject: list all project below this one to prevent that we make a closed loop :-)
  if ($ID > 0) { listsub($row[0]); }

  // call function to list all possible parent project in a tree view in the select box
  show_projectelements_of_tree($row[11],0, $ID);
  echo "</select></td></tr>\n";

  // select chef
  echo "<tr><td>$proj_chef:</td><td colspan=2><select name='chef' $read_o><option value=''>\n";
  // group mode -> fetch all users of this group from table user_grup
  if ($user_group) {$result3 = db_query("select kurz, nachname, vorname from grup_user,users
                                         where grup_user.user_ID = users.ID and grup_user.grup_ID = $user_group
                                         order by users.nachname asc") or db_die();}
  // no group system -> fetch all users
  else {$result3 = db_query("select kurz, nachname, vorname from users order by nachname asc") or db_die();}
  while ($row3 = db_fetch_row($result3)) {
    echo "<option value=$row3[0]";
    if ($row3[0] == $chef) { echo " selected"; }
    echo ">$row3[1], $row3[2]\n";
  }
  echo "</select></td></tr>\n";

  // select contact
  if ($adressen  and !$contacts_nolink) {
    echo "<tr><td><a href='javascript:show()'><b>$proj_text12:</b></a></td><td colspan=2><select name='contact' $read_o><option value=''>\n";
    $result2 = db_query("select * from contacts where (von = '$user_ID' or acc like 'a') and $sql_user_group order by nachname asc") or db_die();
    while ($row2 = db_fetch_row($result2)) {
      echo "<option value=$row2[0]";
      if ($row2[0] == $contact) { echo " selected"; }
      echo ">$row2[2], $row2[1]";
    }
    echo "</select></td></tr>\n";
  }

  // hourly rate
  echo "<tr><td>$proj_text13:</td><td><input type='text' name='stundensatz' size='8' maxlength='8' value='$stundensatz' $read_o> $cur_symbol/h</td></tr>\n";
  // budget
  echo "<tr><td>$proj_text14:</td><td><input type='text' name='budget' size='8' maxlength='12' value='$budget' $read_o> $cur_symbol</td></tr>\n";

  // priority
  echo "<tr><td>$proj_prio:</td><td><select name=wichtung $read_o>\n";
  for ($i=1; $i<=9; $i++) {
    echo "<option value='$i'";
    if ($i == $wichtung) { echo " selected"; }
    echo ">$i\n";
  }
  echo "</select></td></tr>\n";

  // show already booked work time
  if ($projekte > 1) {
    $result2 = db_query("select * from timeproj where projekt = '$ID'") or db_die();
    while ($row2 = db_fetch_row($result2)) { $sum1 = $sum1 + $row2[4]*60+$row2[5]; }
    $h = floor($sum1/60);
    $m = $sum1 - $h*60;
    $amount = number_format($row[16] * $sum1/60);
    if ($amount > 0) {
      echo "<tr><td>$proj_text16: </td><td colspan=2>$cur_symbol:$amount - h:$h/m:$m </td></tr>\n";
    }
  }
  // hidden fields
  $hidden = array_merge(array('ID'=>$ID,'type'=>$type,'mode'=>'data','gruppe'=>'user_group'), $view_param);
  if(SID)$hidden['PHPSESSID'] = $PHPSESSID;
  hidden_fields($hidden);

  // ***************
  // various buttons
if (!$read_o){ // chief only
  if ($action == "new") {
    echo "<tr><td></td><td colspan=2><input type=submit value='$admin_text6'></td></tr>\n";
    echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
  } // modify and delete
  else {
    echo "<tr><td>&nbsp;</td><td><input type=submit value='$admin_text7'></td>\n";
    // change values
    echo "<input type=hidden name='anlegen' value='aendern'>\n";
    // check whether ther is no subproject beyond this one. if no -> allow to delete
    $result2 = db_query("select ID from projekte where parent = '$ID'") or db_die();
    $row2 = db_fetch_row($result2);
    if ($row2[0] == "") { echo "<td><input type=submit name='delete' value='$admin_text8' onClick=\"return confirm('$confirm')\"></td></tr>\n"; }

    // new subproject
    echo "<tr><td>&nbsp;</td><td colspan=2><a href='projects.php?action=new&mode=forms&parent=$ID$sid'>$proj_text15</a></td></tr>\n";
  }
} // end buttons chief only

  // cancel
  echo "<tr><td>&nbsp;</td><td><a href='projects.php?mode=view&type=$type&sort=$sort&up=$up&filter=$filter&keyword=$keyword&perpage=$perpage&page=$page$sid'>$back</a></td><td>\n";
  // print
  if ($action <> "new") { echo "<a href='../misc/print.php?module=proj&ID=$row[0]$sid' target=_blank>$print</a>&nbsp;\n"; }


  // ***************************************
  // second row of big table
  echo "</td></tr></table></td>\n";
  echo "<td><img src='$img_path/s.gif' width=1 height=300></td>\n";
  echo "<td><table cellpadding=1 cellspacing=1>\n";

  // select participants
  echo "<tr><td>$proj_pers:</td><td colspan=2><select name='personen[]' multiple size='8' $read_o>\n";
  // select user from this group
  include_once("$lib_path/show_group_users.inc.php");
  // show all members of the group, don't exclude yourself
  show_group_users($user_group, 0, 3);
  echo "</select></td></tr>\n";

  // aim
  $ziel = html_out($ziel);
  echo "<tr><td>$proj_text11:</td><td><input type='text' name='ziel' size='38' value='$ziel' $read_o></td></tr>\n";
  // remark
  $note = html_out($note);
  echo "<tr><td colspan=2>$admin_text71 <br><textarea name=note rows=14 cols=50 $read_o>$note</textarea></td></tr>\n";
  echo "</table></form></td></tr>";
  // end of 2. big table and form, continue with small table for files and notes

  echo "<tr><td colspan=6><img src='$img_path/s.gif' width=550 height=1></td></tr>\n";

  // related notes, show only for existing projects
  echo "<tr><td>\n";
  if ($notes and $ID > 0) { show_related_notes(); }

  echo "&nbsp;</td><td colspan=2>\n";

  // show related files
  if ($dateien and $ID > 0) { show_related_files(); }

  // close big table
  echo "&nbsp;</td></tr></table>\n";
}
// end  of big form :-)

// set variables for a new subproject
function set_new_subproject($parent) {
  global $ID, $row, $anfang, $ende;
  $result = db_query("select * from projekte where ID = '$parent'") or db_die();
  $row = db_fetch_row($result);
  // delete ID, because it's a new project
  $row[0] = $ID = 0;
  $row[1] = "";
  $anfang = $row[7];
  $ende = $row[2];
  return $parent;
}

// set variables for a new root project
function set_new_project() {
  global $ID, $anfang, $ende, $row;
  $ID = $row[0] = 0;
  $anfang = date("Y")."-".date("m")."-".date("d");
  $ende = "2003-12-31";
  $row[16] = 0;   // stundensatz / hourly rate
  $row[17] = 0;  // budget
}

// update project? -> fetch values form record
function fetch_record() {
  global $ID, $project_name, $chef, $anfang, $ende, $row, $contact, $wichtung, $budget, $stundensatz, $ziel, $note;
  $result = db_query("select * from projekte where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);
  $project_name = html_out($row[1]);
  $ende = $row[2];
  $chef   = $row[9];
  $anfang = $row[7];
  $contact = $row[15];
  $stundensatz = $row[16];
  $budget = $row[17];
  $wichtung = $row[4];
  $ziel = $row[12];
  $note = $row[13];
}

// list all subprojects
function listsub($ID) {
  global $subprojects;
  // create a default value for new projects so this array is not empty
  $result2 = db_query("select ID from projekte where parent = $ID and parent > 0") or db_die();
  while ($row2 = db_fetch_row($result2)) {
    $subprojects[] = $row2[0];
    listsub($row2[0]);
  }
}

// show files related to this project
function show_related_files() {
  global $o_files, $file_ID, $datei_text3, $date_text6, $date_text5, $date_text4, $ID, $user_ID, $user_kurz, $user_name, $user_firstname, $PHPSESSID, $sid;
  echo "<b>$o_files:</b><br>\n";
  echo "<table><tr><td>$datei_text3</a></td>\n";
  echo "<td>$datei_text6</a></td>\n";
  echo "<td>Byte</a></td>\n";
  echo "<td>&nbsp;</td>\n"; // table cell for buttons
  echo "<td>$datei_text5</a></td>\n";   // category
  echo "<td>$datei_text4</a></td></tr>\n"; // remark
  // query: fetch all reocrds which have field div2 = (projects) as the project_ID, the user has access and the type is not a directory
  $result = db_query("select * from dateien where div2 like '$ID' and
                     (von=$user_ID or acc like 'group' or acc like '%\"$user_kurz\"%') and
                     (typ like 'f%' or typ like 'l')
                     order by filename") or db_die();
  while ($row = db_fetch_row($result)) include('../filemanager/filemanager_list.php');
  echo "</table>";
}

// show notes related to this project
function show_related_notes() {
  global $o_notes, $ID, $admin_text6, $user_ID, $img_path, $remark, $sid, $path_pre, $user_group;
  echo "<table><tr><td><b>$o_notes:</b><br>\n";
  // new note
  echo "<a href='../index.php?mode=notes&projekt_ID=$ID$sid' target=_top>$admin_text6</a></td><td>\n";
  $result3 = db_query("select ID, name, remark from notes where projekt = '$ID' and (von = '$user_ID' or ext = '$user_group')") or db_die();
  while ($row3 = db_fetch_row($result3)) {
    $remark = html_out(trim(substr($row3[2],0,60)));
    echo "<img src=$img_path/b.gif alt='$remark' title='$remark' width=7 border=0>\n";
    $row3[1] = html_out($row3[1]);
    echo "<a href='../notes/notes.php?mode=view&ID=$row3[0]$sid' target=_blank> $row3[1]</a><br>\n";
  }
  echo "</td></tr></table>\n";
}

// check permission: chief at all or leader of this project
function check_chief_status() {
  global $user_access, $row, $user_kurz;
  if (ereg("c",$user_access) or ($row[9] == $user_kurz)) return true;
  else return false;
}

// this function is similar to the show_elements of tree function in the lib
// but needs several exceptions: the projects mustn't be a subproject of an own subproject  -see exclussion list
// the former condition of course is senseless if it is a new project :-)
// parameter: table and column name, $query, $access column,order by, value of element to show as selected, name of parent column
function show_projectelements_of_tree($selected,$parent_ID,$ID) {
  global $indent, $user_kurz, $user_access, $sql_user_group, $subprojects;

  // fetch parent project
  $result = db_query("select * from projekte where $sql_user_group and parent = '$parent_ID' order by name") or db_die();
  while ($row = db_fetch_row($result)) {

    // user must be participant, user with chief status or project leader
    if ((ereg("\"$user_kurz\"",$row[3]) or ereg("c",$user_access) or $row[9] == $user_kurz) and
    // project must not be a subproject of itself, but could be a new project
    ((!in_array($row[0],$subprojects) and $ID <> $row[0]) or $ID == 0) and
    // parent project must not be ended
    $row[14] != "4") { $allowed = 1; }
    else { $allowed = 0; }

    // access allowed
    if ($allowed == 1) {
      echo "<option value='$row[0]'";
      if ($row[0] == $selected) { echo " selected"; }
      echo ">";
      for ($i = 1; $i <= $indent; $i++) { echo "&nbsp;&nbsp;"; }
      echo "$row[1]</option>\n";
    }

    // look for subelements
    $indent++;
    show_projectelements_of_tree($selected,$row[0],$ID);
    $indent--;
  }
}


echo "<script language='JavaScript' src='$lib_path/chkform.js' type='text/javascript'></script>\n";
echo"
<script language='JavaScript'>
function show() {
  x = document.frm.contact.value
  if(x > 0){
    path = self.location.protocol + '//' + self.location.hostname + self.location.pathname;
    path = path.replace(/projects\/projects.php/,'');
    y = path + 'misc/print.php?module=contacts&pers_ID=' + x + '$sid';
    window.open(y);
  }
}
</script>";

access_form();

?>
