<?php     

// db_var.inc.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// create auto_increment for oracle
  function sequence($a) {
    $b = $a."_id_seq";
    $result = db_query("
      CREATE SEQUENCE $b
        START WITH 1
        INCREMENT BY 1
        NOMINVALUE
        NOMAXVALUE
        NOCYCLE
        CACHE 20
        ORDER
    ");
    $c = $a."_auto_increment";
    $d = $b.".nextval";
    $result = db_query("
      CREATE OR REPLACE TRIGGER $c
      BEFORE INSERT ON $a
      REFERENCING OLD AS OLD NEW AS NEW
      FOR EACH ROW
      BEGIN
        SELECT $d INTO :NEW.ID FROM DUAL;
      END;
    ");
  }

  function ib_autoinc($table){
    //function which implements the autoinc function for interbase
    //looks like some overhead but its required
    $trigger="set_id_".$table;
    $generator="gen_id_".$table;

    $result= db_query("
      CREATE GENERATOR $generator
    "); //each table gets its own generator for its own trigger
    //echo $result;
    //echo "generator for $table generated<br>";
    $result= db_query("
      CREATE TRIGGER $trigger FOR $table BEFORE INSERT AS
      BEGIN
      new.id=gen_id($generator,1);
      END
    "); //generator which was incremented by 1 from its own trigger
    //echo $result;
    //echo "trigger for $table generated<br>";

  }

// ID auto_increment
$db_int8_auto["mysql"] = "int(8) NOT NULL auto_increment";         // ID int(8) NOT NULL auto_increment,
$db_int8_auto["oracle"] = "number(8) NOT NULL ";
$db_int8_auto["informix"] = "serial NOT NULL ";
$db_int8_auto["postgresql"] = "serial";
$db_int8_auto["ms_sql"] = "int identity";
$db_int8_auto["interbase"] = "integer not null";

// text
// since 'post' only allows 4 kB of transmitted signs, varchar2(4000) fits.
$db_text["mysql"] = "text";
$db_text["oracle"] = "varchar2(4000)";
$db_text["informix"] = "char(4000)";
$db_text["postgresql"] = "text";
$db_text["ms_sql"] = "text NULL";
$db_text["interbase"] = "varchar(4000)";

// integer
$db_int1["mysql"] = "int(1)";                                      // int(1),
$db_int1["oracle"] = "number(1)";
$db_int1["informix"] = "decimal(1)";
$db_int1["postgresql"] = "integer";
$db_int1["ms_sql"] = "tinyint NULL";
$db_int1["interbase"] = "decimal(1)";

$db_int2["mysql"] = "int(2)";                                      // int(2),
$db_int2["oracle"] = "number(2)";
$db_int2["informix"] = "decimal(2)";
$db_int2["postgresql"] = "integer";
$db_int2["ms_sql"] = "smallint NULL";
$db_int2["interbase"] = "decimal(2)";

$db_int3["mysql"] = "int(3)";                                      // int(3),
$db_int3["oracle"] = "number(3)";
$db_int3["informix"] = "decimal(3)";
$db_int3["postgresql"] = "integer";
$db_int3["ms_sql"] = "int NULL";
$db_int3["interbase"] = "decimal(3)";

$db_int4["mysql"] = "int(4)";                                      // int(4),
$db_int4["oracle"] = "number(4)";
$db_int4["informix"] = "decimal(4)";
$db_int4["postgresql"] = "integer";
$db_int4["ms_sql"] = "int NULL";
$db_int4["interbase"] = "decimal(4)";

$db_int6["mysql"] = "int(6)";                                      // int(6),
$db_int6["oracle"] = "number(6)";
$db_int6["informix"] = "decimal(6)";
$db_int6["postgresql"] = "integer";
$db_int6["ms_sql"] = "int NULL";
$db_int6["interbase"] = "decimal(6)";

$db_int8["mysql"] = "int(8)";                                      // int(8),
$db_int8["oracle"] = "number(8)";
$db_int8["informix"] = "decimal(8)";
$db_int8["postgresql"] = "integer";
$db_int8["ms_sql"] = "int NULL";
$db_int8["interbase"] = "decimal(8)";

$db_int11["mysql"] = "int(11)";                                    // int(11),
$db_int11["oracle"] = "number(11)";
$db_int11["informix"] = "decimal(11)";
$db_int11["postgresql"] = "integer";
$db_int11["ms_sql"] = "decimal NULL";
$db_int11["interbase"] = "decimal(11)";

// char
$db_char1["mysql"] = "char(1)";                                    // char(1)
$db_char1["oracle"] = "char(1)";
$db_char1["informix"] = "char(1)";
$db_char1["postgresql"] = "char(1)";
$db_char1["ms_sql"] = "char(1) NULL";
$db_char1["interbase"] = "char(1)";

//varchar
$db_varchar2["mysql"] = "varchar(2)";                             // varchar(2),
$db_varchar2["oracle"] = "varchar2(2)";
$db_varchar2["informix"] = "varchar(2)";
$db_varchar2["postgresql"] = "varchar(2)";
$db_varchar2["ms_sql"] = "varchar(2) NULL";
$db_varchar2["interbase"] = "varchar(2)";

$db_varchar3["mysql"] = "varchar(3)";                             // varchar(3),
$db_varchar3["oracle"] = "varchar2(3)";
$db_varchar3["informix"] = "varchar(3)";
$db_varchar3["postgresql"] = "varchar(3)";
$db_varchar3["ms_sql"] = "varchar(3) NULL";
$db_varchar3["interbase"] = "varchar(3)";

$db_varchar4["mysql"] = "varchar(4)";                             // varchar(4),
$db_varchar4["oracle"] = "varchar2(4)";
$db_varchar4["informix"] = "varchar(4)";
$db_varchar4["postgresql"] = "varchar(4)";
$db_varchar4["ms_sql"] = "varchar(4) NULL";
$db_varchar4["interbase"] = "varchar(4)";

$db_varchar10["mysql"] = "varchar(10)";                           // varchar(10),
$db_varchar10["oracle"] = "varchar2(10)";
$db_varchar10["informix"] = "varchar(10)";
$db_varchar10["postgresql"] = "varchar(10)";
$db_varchar10["ms_sql"] = "varchar(10) NULL";
$db_varchar10["interbase"] = "varchar(10)";

$db_varchar20["mysql"] = "varchar(20)";                           // varchar(20),
$db_varchar20["oracle"] = "varchar2(20)";
$db_varchar20["informix"] = "varchar(20)";
$db_varchar20["postgresql"] = "varchar(20)";
$db_varchar20["ms_sql"] = "varchar(20) NULL";
$db_varchar20["interbase"] = "varchar(20)";

$db_varchar40["mysql"] = "varchar(40)";                           // varchar(40)
$db_varchar40["oracle"] = "varchar2(40)";
$db_varchar40["informix"] = "varchar(40)";
$db_varchar40["postgresql"] = "varchar(40)";
$db_varchar40["ms_sql"] = "varchar(40) NULL";
$db_varchar40["interbase"] = "varchar(40)";

$db_varchar60["mysql"] = "varchar(60)";                           // varchar(50),
$db_varchar60["oracle"] = "varchar2(60)";
$db_varchar60["informix"] = "varchar(60)";
$db_varchar60["postgresql"] = "varchar(60)";
$db_varchar60["ms_sql"] = "varchar(60) NULL";
$db_varchar60["interbase"] = "varchar(60)";

$db_varchar80["mysql"] = "varchar(80)";                           // varchar(80),
$db_varchar80["oracle"] = "varchar2(80)";
$db_varchar80["informix"] = "varchar(80)";
$db_varchar80["postgresql"] = "varchar(80)";
$db_varchar80["ms_sql"] = "varchar(80) NULL";
$db_varchar80["interbase"] = "varchar(80)";

$db_varchar128["mysql"] = "varchar(128)";                         // varchar(128),
$db_varchar128["oracle"] = "varchar2(128)";
$db_varchar128["informix"] = "varchar(128)";
$db_varchar128["postgresql"] = "varchar(128)";
$db_varchar128["ms_sql"] = "varchar(128) NULL";
$db_varchar128["interbase"] = "varchar(128)";

$db_varchar255["mysql"] = "varchar(255)";                         // varchar(255),
$db_varchar255["oracle"] = "varchar2(255)";
$db_varchar255["informix"] = "varchar(255)";
$db_varchar255["postgresql"] = "varchar(255)";
$db_varchar255["ms_sql"] = "varchar(255) NULL";
$db_varchar255["interbase"] = "varchar(255)";
?>