<?php

// mail_send.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther
// contains code adapted from class mime_mail by S.Schumann & T.Ratschiller

$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;

echo "<html><head><link rel=stylesheet type='text/css' href='$css_style'>$lang_cfg\n";
// js function to include a string with the name of a db-field for the personalized newsletter
echo "<script language='JavaScript'>
function insPlHold() {
txt = document.frm.body.value + document.frm.placehold.value;
document.frm.body.value = txt;
document.frm.placehold.value = '';
document.frm.body.focus();
}
</script>
\n";
echo "</head><body bgcolor=$bgcolor3>\n";

// patches
// patch for opera: opera still shows one entry even if you didn't select anything -> unset this first array element
if (count($mem)==1 and $mem[0]=="") unset($mem[0]);
if (count($con)==1 and $con[0]=="") unset($con[0]);

// build mail or fax list from users and/or contacts
if ($action) {
  // if the feature 'insert db values' is chosen, no user can be added :-(
  // reason: the db table 'users' has a different structure
  if (!ereg("db-field:",$body)) {
    for ($i=0; $i < count($mem); $i++) {
      // fetch all names and the respective db field from the users
      $result = db_query("select nachname, $action from users where ID = '$mem[$i]'") or db_die();
      $row = db_fetch_row($result);
      // the db field 'mail' or 'fax' has to be non empty
      if ($row[1] <> "") {
        // correct fax adresses
        if ($action == "fax") { $row[1] = preg_replace( "/\D/", "", $row[1] ); }
        // add this entry to the list
        $adr[] = trim($row[1]);
      }
      // no entry found? -> show a message re this record on the screen
      else { echo"$row[0]: $action $mail_text6 - $action $mail_text8 ...<br>\n"; }
    }
  } // end if cond. 'insert db-values'

  // choose profile users
  // condition: profiles have to active in the config, a profile has been selected
  //(of course) and the 'insert db values' feature is inactive
  if (count($mem) == 0 and $profil1 and !ereg("db-field:",$body)) {
    // fetch record
    $result = db_query("select personen from profile where ID = '$profil1'") or db_die();
    $row = db_fetch_row($result);
    $adr_profil = unserialize($row[0]);
    // loop over all short names in the array
    for ($i = 0; $i < count($adr_profil); $i++) {
      // fetch email or fax from user
      $result2 = db_query("select $action from users where kurz like '$adr_profil[$i]'") or db_die();
      $row2 = db_fetch_row($result2);
      // if he has an email/fax, add him/her to the list
      if ($row2[0] <> "") { $adr[] = $row2[0];  }
    }
  }

  // choose profile contacts
  if (count($con) == 0 and $profil2) {
    // fetch record
    $result = db_query("select contact_ID from contacts_prof_rel where contacts_profiles_ID = '$profil2'") or db_die();
    while ($row = db_fetch_row($result)) {
      // fetch email or fax from user
      $result2 = db_query("select $action from contacts where ID = '$row[0]'") or db_die();
      $row2 = db_fetch_row($result2);
      // if he has an email/fax, add him/her to the list
      if ($row2[0] <> "") { $adr[] = $row2[0];  }
    }
  }

  if ($adressen) {
    // manual selection of contacts
    for ($i=0; $i < count($con); $i++) {
      $result = db_query("select nachname, $action from contacts where ID = '$con[$i]'") or db_die();
      $row = db_fetch_row($result);
      if ($row[1] <> "") {
        if ($action == "fax") { $row[1] = preg_replace( "/\D/", "", $row[1] ); }
        $adr[] = trim($row[1]);
      }
      // no entry found? -> show a message re this record on the screen
      else { echo "$row[0]: $action $mail_text6 <br> $action -  $mail_text8 <br>\n"; }
    }
  }
  // add individual recipients
  if ($additional_mail) { $adr[] = trim($additional_mail); }
  if ($additional_fax)  { $adr[] = trim($additional_fax); }
  // no adresses selected? -> exit
  if (count($adr) == 0) { die("$mail_text2! <a href='mail.php?mode=send&subject=$subj&body=$body$sid'>&nbsp; $back</a>");  }
} // end build recipient list


// **********************
// 1. action: send a mail
// **********************

if ($action == "email") {

  // ************************
  // Sender/signature routine
  // if 'default' or empty selction - take the usual values
  if ($sender_ID == "default" or !$sender_ID) {
    $sender_email = $user_email;
    $signature = "";
  }
  // if the user has chosen another signature/sender profile, fetch this
  elseif ($sender_ID > 0) {
    $result = db_query("select sender, signature from mail_sender where ID = '$sender_ID'") or db_die();
    $row = db_fetch_row($result);
    $sender_email = $row[0];
    $signature =  $row[1];
  }
  // add signature
  if ($signature) { $body .= "\n".$signature; }
  // end sender signature

  // **************
  // recipients part
  // check whether the body contains db-fields. If yes, switch to single mails
  if (ereg("db-field:",$body)) { $single = "checked"; }
  // 1. check whether the adresses contain some zz <zz@zz.de> - the <> chars will be taken as html tags :-(
  for ($i=0; $i<count($adr); $i++) {
    if (ereg("<",$adr[$i])) {
      $a1 = explode("<",$adr[$i]);
      $a2 = explode(">",$a1[1]);
      $adr[$i] = $a2[0];
    }
  }
  // 2. all recipients in one mail -> tie them together
  if ($single <> "checked") { $pers = implode(",",$adr); }
  // end recipients part

  // free stings from slashes (but keep them for db storage)
  $subj1 = trim(stripslashes($subj));
  //$body1 = ereg_replace("\n","\r\n\r",stripslashes($body));
  $body1 = trim(stripslashes($body));

  // ***********
  // attachments
  // ***********

  // check beforehand whether a forwarded mail do have an attachment. if yes, store them in parts[]
    if ($forwarded_mail > 0) {
      $result2 = db_query("select * from mail_attach where parent = '$forwarded_mail'") or db_die();
      // loop over all found attachments
      while ($row2 = db_fetch_row($result2)) {
        // assign name of the attachment ..
        $attfile = "../attach/$row2[3]";
        // ... and type!
        $attfile_type = find_userfile_type($row2[2]);
        // open the attachtment and put it into the string 'attachment'
        $attachment = fread(fopen("$attfile", "rb"), filesize("$attfile"));
        // add one more element to the array 'parts'
        $parts[] = array ( "ctype" => $attfile_type,"message" => $attachment,"name" => $row2[2] );
      }
    } // end fetch attachments from a forwarded mail

  // begin big routine to form one string out of
  // 1. the body, 2. user selected attachments, 3. optionally attachments from a forwarded mail
  if (($userfile and $userfile <> "none") or count($parts) > 0) {

    // flag for later check
    $attachment_exist = 1;

    // add the selected attachment to the string
    $attachment = fread(fopen("$userfile", "rb"), filesize("$userfile"));
    $parts[] = array ( "ctype" => $userfile_type,"message" => $attachment,"name" => $userfile_name );

    // *********
    // send part
    // *********

    // though we switch now to the inmportant part - sending the email,
    // we continue with the bracket 'attachments' because the email sending
    // with an attachment needs a different code

    // send one mail to all persons
    if ($single <> "checked") {
      multipart($body1);
      // add all adresses to the 'To:' field in the mime string
      $to_string = implode(",",$adr);
      // build the whole mime string with attachments
      $mime = build_mime($to_string);
      //finally the action: mail the mail and show success message
      if (mail($pers, $subj1, "", $mime)) { echo "$mail_text3"; }
    }
    // send a single mail to each person
    else {
        // personalized newsletters? -> fetch the values from db
        if (ereg("db-field:",$body1))  $body2 = insert_db_values($adr[$i], $body1);
        else $body2 = $body1;
        // add a personized 'to' to the header. build the whole mime string with attachments
        multipart($body2);
      // now llop over all recipients and send out the mail
      for ($i=0; $i < count($adr); $i++) {
        $mime = build_mime($adr[$i]);
        //finally the action: mail the mail and show success message
        if (mail($adr[$i], $subj1, "", $mime,"-f $sender_email")) { echo "$adr[$i]: $mail_text3<br>"; }
      }
    } // end bracket send single mails
  } // end bracket part send mails with attachments

  // Finally we ended the big bracket 'attachments' and continue the sendmail-action,
  // now with the option 'plain-text' mail.

  // send plain mail with no attachment
  else {

    // send one mail to all persons
    if ($single <> "checked") {
      // add all adresses to the 'To:' field in the mime string
      $to_string = implode(",",$adr);
      // build the whole mime string with attachments
      $mime = build_mime($to_string);
      //finally the action: mail the mail and show success message
      if (mail($pers, $subj1, $body1, $mime,"-f $sender_email")) { echo "$mail_text3"; }
    }
    // send a single mail to each person
    else {
      for ($i=0; $i < count($adr); $i++) {
        // add a personized 'to' to the header. build the whole mime string with attachments
        $mime = build_mime($adr[$i]);
        // personalized newsletters? -> fetch the values form db
        if (ereg("db-field:",$body1)) { $body2 = insert_db_values($adr[$i], $body1); }
        else $body2 = $body1;
        //finally the action: mail the mail and show success message
        if (mail($adr[$i], $subj1, $body2, $mime,"-f $sender_email")) {  echo "$adr[$i]: $mail_text3<br>"; }

      }
    }
  } // end sending plain text mails


  // write record to database if mail reader is active
  if ($quickmail == 2) {
    // prepare receiver array $adr for storage - implode it to string $adr2
    $i = 0;
    while ($adr[$i]) {
      if ($i > 0) { $adr2 .= ", "; }
      $adr2 .= $adr[$i];
      $i++;
    }
    // look if a default folder for outgoing mails is defined
    $result = db_query("select parent from mail_rules where von = '$user_ID' and type like 'outgoing'") or db_die();
    $row = db_fetch_row($result);
    if ($row[0] > 0) { $parents[0] = $row[0]; }
     // no rule given -> take root level
    else { $parents[0] = 0; }

    $result = db_query("insert into mail_client values($dbIDnull,'$user_ID','$subj','$body','$sender_email','$adr2',null,null,null,'-',1,'s','$parents[0]','$dbTSnull',null,null,null,null)") or db_die();
    $result3 = db_query("select ID from mail_client where date_sent = '$dbTSnull' and von = $user_ID") or db_die();
    $row3 = db_fetch_row($result3);
    $mail_ID = $row3[0];

    // store attachment
    if ($userfile and $userfile <> "none") {
      // save file, first create random name
      $att_tempname = "";
      srand((double)microtime()*1000000);
      $char = "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMANOPQRSTUVWXYZ";
      while (strlen($att_tempname) < 12) { $att_tempname .= substr($char,(rand()%(strlen($char))),1); }
      // add extension to random name
      $att_tempname .= substr($att_name,-4,4);
      copy($userfile,"../attach/$att_tempname");
      // write record to db
      $result3 = db_query("insert into mail_attach values($dbIDnull,$mail_ID,'$userfile_name','$att_tempname',$userfile_size)") or db_die();
    }
  }

  // empty subject & body
  $subject = ""; $body = ""; $action = "";
  // set mode to email
  $form = "email";

}

// *********************
// 2. action: send a fax
// *********************

elseif ($action == "fax") {
  $fname = tempnam("", "fax");
  $fp = fopen("$fname", "a");
  fputs($fp,"$subj\n\n\n");
  fputs($fp, "$body\n");
  fclose($fp);
  for ($i=0; $i < count($adr); $i++) {
    // delete all non-numeric characters
    $adr[$i] = ereg_replace("[^0-9]","",$adr[$i]);
    // build fax string ...
    $faxstring = "$faxpath -n -f $user -R -r '$subject' -d $adr[$i] $fname";
    // ... and run sendfax
    $result = system(EscapeShellCmd($faxstring));
    if ($result) { echo "fax to $adr[$i] sent <br>"; }
    else { echo "error while sending fax to $adr[$i]! <br>"; }
  }
  $action = "";
  // set mode to fax
  $form = "fax";
}

// ********************
// last action: send SMS
// ********************

elseif ($action == "send_sms") {
  // limit the text length to 160 chars - tha's at lest the limit in germany :-)
  $body = substr($body, 0, 159);
  // no receiver, no number given? -> die!
  if ($adr[0] == "" and !$smsnumber) { die("$mail_text2"); }
  else {
    for ($i=0; $i < count($adr); $i++) {
      $result = db_query("select mobil, nachname from contacts where ID = '$adr[$i]'") or db_die();
      $row = db_fetch_row($result);
      if ($row[0] <> "") {
        $nr = $row[0]."@".$smspath;
        if (mail($nr, $subj, $body,"-f $sender_email")) { echo "$row[1]: $mail_text3a<br>"; }
      }
    }
    if ($smsnumber) {
      $nr = $smsnumber."@".$smspath;
      if (mail($nr, $subj, $body,"-f $sender_email")) { echo "$smsnumber: $mail_text3a<br>"; }
    }
  }
  // set mode to sms
  $form = "sms";
}

//*******
// DIALOG
// ******

if (!$action) {
  // if no mode is set (email, fax, sms), set default to email
  if (!$form) { $form = "email"; }

  // only for mail section: check whether mail client sended some data
  if ($action2) {
    // check permission and fetch data
    $result = db_query("select * from mail_client where ID = '$ID'") or db_die();
    $row = db_fetch_row($result);
    if ($row[0] == 0) { die("no entry found."); }
    if ($row[1] <> $user_ID) { die("You are not allowed to do this!"); }

    // reply? -> give sender as recipient
    if (ereg("&lt;",$row[4])) {$sender=explode("&lt;",$row[4]);$row[4]=substr($sender[1],0,-4);}
    // build email of recipient
    if ($action2 == "reply" or $action2 == "replyall") {
      // take adress from replyto if given
      if ($row[15] <> "")  { $recipient = $row[15]; }
      // otherwise the from adress
      else { $recipient = $row[4]; }
      // add cc and recipients: to recipient if replyall is given
      if ($action2 == "replyall") {
        if ($row[5] <> "") { $recipient .=",".$row[5]; }
        if ($row[6] <> "") { $recipient .=",".$row[6]; }
      }
      // subject
      $subject = "Re: ".$row[2];
    }
    // forwarding ...
    elseif ($action2 == "forward") {
      $subject = "Fw: ".$row[2];
    }
    // format body text.
    $body = ereg_replace("\n","\n>",$row[3]);
    $body = ">".wordwrap($body,50,"\n>");
  } // end only for mail section - reply or forward a mail ...


  // **************
  // begin the form
  echo "<table cellspacing=0 cellpadding=3 width=120 border=1>";
  echo "<form action='mail.php' name='frm' method=post enctype='multipart/form-data'>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>";
  echo "<input type='hidden' name='mode' value='send'>\n";
  // title and help link
  echo "<tr><td><a href='$doc/quickmail.html' target=_blank><b>$o_mail</b></a> \n";

  // buttons for email, fax and SMS
  echo " &nbsp; &nbsp; <a href=mail.php?mode=send&form=email$sid>Email</a> ";
  if ($faxpath) { echo " &nbsp; &nbsp; <a href=mail.php?mode=send&form=fax$sid>$mail_text54</a> "; }
  if ($smspath) { echo " &nbsp; &nbsp; <a href=mail.php?mode=send&form=sms$sid>$mail_text55</a> "; }
  // back button to the mail client
  if ($quickmail == 2) { echo " &nbsp; &nbsp; &nbsp; <a href='mail.php?mode=view$sid'>$back</a> "; }
  echo "</td></tr>\n";
  // end header, now the form

  // email: sender/signature
  if ($form == "email") {
    // sender
    echo "<tr><td>$mail_text22: \n";
    // if it is the full mail client, offer the choice of all sender/signatures
    if ($quickmail == 2) {
      // begin dropdown menu
      echo "<select name=sender_ID> <option value='default'>$user_email";
      $result = db_query("select ID, title from mail_sender where von = '$user_ID'") or db_die();
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1]\n"; }
      echo "</select>\n";
    }
    // otherwise just display the normal string
    else { echo "$user_email "; }
    echo "</td>\n";
    // end sender
  }
  // nothing similar for fax and sms :-(
  else { echo "<tr><td>&nbsp;</td>\n"; }

  // title for user list
  echo "<td width=120 nowrap>$con_text2:</td>\n";
  // title for contact list  - only for email and fax, not for sms
  if ($adressen and !$contacts_nolink and $form <> "sms") {  echo "<td width=120 nowrap>$con_text3:</td>\n"; }

  // next line: subject and body
  echo "</tr><tr><td>";
  // subject field not for sms
  if ($form <> "sms") { echo "$mail_text1: <input type=text name='subj' value='".html_out($subject)."' size=60><br>\n"; }
  // body for all three modes :-)
  echo "<textarea rows=22 cols=52 name=body wrap=physical>$body</textarea></td>\n";

  // list: user selection
  echo "<td width=180>&nbsp;<select name=mem[] multiple size=19>\n";
  // select members of your group
  if ($user_group) {$result2 = db_query("select user_ID, users.nachname from grup_user,users where grup_ID = $user_group and
                                         grup_user.user_ID = users.ID order by users.nachname") or db_die();}
  else {$result2 = db_query("select ID, nachname from users order by nachname") or db_die();}
  // loop over all entries and fetch the data: $mode could be mail, fax or sms
  while ($row2 = db_fetch_row($result2)) {
    $result = db_query("select ID, vorname, nachname, $form from users where ID = '$row2[0]'") or db_die();
    $row = db_fetch_row($result);
    if ($row[3] <> "") echo "<option value=$row[0]>$row[2], $row[1]\n";
  }
  echo "</select></td>\n";
  // ende list user selection

  // profiles and db-fields - not for sms
  if ($adressen and !$contacts_nolink and $form <> "sms") {
    // select contacts
    echo "<td width=180>&nbsp;<select name=con[] multiple size=19>";
    $result = db_query("select ID, vorname, nachname from contacts where (von = '$user_ID' or acc like 'a') and $sql_user_group and $form <> '' order by nachname") or db_die();
    while ($row = db_fetch_row($result)) {echo "<option value=$row[0]>$row[2], $row[1]\n";}
    echo "</select></td></tr><tr>\n";

    // option for customized newsletter
    // insert db-field
    if ($form == "email") {
      echo "<td>$mail_text52: <br><select name='placehold' onChange='insPlHold()'>\n";
      echo "<option value=''>\n";
      // title,first name,last name,company,email,category,remark,email2,url,user def1,user def2,remark,
      // phone1,phon2,fax,street,city,zip code,country
      echo "<option value='|db-field:1($info_text17)|'>$info_text17\n"; // title
      echo "<option value='|db-field:2($info_text9)|'>$info_text9\n"; // first name
      echo "<option value='|db-field:3($info_text10)|'>$info_text10\n"; // last name
      echo "<option value='|db-field:4($info_text11)|'>$info_text11\n"; // company
      echo "<option value='|db-field:5(email1)|'>Email\n"; // email
      echo "<option value='|db-field:6($info_text8)|'>$info_text8\n"; // category
      echo "<option value='|db-field:7($info_text7)|'>$info_text7\n"; // remark
      echo "<option value='|db-field:8(email2)|'>Email 2\n"; // email
      echo "<option value='|db-field:9(url)|'>URL\n"; // url
      echo "<option value='|db-field:10($cont_usrdef1)|'>$cont_usrdef1\n"; // user defined 1
      echo "<option value='|db-field:11($cont_usrdef2)|'>$cont_usrdef2\n"; // user defined 1
      echo "<option value='|db-field:12($info_text7)|'>$info_text7\n"; // remark
      echo "<option value='|db-field:13($m1_text29 1)|'>$m1_text29 1\n"; // phone 1
      echo "<option value='|db-field:14($m1_text29 2)|'>$m1_text29 2\n"; // phone 2
      echo "<option value='|db-field:15($m1_text30)|'>$m1_text30\n"; // fax
      echo "<option value='|db-field:16($m1_text31)|'>$m1_text31\n"; // street
      echo "<option value='|db-field:17($m1_text32)|'>$m1_text32\n"; // city
      echo "<option value='|db-field:18($admin_text26)|'>$admin_text26\n"; // zip code
      echo "<option value='|db-field:19($m1_text33)|'>$m1_text33\n"; // country
      echo "</select></td>\n";
    } // end drop down menu personalized newsletter - only for mail
    else { echo "<td>&nbsp;</td>\n"; }

    // fetch profiles for users
    if ($profile) {
      echo "<td>$l_text25<br><select name=profil1> <option value=''>\n";
      $result = db_query("select * from profile where von = '$user_ID' order by bezeichnung") or db_die();
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[2]\n"; }
      echo "</select></td>";
    }
    else { echo "<td>&nbsp;</td>\n"; }

    // fetch profiles for contacts
    if ($contacts_profiles and $form <> "sms") {
      echo "<td>$opt_text1 $mail_text49<br><select name=profil2> <option value=''>\n";
      $result = db_query("select * from contacts_profiles where von = '$user_ID' order by name") or db_die();
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[2]\n"; }
      echo "</select><br></td></tr>";
    }
    else { echo "<td>&nbsp;</td>\n"; }

  } // end list of contacts and drop-down menu for personalized newsletter

  echo "</tr></table><br><table border=0><tr>\n";

  //*********
  // Fax form
  if ($form == "fax") {
    echo "<input type='hidden' name='action' value='fax'>\n";
    echo "<tr><td>$mail_text7:</td><td><input type='text' name='additional_fax' size=25></td></tr>\n";
    echo "<tr><td><input type=image src='$img_path/los.gif' border=0 id=tr></td></tr>\n";
  }
  // SMS form
  elseif ($form == "sms") {
    echo "<input type='hidden' name='action' value='sms'>\n";
    echo "<td> $mail_text7:</td><td><input type='text' name='smsnumber' size=25></td>\n";
    echo "<td><input type=image src='$img_path/los.gif' border=0 id=tr></td></tr>\n";
  }
  // mail form
  else {
    echo "<input type='hidden' name='action' value='email'>\n";

    // recipient
    echo "<tr><td>$mail_text11:</td><td> <input type='text' name='additional_mail' value='$recipient' size=50></td></tr>\n";
    // attachments
    echo "<tr><td>$mail_text4 </td><td>";

    // display file input box for attachments
    echo "<input type=file name=userfile size=28>&nbsp;</td></tr>\n";

    // carry a flag so the script can look for attachments
    if ($action2 == "forward") { echo "<input type=hidden name='forwarded_mail' value='$ID'>"; }

    // send single mails
    echo "<tr><td>$mail_text5 </td><td><input type=checkbox name='single' value='checked'></td></tr>\n";
    echo "<tr><td><input type=image src='$img_path/los.gif' border=0 id=tr></td></tr>\n";
  } // end mail form

  // close form for all
  echo "</form></table>\n";
}

// *********
// functions
// *********

// find out the type of the attachment of return the right value
function find_userfile_type($name) {

$filetypes = array("gif" => "image/gif", "jpg" => "image/jpeg", "png" => "image/png", "xls" => "application/msexcel",
                   "ppt" => "application/mspowerpoint", "doc" => "application/msword",  "pdf" => "application/pdf",
                   "rtf" => "text/rtf", "zip" => "application/zip", "mp3" => "audio/mpeg", "txt" => "text/plain",
                   "php" => "application/x-httpd-php", "tar.gz" => "application/x-gzip");

  if (substr($name,-4,1) == ".") {
    // check whether the extension is in the small list above
    while (list($extension,$extstring) = each($filetypes)) {
      if (substr($name,-3) == $extension) { return $extstring; }
    }
  }
  // nothing found - just give a simple text format, maybe it helps :-)
  $extstring = "unknown/unknown";
  return $extstring;
}

//function build mail part
function build_message($part) {
  $message = $part["message"];
  $message = chunk_split(base64_encode($message));
  return "Content-Type: ".$part["ctype"].($part["name"]?"; name = \"".$part["name"]."\"" : "")."\nContent-Transfer-Encoding: base64\n\n$message\n";
}

// search the body for special strings containing a db table name and replace it with the values from this contact
function insert_db_values($email,$body) {

  // title,first name,last name,company,email,category,remark,email2,url,user def1,user def2,remark,
  // phone1,phone2,fax,street,city,zip code,country
  $fieldnames = array("1"=>"anrede","2"=>"vorname","3"=>"nachname","4"=>"firma","5"=>"email","6"=>"kategorie",
                      "7"=>"bemerkung","8"=>"email2","9"=>"url","10"=>"div1","11"=>"div2","12"=>"bemerkung",
                      "13"=>"tel1","14"=>"tel2","15"=>"fax","16"=>"strasse","17"=>"stadt","18"=>"plz","19"=>"land");

  // search the body - go into the loop as long as you can find THE flag :-)
  while (ereg("\|db-field\:",$body)) {
    // only take the first part, leave possible other replaces for the moment, will be handled in the next loop
    // first extract the body until the first separator  ...
    $parts1 = explode("|db-field:",$body,2);
    // .. now the rest of the body ...
    $parts2 = explode(")|",$parts1[1],2);
    // .. now fetch the field number ...
    $parts3 = explode("(",$parts2[0]);
    $fieldname = $fieldnames[$parts3[0]];
    $result = db_query("select $fieldname from contacts where email = '$email'") or db_die();
    $row = db_fetch_row($result);
    // rebuild the body string with the db field value
    $body = $parts1[0].$row[0].$parts2[1];
  }
  return $body;
}

function build_mime($recipient) {
  global $sender_email, $multipart, $attachment_exist, $HTTP_SERVER_VARS;

  // for windows servers - include the To: into the header
  if ($HTTP_SERVER_VARS["WINDIR"] or $HTTP_SERVER_VARS["windir"]) { $mime = "To:$recipient\n"; }

  // continue mime part
  $mime .= "From:$sender_email\nReply-To:$sender_email\nSender:$sender_email\nReturn-Path:$sender_email\n";

  // add the atttachment if there is one
  if ($attachment_exist) {
    // add the multipart
    $mime = $mime.$multipart;
  }

  // format it nicely - remove all blank chars at the begin and end
  $mime = trim($mime);
  // end of building the string $mime
  return $mime;
}

function multipart($body){
global $parts, $multipart;
    // add the body to the string
    if (!empty($body)) { $parts[] = array ( "ctype" => "text/plain","message" => $body,"name" => "" ); }
    // end of buiding the array parts[] with several contents,
    // continue to build the string '$mime' by imploding the array parts ...

    // begin the mail string with identification
    $boundary = "b".md5(uniqid(time()));
    $multipart = "MIME-Version: 1.0\nContent-Type: multipart/mixed; boundary =\"$boundary\"\n\nThis is a MIME encoded message.\n\n--$boundary";
    // add each element (body, attachments) to the string
    for($i = count($parts)-1; $i >= 0; $i--) { $multipart .= "\n".build_message($parts[$i])."--$boundary"; }
    // terminate the multipart string
    $multipart.= "--\n";
    // end build multipart.
}

?>
