<?php

// projects_stat.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// include javascript function to check the start and end days
echo "<script language='JavaScript' src='$lib_path/chkform.js' type='text/javascript'></script>\n";

// show error messages
if ($action == "calc") {
  if (!$userlist[0]) { echo "<b>$proj_text32</b><br><br>"; $action = ""; }
  if (!$projectlist[0]) { echo "<b>$proj_text33</b><br><br>"; $action = ""; }
}

// show input box only if the table shouldn't be shown ...
if ($action <> "calc") {
  // set default date
  if (!$day) {$day = date("d"); }
  if (!$month) {$month = date("m"); }
  if (!$year) {$year = date("Y"); }

  // start form for input
  echo "<form action='projects.php' method=post name=frm>\n";
  if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type=hidden name='mode' value='stat'>\n";
  echo "<input type=hidden name='action' value='calc'>\n";

  // begin big table
  echo "<table border=0 cellpadding=2><td>\n";
  echo "<h3>$proj_sum</h3>$proj_text2<br>\n";
  echo "$proj_text3<br><br>\n";

  // begin input table
  echo "<table border=0 cellpadding=2 cellspacing=2 bgcolor=$bgcolor2>\n";

  // show boxes for start and end time
  // first time call: give default values
  if (!$start_day) { $start_day = "01"; }  if (!$start_month) { $start_month = "01"; } if (!$start_year) { $start_year = date("Y"); }
  if (!$end_day) { $end_day = date("d"); }  if (!$end_month) { $end_month = date("m"); } if (!$end_year) { $end_year = date("Y"); }

  // start day value
  echo "<tr><td>$proj_text6 [yyyy-mm-dd]<br><input type=text name='anfang' value='$start_year-$start_month-$start_day' size=10 onBlur=\"chkISODate('frm','anfang','$proj_text30')\">&nbsp;</td>\n";
  // end day value
  echo "<td>$proj_text7 [yyyy-mm-dd]<br><input type=text name='ende' value='$end_year-$end_month-$end_day' size=10 onBlur=\"chkISODate('frm','ende','$proj_text30','$proj_text29!')\"></td></tr>\n";

  // display project list
  echo "<tr><td>$proj_text4:<br> <select name=projectlist[] multiple size=20>\n";
  echo "<option value='gesamt'>$proj_text8\n";
  show_projects("0");
  echo "</select></td>\n";

  // display user list
  echo "<td>$proj_text5:<br> <select name=userlist[] multiple size=20>\n";
  // option 'all users' only available for usrs with chief status
  if (ereg("c",$user_access)) { echo "<option value='gesamt'>$proj_text8\n"; }
  // fetch all users from this group
  if ($groups) {
  $result2 = db_query("select users.ID, nachname, vorname, kurz from users, grup_user where
                       users.ID = user_ID and grup_ID = '$user_group' order by nachname") or db_die();
  }
  // alternatively all users from in the sytem in groupless mode
  else {
    $result2 = db_query("select ID, nachname, vorname, kurz from users order by nachname") or db_die();    
  } 
  while ($row2 = db_fetch_row($result2)) {
    // list them only if 1. the user is yourself, 2. you are an user with chief status or 3. you are leader of at least one project :-)
    if ($user_kurz == $row2[3] or ereg("c",$user_access) or $leader) {
      echo "<option value='$row2[0]'";
      if ($userlist[0] > 0 and in_array($row2[0], $userlist)) { echo " selected"; }
      echo ">$row2[1], $row2[2]\n";
    }
  }
  echo "</select></td></tr>";
  // end list users

  // show check boxes for bookings
  // dates ...
  if($showbookingdates == "on") { $showbookingdatesflag = " checked"; }
  echo "<tr><td><input type=checkbox name=showbookingdates $showbookingdatesflag> $opt_text17</td>\n";
  // ... and additionally the notes
  if($showbookingnotes == "on") { $showbookingnotesflag = " checked"; }
  echo "<td><input type=checkbox name=showbookingnotes $showbookingnotesflag> $rts_40</td></tr>";
  echo "<tr><td><input type=image src='$img_path/los.gif' border=0 id=tr></td>\n";
  echo "<td><a href='projects.php?mode=view$sid'>$back</td></tr>\n";
  echo "</form>\n";
  echo "</table></td></table>";
  // end of input table
  unreg_sess_var("projectlist");
  unreg_sess_var("userlist");
}

//******************
//statistic list
// *****************

elseif ($projectlist[0] and $userlist[0]) {
  // show separator in big table
  // title
  echo "<b>Projekt Statistik</b> &nbsp; &nbsp; $proj_start: $anfang, $proj_end: $ende\n";
  // print button ...
  echo "&nbsp;<a href='javascript:self.print()'>$print</a>&nbsp;\n";
  // and 'back' button
  echo "&nbsp;<a href='projects.php?mode=stat&anfang=$anfang&ende=$ende&showbookingdates=$showbookingdates&showbookingnotes=$showbookingnotes$sid'>$back<br><br>\n";


  // check whether the given values are valid dates
  if (!checkdate(substr($anfang,5,2),substr($anfang,8,2) , substr($anfang,0,4))) { die("$m1_text5 <br>$back ..."); }
  if (!checkdate(substr($ende,5,2),substr($ende,8,2) , substr($ende,0,4))) { die("$m1_text5 <br>$back ..."); }
  if ($ende < $anfang) { die("$m1_text9"); }

  // fetch all projects from this group
  if ($projectlist[0] == "gesamt") {
    unset($projectlist);
    $result = db_query("select ID from projekte where $sql_user_group order by name") or db_die();
    while ($row = db_fetch_row($result)) { $projectlist[] = $row[0]; }
  }

  // fetch all users from this group
  if ($userlist[0] == "gesamt") {
    unset($userlist);
  if ($groups) {
    $result = db_query("select user_ID from grup_user, users where
                        grup_ID = '$user_group' and users.ID = user_ID order by users.nachname") or db_die();
  }
  else {
    $result = db_query("select ID from users where $sql_user_group order by nachname") or db_die();
  }
    while ($row = db_fetch_row($result)) { $userlist[] = $row[0]; }
  }

  // begin output table
  echo "<td><table border=1 cellpadding=1 cellspacing=0><tr><td><b>[h : m]</b></td>\n";

  // first row: the users!
  foreach ($userlist as $person) {
    $result = db_query("select kurz from users where ID = '$person'") or db_die();
    $row = db_fetch_row($result);
    echo "<td width=30>$row[0]</td>\n";
  }
  // end of the first row - display string 'sum'
  echo "<td><b>$sum</b>\n";
  echo "</tr>\n";

  // now loop over project list
  foreach ($projectlist as $project) {

    // alternate tr colour
    if (($cnr/2) == round($cnr/2)) { $color = "$bgcolor1"; $cnr++;}
    else { $color = "$bgcolor2"; $cnr++; }

    // print project name
    $result = db_query("select name from projekte where ID = '$project'") or db_die();
    $row = db_fetch_row($result);
    echo "<tr bgcolor=$color><td>$row[0]</td>\n";

    // loop over list of persons and fetch the bookings
    foreach ($userlist as $person) { fetch_bookings($project, $person); }

    // at the end of the row: display sum for this project
    $h = floor($sumproject[$project]/60);
    $m = $sumproject[$project] - $h*60;
    echo "<td><b>$h : $m</b></td>\n";
    echo "</tr>\n";
  }

  // last row: show sums for the projects
  echo "<tr><td><b>$sum</b></td>\n";
  foreach ($userlist as $person) {
   $h = floor($sumperson[$person]/60);
   $m = $sumperson[$person] - $h*60;
   // sum up for totalsum
   $totalsum += $sumperson[$person];
   echo "<td><b>$h : $m</b></td>";
  }

  // display total sum in the last cell of the table and close the table
   $h = floor($totalsum/60);
   $m = $totalsum - $h*60;
  echo "<td><b>$h : $m</td></tr>\n";
  echo "</table></td></table><br><br>";

  /*
  // print button ...
  echo "&nbsp;<a href='javascript:self.print()'>$print</a><br>\n";
  // and 'back' button
  echo "&nbsp;<a href='projects.php?mode=stat&anfang=$anfang&ende=$ende&showbookingdates=$showbookingdates&showbookingnotes=$showbookingnotes$sid'>$back\n";
  */

  // register the pojectlist and the participants so the user won't have to select them again
  reg_sess_vars(array("projectlist","userlist"));

}


function fetch_bookings($project, $person) {
  global $anfang, $ende, $show_bookings, $sumperson, $sumproject, $showbookingdates, $showbookingnotes;

  // start table cell
  echo "<td>";

  // open the table of bookings if flag is set
  if ($showbookingdates) { echo "<table cellspacing=0 cellpadding=1 border=1 rules=none width=100%>\n"; }

  // fetch values from time card bookings  the bookings are between start and end time
  $result = db_query("select * from timeproj where projekt = '$project' and users = '$person' and datum >= '$anfang' and datum <= '$ende' order by datum");
  while ($row = db_fetch_row($result)) {

    // detailed booking display?
    if ($showbookingdates) {
      echo "<tr><td>$row[3] - $row[4] : $row[5]&nbsp;</td>";
      if ($showbookingnotes) { echo "<td align=right>$row[7]&nbsp;</td>"; }
      echo "</tr>\n";
    }

    // sum up
    $sum1 = $sum1 + $row[4]*60+$row[5];
    $datum = $row[3];
    $pers_ID = $row[1];
    $proj_ID = $row[2];
  }

  // close the table of bookings if flag is set
  if ($showbookingdates) { echo "</table>\n"; }

  // build hours and minutes of the sum and display it
  $h = floor($sum1/60);
  $m = $sum1 - $h*60;
  echo "$h : $m</td>\n";

  // add sum to the overall sum of this person
  $sumperson[$person] += $sum1;
  $sumproject[$project] += $sum1;
}

function show_projects($parent_ID) {
  global $indent, $user_kurz, $leader, $sql_user_group, $projectlist;

  // fetch parent project
  $result = db_query("select ID, name, personen, chef from projekte where parent = '$parent_ID' and $sql_user_group order by name") or db_die();
  while ($row = db_fetch_row($result)) {

    // identify user as project leader, flag for later use at users list
    if ($row[3] == $user_kurz) { $leader = 1; }
    if (ereg("\"$user_kurz\"",$row[2]) or $row[3] == $user_kurz ) {
      echo "<option value='$row[0]'";
      if ($projectlist[0] and in_array($row[0], $projectlist)) { echo " selected"; }
      echo ">";
      for ($i = 1; $i <= $indent; $i++) { echo "&nbsp;&nbsp;"; }
      echo "$row[1]</option>\n";
    }

    // look for subelements
    $indent++;
    show_projects($row[0]);
    $indent--;
  }
}

?>
