<?php

// calendar_view.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Authors: Albrecht Guenther, Dieter Fiebelkorn, Norbert Ku:ck

// formerly m1.php (including all the calendar_view files)
// coordinate the calendar views

$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;
#############################################
// fallback if no settings are done
if(!$screen) $screen=800;                  // width of the screen/browser window px
if(!$cal_leftframe) $cal_leftframe=210;    // width of the left frame in new calendar px
if(!$timestep_daily) $timestep_daily=15;   // timestep of single day view
if(!$timestep_weekly) $timestep_weekly=30; // timestep of single week view 
if(!$ppc) $ppc = 6;                        // px per char for new calendar (not exact in case of proportional font)
if(!isset($cut))$cut=1;                    // cut the event text length yes:1 no:0
$wd_date = 10 * $ppc;                      // coloumn width
$wd_time = 4 * $ppc;
$wd_week = 2 * $ppc;
#############################################

function add_res($row, $text, $img = 0) {
  global $img_path;
  $result2 = db_query("select name from ressourcen,termine_res_rel where ressourcen.ID = res_ID AND termin_ID = '$row[0]'") or db_die();
  while ($row2 = db_fetch_row($result2)) {$ress2 .= $row2[0] . "\n"; }
  if($ress2){
    $ress2 = chop($ress2);
    if($img) $text = "<img src=$img_path/g.gif alt='$ress2' title='$ress2' width=7 border=0>&nbsp;".$text;
    else $text = $ress2;
  }
  return $text;
}

function calc_wd($offset,$cols){
  global $cal_wd, $wd, $ppc, $t_len;
  // width of text coloumn
  $wd=floor(($cal_wd - $offset - (2 * $cols))/$cols);
  // length of text
  $t_len=floor($wd/$ppc);
}
// end of functions

echo "<html><head><link rel=stylesheet type='text/css' href='$css_style'>$lang_cfg</head><body bgcolor=$bgcolor3>\n";
echo "<script language='JavaScript' src='calendar.js' type='text/javascript'></script>\n";

if($view){
  // Initialize users or resources from profile
  if ($gru) {
    if ($gru == "ress") {
      unset($ressource);
      $result = db_query("select ID from ressourcen") or db_die();
      while ($row = db_fetch_row($result)) $ressource[] = $row[0];
    } 
    else {
      unset($pers);
      $result = db_query("select personen from profile where ID ='$gru'") or db_die();
      $row = db_fetch_row($result);
      $pers = unserialize($row[0]);
    }
  }
  if (count($pers)==0) $pers[0] = $user_kurz; 
  if(count($pers) + count($ressource) > 1) {if ($mode <= 4) $mode += 4;}
  elseif ($pers[0]) {
    $result = db_query("select ID from users where kurz = '$pers[0]'");
    $row = db_fetch_row($result);
    if($row[0] != $user_ID) {$u_r_ID = $row[0]; $isRess = '0';}
  }
}

if (strlen($month) == 1) { $month = "0".$month; }
if (strlen($day) == 1) { $day = "0".$day; }

$datum = "$year-$month-$day";
$cal_wd =($screen - $cal_leftframe - ($nav_pos * $nav_space) - 45);

// include the current view
switch($mode){
  case 1:
    // view single day
    calc_wd(0,2);
    $time_step = $timestep_daily;
    include_once("./calendar_view1.php");
    break;
  case 2:  
    //weekly view
    calc_wd($wd_time,7);
    $tinterval = $timestep_weekly;
    include_once("./calendar_view2.php");
    break;
  case 3:  
    // show list of events
    include_once("./calendar_view3.php");
    break;
  case 4:
  // show month view
    calc_wd(0,7);
    include_once("./calendar_view4.php");
    break;
  case 5:  
  case 6:  
  case 8:
    // group view
    include_once("./calendar_viewx.php");
    break;
  case "year":
    // show year view
    // month coloumn width
    $wd=floor($cal_wd/2);
    // day number width
    $wd1=30;
    // text coloumn widt
    $wd2=$wd-$wd1;
    include_once("./calendar_viewy.php");
    break;
}
?>
</body>
</html>