<?php

// filemanager_data.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// check_role
if (check_role("filemanager") < 2) { die("You are not allowed to do this!"); }

$include_path2 = $path_pre."lib/permission.inc.php";
include_once $include_path2;
$include_path3 = $path_pre."lib/access.inc.php";
include_once $include_path3;
// load scramble routine if the file names should be scrambled
if ($dat_crypt) {
  $include_path4 = $path_pre."lib/scramble.inc.php";
  include_once $include_path4;
}
// load crypt routine if the file content should be crypted
if ($cryptstring) {
  $include_path5 = $path_pre."lib/crypt.inc.php";
  include_once $include_path5;
}


function update_record() {
  global $ID, $dat_crypt, $dateien, $acc, $profil, $persons, $kat, $kat2, $typ, $parent, $datei_text23, $dat_crypt,
         $dbIDnull, $user_ID, $remark, $dbTSnull, $project, $filename, $userfile, $userfile_size, $userfile_name,
         $c_m, $cryptstring, $cryptstring2, $locked, $contact, $versioning, $acc_write, $user_kurz;

  // check permission
  // first check whether this file is open for other people to write
  $result = db_query("select von, acc, acc_write from dateien where ID = '$ID'");
  $row = db_fetch_row($result);
  // file is free to write by somebody else
  if ($row[2] == "w") {
    // so check now whether the user is privileged for this
      if ($row[0] <> $user_ID and $row[1] <> "group" and !ereg("\"$user_kurz\"",$row[1])) { die("You are not privileged to do this!"); }
    }
  // file is not free? maybe he's at least the author ...
  else { check_permission("dateien","von",$ID); }
  // end check permission

  // check for the same record name if filename scrambling is not active
  if (!$dat_crypt) { check_name(); }

  // patch for some databases: if '$project' is empty, ssign a zero for it
  if (!$project) { $project = "0"; }

  // if versioning is allowed, add a 'v' to the filetype
  if (ereg("f",$typ)) {
    if ($versioning) { $typ .= "v"; }
    else { $typ = "f"; }
  }

  // assign acc_group and category
  assign_acc();
  assign_cat();

  // fetch missing values from old record
  $result = db_query("select * from dateien where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);

  // ***************************
  // copy record with new values
  if ($c_m == "c") {
    // Copying only with scrambled filenames
    if (ereg("f",$typ)) {
      $filename = $row[2];
      // copy a file in the same directory is not possible
      if ($parent == $row[11]) { echo "$datei_text23"; $error = 1; }
      // scramble filename
      $newfilename = scramble();
      // copy file to new place
      copy_file($row[9],$dateien,$newfilename,$dateien);
    }

    // define the locking status
    $locked = define_locking_status($ID);

    // no error? -> update record in db
    if (!$error) { $result = db_query("insert into dateien values(
                   $dbIDnull,'$user_ID','$filename','$remark','$kat','$acc','$dbTSnull','$row[7]','$row[8]',
                   '$newfilename','$row[10]','$parent','$project','$row[13]','$row[14]',
                   '$row[15]','$locked','$contact')") or db_die();
    }
  } // end copy a file


  // *******************
  // update or move item
  else {
    // if it's a file and new upload -> replace file
    if (ereg("f",$typ) and $userfile <> "none" and $userfile) {

      //check whether it's really an upload - not activated since it only runs with php > 4.0.2
      //check_upload($userfile);

      // set filename and build string for db query
      $filename = replace_blanks($userfile_name);
      $stringfilename = "filename='$filename',";
      $stringfilesize = "filesize='$userfile_size',";

      // scrambled filenames? -> use old filename
      if($dat_crypt) { $file = $row[9]; }
      // else: take new filename for storage
      else { $file = $filename; }

      // delete old file
      delete_file($file);

      // action: copy file!
      // first case: no file content encryption
      if (!$cryptstring) {
        // fetch file from tmp directory and move it into specified dir ...
        copy_file($userfile,"",$file,$dateien);
      }
      // oh, crypting!! :-)
      else {
        copy_crypt($userfile,$file,$dateien,$cryptstring, $cryptstring2);
        $cryptstring = encrypt($cryptstring, $cryptstring);
      }

      // last action - count the version number one up
      // exception: this file has a flag for versioning
      $result = db_query("update dateien set version = version+1 where ID = '$ID'") or db_die();
    }

    // next case: move or update existing file -> carry password
    elseif (ereg("f",$typ) and ($userfile == "none" or !$userfile)) { $cryptstring = $row[13]; }

    // for dir and link: assign new filename
    elseif (!ereg("f",$typ)) { $stringfilename = "filename='$filename',";}

    // following parameters can only be set by the author: 1. read access, 2. write access, 3. directory
    if ($row[1] == $user_ID) {
      $acc_string = " acc='$acc',";
      $acc_write_string = "acc_write = '$acc_write',";
      $parent_string = "div1='$parent',";

      // if versioning is allowed, add a 'v' to the filetype
      if (ereg("f",$row[10])) {
        if ($versioning) { $version_string = "typ = 'fv',"; }
        else { $version_string = "typ = 'f',"; }
      }
    }
    // otherwise a dummy string :)
    else {
      $acc_string = "";
      $acc_write_string = "";
      $parent_string = "";
      $versionstring = "";
    }

    // define the locking status
    $locked = define_locking_status($ID);

    // finally: the db action :)
    $result = db_query("update dateien set $stringfilename
                                           $stringfilesize
                                           remark='$remark',
                                           kat='$kat',
                                           $acc_string
                                           $parent_string
                                           div2='$project',
                                           datum='$dbTSnull',
                                           pw='$cryptstring',
                                           $acc_write_string
                                           $version_string
                                           lock_user = '$locked',
                                           contact = '$contact' where ID ='$ID'") or db_die();
  }
}

//insert a link or a directory
function insert_link() {
  global $filename, $dbIDnull, $user_ID, $remark, $kat, $acc, $dbTSnull, $user_group, $filepath, $typ,
         $parent, $project, $datei_text1, $locked, $contact;

  // assign acc_group and category
  assign_acc();
  assign_cat();

  // patch for some databases: if '$project' is empty, ssign a zero for it
  if (!$project) { $project = "0"; }

  // filename doesn't exists?
  if (!$filename) { echo "$datei_text1"; }

  // everythings fine? -> insert record into database
  $result = db_query("insert into dateien values($dbIDnull,'$user_ID','$filename','$remark','$kat','$acc','$dbTSnull',
                      0,'$user_group','$filepath','$typ','$parent','$project',null,'$acc_write',null,null,'$contact')") or db_die();
}

// insert a new file
function insert_file() {
  global $userfile, $userfile_size, $userfile_name, $datei_text1, $sid, $kat, $remark, $back, $dat_crypt, $sql_user_group,
         $datei_text2, $overwrite, $user_ID, $datei_text12, $dateien, $dat_rel, $parent, $path_pre, $dbIDnull,
         $acc, $dbTSnull, $user_group, $typ, $project, $cryptstring, $cryptstring2, $locked, $file, $acc_write, $versioning;

  // patch for some databases: if '$project' is empty, ssign a zero for it
  if (!$project) { $project = "0"; }

  // if versioning is allowed, add a 'v' to the filetype
  if ($versioning) { $typ = "fv"; }
  else { $typ = "f"; }

  // assign acc_group and category
  assign_acc();
  assign_cat();

  // see whether the user specified a file
  if (!$userfile or !$userfile_size) { die("$datei_text1! <br><a href='filemanager.php?mode=forms&kat=$kat&remark=$remark$sid'>$back</a> ..."); }
  // replace blanks in the filename with  so there won't be any problems while transmitting the data for the download
  $newfilename = replace_blanks($userfile_name);

  //NO filename scrambling: check for a file with the same name
  if (!$dat_crypt) {
    // loop over all files
    $result = db_query("select ID, filename, von from dateien where filesize > 0") or db_die();
    while ($row = db_fetch_row($result)) {
      // file with the same name found!!
      if ($row[1] == $userfile_name) {
        // check if overwriting is o.k.
        check_overwrite();
        // check owner
        check_owner();
        // first delete old record ...
        $result = db_query("delete from dateien where ID = '$row[0]'") or db_die();
        // ... then the file itself
        delete_file($row[1]);
      }
    }
  }

  // filename scrambling system
  else {
    // loop over all objects with the same name in the same virtual directory
    $result = db_query("select ID, filename, tempname from dateien where von = $user_ID and
                        filesize > 0 and div1 like '$parent' and $sql_user_group") or db_die();
    while ($row = db_fetch_row($result)) {
      // same name? -> delete file
      if ($row[1] == $userfile_name) {
        // check if overwriting is o.k.
        check_overwrite();
        // first delete old record ...
        $result = db_query("delete from dateien where ID = '$row[0]'") or db_die();
        // ... then the file itself
        delete_file($row[2]);
      }
    }
    // scramble filename
    $newfilename = scramble();
  }

  // first case: no file content encryption
  if (!$cryptstring) {
    // fetch file from tmp directory and move it into specified dir ...
    copy_file($userfile,"",$newfilename,$dateien);
  }
  // oh, crypting!! :-)
  else {
    copy_crypt($userfile,$newfilename,$dateien,$cryptstring, $cryptstring2);
    $cryptstring = encrypt($cryptstring, $cryptstring);
  }

  // ... and check whether the file really went into the directory! if not: give some advices
  if (!file_exists($path_pre."$dat_rel/$newfilename")) {
    die( "Oops! Something went wrong ...<br>Please check whether the file exists in the upload directory<br>
    (Maybe the webserver is not allowed to copy the file from the tmp dir into the upload dir)<br>
    and the variable dat_rel in the config has the correct value.<br>
    Typical values would be:<br> dateien = \"/usr/local/httpd/phprojekt/file\";
    and dat_rel = \"file\"; for Linux or dateien = \"c:\htdocs/phprojekt/file\"; and dat_rel = \"file\"; for windows");
  } // end check

  // final action: write into db
  $result = db_query("insert into dateien values($dbIDnull,'$user_ID','$userfile_name','$remark','$kat','$acc',
                     '$dbTSnull','$userfile_size','$user_group','$newfilename','$typ','$parent','$project',
                     '$cryptstring','$acc_write','0','$locked','$contact')") or db_die();
}

// this function encrypts the incoming file and copies into the upload dir
function copy_crypt($userfile,$newfilename,$dateien,$cryptstring,$cryptstring2) {
  global $datei_text28, $back;

  // first check whether the two passwords are the same
  if ($cryptstring != $cryptstring2) { die("<h3>$datei_text28! <a href='filemanager.php?mode=forms&action=upload'>$back ...</a></h3>"); }

  // then create an appropiate string:
  //1. crypt the password ...
  $cryptstring = encrypt($cryptstring, $cryptstring);
  $bytes = 65536;
  // 2: string must be longer than the content piece
  for ($i = 0; $i <= floor($bytes/strlen($cryptstring)); $i++) $pwnew .= $cryptstring;
  // then open both files
  $old = fopen($userfile, "rb");
  $new = fopen($dateien."/".$newfilename, "w");
  // crypt the content and write it into the new file
  while($line = fread($old, $bytes)):
    $line2 = $line ^ $pwnew;
    fputs($new, $line2);
  endwhile;
  // close both files
  fclose($old);
  fclose($new);
}


function replace_blanks($oldfilename) {
  $newfilename = ereg_replace(" ","",$oldfilename);
  return $newfilename;
}

function delete_file($filename) {
  global $dateien;
  $path = $dateien."/".$filename;
  unlink($path);
}

function copy_file($oldfilename, $olddir, $newfilename, $newdir) {
  if ($olddir <> "") { $old_path = $olddir."/".$oldfilename;  }
  else { $old_path = $oldfilename;  }
  if ($newdir <> "") { $new_path = $newdir."/".$newfilename; }
  else { $new_path = $newfilename; }
  copy($old_path,$new_path);
}

function check_overwrite() {
  global $overwrite, $datei_text2, $sid, $acc, $kat, $remark, $back;
  if (!$overwrite) { die("$datei_text2! <br><a href='filemanager.php?mode=forms&acc=$acc&kat=$kat&remark$remark$sid'>$back</a>"); }
}

function check_owner() {
  global $row, $user_ID, $datei_text12, $sid, $acc, $kat, $remark, $back;
  if ( $row[2] <> $user_ID) { die("$datei_text12 <br><a href='filemanager.php?mode=forms&acc=$acc&kat=$kat&remark=$remark$sid'>$back</a>"); }
}

// delete records from database
function delete_record() {
  global $ID, $dat_crypt, $dateien;
  // check persmission
  check_permission("dateien","von",$ID);
  // fetch file name etc.
  $result = db_query("select ID, filename, tempname, typ, filesize from dateien where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);
  // only delete file when it is not a link
  if ($row[4] > 0) {
    if ($dat_crypt) { $path = "$dateien/$row[2]"; }
    else {$path = "$dateien/$row[1]"; }
    unlink($path);
  }
  $result2 = db_query("delete from dateien where ID = '$ID'") or db_die();
  if ($row[3] == "d" or $row[3] == "fv") del($row[0]); // look for files in the subdirectory
  $action = "";
}

// delete subdirectories
function del($ID) {
  global $dateien, $dat_crypt;
  $result = db_query("select ID, filename, tempname, typ, filesize from dateien where div1 = '$ID'") or db_die();
  while ($row = db_fetch_row($result)) {
    // only delete file when it is not a link
    if ($row[4] > 0) {
      if ($dat_crypt) { $path = "$dateien/$row[2]"; }
      else {$path = "$dateien/$row[1]"; }
      unlink($path);
    }
    $result2 = db_query("delete from dateien where ID = '$row[0]'") or db_die();
    if ($row[3] == "d") del($row[0]); // look for files/links etc. in the subdirectory
  }
}

// check for same record name
function check_name() {
  global $sql_user_group, $ID, $filename, $typ, $datei_text19, $sid, $back;
  $result = db_query("select ID, filename, typ from dateien") or db_die();
  while ($row = db_fetch_row($result)) {
    if ($row[0] <> $ID and $row[1] == $filename and ereg("f",$row[2])) { die("$datei_text19! <br><a href='filemanager.php?mode=forms$sid'>$back</a>"); }
  }
}

// assign category
function assign_cat() {
  global $kat, $kat2;
  // if no manual category is given, use the one from the select box
  if (!$kat) { $kat = $kat2; }
}

// function is not active since some installations still run on php version > 4.0.3
function check_upload($userfile) {
  if (!is_uploaded_file($userfile)) die("oops, the uploaded file is not in the upload directory!");
}

// this routine sends out an email notification to all users of the group which have access to the file
function notify_members() {
  global $acc, $o_files, $filename, $userfile_name, $lib_path, $acc;

  // if the object is a filem, assign the value to $filename. For links and directories the value is already in $filename
  if ($userfile_name) { $filename = $userfile_name; }

  // record free for all users of this group?
  if ($acc == "group") { $acc = "all"; }
  // or personal?  -> end this routine
  elseif ($acc == "private") { return 1; }

  // include the library from lib
  include_once("$lib_path/email_notification.inc.php");
  // call routine to send mails with notification about the new record
  email_notification($o_files, $acc, $filename);

}

// the locking status needs to be defined
function define_locking_status($ID) {
  // $lock and $unlock are the respective values from the form
  global $lock, $unlock, $user_ID;

  // fetch value from db
  $result = db_query("select von, lock_user from dateien where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);

  // checkbox 'lock this field' has been selected by the user
  if ($lock) {
    // simply return the user_ID of this user
    return $user_ID;
  }
  elseif ($unlock) {
    // first check whether this user has the right to unlock the file
    if ($row[0] <> $user_ID and $row[1] <> $user_ID) { die("You are not privileged to do this"); }
    // now unlock the file by deleting the old value in this db field
    return 0;
  }
  // no action at all? return the old value from the db record ...
  else { return $row[1]; }
}

if ($action == "delete") { delete_record(); }
elseif ($action == "update") { update_record(); }
elseif ($action == "link" or $action == "dir") { insert_link(); }
elseif ($action == "upload") { insert_file(); }

// extra routine: notify colleagues about the new record
if ($filemanager_notify and $notify) { notify_members(); }


// everythings fine? -> show the normal list ath the end of the script
include_once("./filemanager_view.php");

?>
