<?php

// filemanager_down.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther


// Needed for older PHPs
global $HTTP_SERVER_VARS;

// some security measures:
// 1. intialise the array so noone can introduce poisoned variables
$arr = array();

// include lib to fetch the sessiond data and to perform check
$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;

// check_role
if (check_role("filemanager") < 1) { die("You are not allowed to do this!"); }

// explode the array element given by the transferred number
$arr = explode("|",$file_ID[$nr]);
// build name and path
$name = $arr[0];
$path = "../".$dat_rel."/".$arr[1];
$name = ereg_replace(""," ",$name);
if (!file_exists($path)) { die("panic! specified file not found ..."); }

// security measure: Prevent escaping from the attach dir
if ((ereg('/', $arr[1])) or (ereg('^\.+$', $arr[1]))) { die("You are not allowed to do this!");  }

// security measure: check the permission of the user

check_permission($arr[2]);

// session_cache_limiter('public');   // suppress error messages for PHP version < 4.0.2

// include content type definition
$include_path = $path_pre."lib/get_contenttype.inc.php";
include_once $include_path;

// Send file contents, decrypt if needed
if (!$encryptstring) {
   // Just output the file
   readfile($path);
} else {
  // include the encryption routine
  $path_pre="../";
  $include_path = $path_pre."lib/crypt.inc.php";
  include_once $include_path;
  // first create an appropiate string:
  //1. crypt the password,
  //$encryptstring = encrypt($encryptstring, $encryptstring);
  $bytes = 65536;
  // 2: string must be longer than the content piece
  for ($i = 0; $i <= floor($bytes/strlen($encryptstring)); $i++) $pwnew .= $encryptstring;
  // open the file
  $file = fopen($path, "rb");
  while($line = fread($file, $bytes)) {
    // shift the content back ...
    $line2 = $pwnew ^ $line ;
    // output
    echo $line2;
  }
}

// check permission
function check_permission($file_ID) {
  global $user_ID, $user_kurz, $user_group;

  // fetch access data from this record
  $result = db_query("select von, acc, gruppe from dateien where ID = '$file_ID'") or db_die();
  $row = db_fetch_row($result);
  // permission denied if:
  // 1. in group system the user in a wrong group
  // or
  // the user is not the owner, the file is not public or the user is not on the list of the privileged persons
  if (($user_group <> "" and $row[2] <> $user_group) or 
      ($row[0] <> $user_ID and $row[1] <> 'group' and !eregi("\"$user_kurz\"",$row[1]))) {
    die("You are not allowed to do this");
  }
}
?>