<?php
// mail_fetch.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// check role
if (check_role("mail") < 1) { die("You are not allowed to do this!"); }

// compose connect string
$acc_t = $row[4];
$acc_string = "\{$row[3]/$acc_t:$port[$acc_t]}INBOX";

// open  gate to mailserver
$link2 = imap_open($acc_string,$row[5],$row[6]);
// access failed? -> give message
if (!$link2) {
  echo "<b>$mail_text27 $row[2]!</b>:<br>".imap_last_error(). "<br>";
  $error = 1;
}

// ****************************
// access ok? -> fetch messages
if (!$error) {
  $n_deleted = 0;

  // display information & status, close and reopen again for fetching mails.
  $check = imap_mailboxmsginfo($link2);
  $list_mails = "<br>$user_name / $row[2]: $check->Nmsgs $items2 ($check->Size Bytes) ";

  // headers
  $headers=imap_headers($link2);
  for($x=1; $x <= count($headers); $x++) {
  
    $head = imap_header($link2,$x);
    // header information
    $date = $head->date;
    $email["date"] = strftime("%Y%m%d%H%M%S",$head->udate);
    // save header in field for later db storage
    if ($save_mail_header) { $email[header] = imap_fetchheader($link2,$x); }
    else { $email[header] = ""; }

    // create 'from' string
    $from_head  = $head->from[0];
    // in case the name variable is empty, take the value from the mailbox

    $sender=imap_mime_header_decode($from_head->personal);
    $from_head->personal = addslashes($sender[0]->text);

    if ($from_head->personal == "") { $from_head->personal = $from_head->mailbox."@".$from_head->host; }
    $email[sender] = $from_head->personal."<".$from_head->mailbox."@".$from_head->host.">";

    // create 'to' string
    $i = 0;
    $email[recipient] = "";
    while ($head->to[$i] <> "") {
      $to_head = $head->to[$i];
      $to_head_pers = imap_mime_header_decode($to_head->personal);
      $to_head_personal = addslashes($to_head_pers[0]->text);
      if ($to_head_personal == "") { $to_head_personal = $to_head->mailbox."@".$to_head->host; }
      if ($i > 0) $email[recipient] .= ", ";
      $email[recipient] .= $to_head_personal."<".$to_head->mailbox."@".$to_head->host.">";
      $i++;
    }

    // create 'cc' string
    $i = 0;
    $email[cc] = "";
    while ($head->cc[$i] <> "") {
      $cc_head = $head->cc[$i];
      $cc_head_pers = imap_mime_header_decode($cc_head->personal);
      $cc_head_personal = addslashes($cc_head_pers[0]->text);
      if ($cc_head_personal == "") { $cc_head_personal = $cc_head->mailbox."@".$cc_head->host; }
      if ($i > 0) $email[cc] .= ", ";
      $email[cc] .= $cc_head_personal."<".$cc_head->mailbox."@".$cc_head->host.">";
      $i++;
    }

    // reply to
    $reply_to_head = $head->reply_to[$i];
    $reply_to_head_pers = imap_mime_header_decode($reply_to_head->personal);
    $reply_to_head_personal = addslashes($reply_to_head_pers[0]->text);
    if ($reply_to_head_personal == "") { $reply_to_head_personal = $reply_to_head->mailbox."@".$reply_to_head->host; }
    $email[reply_to] = $replyto_head_personal."<".$replyto_head_mailbox."@".$replyto_head_host.">";

    // subject
    $subject=imap_mime_header_decode($head->subject);
    $email[subject] = chop(addslashes($subject[0]->text));
    // no text in subject? -> default text
    if ($email[subject] == "") { $email[subject] = "[$mail_text1]"; }

    // if the user just want to get the maillist displayed
    if ($view_only) { 
      $mail_arr[$email[subject]] = $email[sender];
    }
    // in all other cases store the mails in the database
    else {

      // body
      // first get the  plain part ...
      $body_tmp = get_part($link2, $x, "TEXT/PLAIN");
      $body_tmp1 =imap_mime_header_decode($body_tmp);
      $email[body_text] = addslashes(ereg_replace("\r","",$body_tmp1[0]->text));
      // ... and then the html part
      $body_tmp = get_part($link2, $x, "TEXT/HTML");
      $email[body_html] = addslashes($body_tmp);

      // RULES
      // fetch rules, write to array
      $i = 0;
      $result2 = db_query("select * from mail_rules where von = '$user_ID'") or db_die();
      while ($row2 = db_fetch_row($result2)) {
        // assign incoming dir
        if ($row2[4] == "incoming") {$incoming = $row2[6]; }
        else {
          // write field and phrase in array
          $rules[$i] =  array("$row2[4]" => "$row2[3]");
          // create another array with the same counter, place target dir.
          $rules_action[$i] = $row2[7];
          $dir_ID[$i] = $row2[6];
          $i++;
        }
      }

      // check for applicable rule
      unset($action);
      unset($parents);
      // only one rule applicable at the moment, sorry.
      for ($i = 0; $i < count($rules); $i++) {
        // loop over all
        list($field, $keyword2) = each($rules[$i]);
        // special rule for body since we have to search through 2 fields
        if ($field  == "body") {
          if(eregi($keyword2,$email[body_text]) or eregi($keyword2,$email[body_html])) {
            $parent = $dir_ID[$i];
            $action = $rules_action[$i];
          }
        }
        else { // applicable for all other fields
          if ($email[$field]) {
            if(eregi($keyword2,$email[$field])) {
              $parent = $dir_ID[$i];
              $action = $rules_action[$i];
            }
          }
        }
      }

      // create loop for rules
      if ($action == "delete") {
        unset($parents);
        $n_deleted++; // raise number of deleted mails
      }
      // move -> sort into given dir
      elseif($action == "move") {
        $parents[0] = $parent;
      }
      // copy -> mail goes into given dir and in the root
      elseif($action == "copy") {
        $parents[0] = $parent;
        $parents[1] = 0;
      }
      // check for default rule
      elseif ($incoming > 0) {
        // any other rule already given? -> add the rule
        if ($parents[0] > 0) { $parents[1] = $incoming; }
        // not other rule? -> move into this folder
        else { $parents[0] = $incoming; }
      }
      // no rules -> normal save into root dir
      else {
        $parents[0] = 0;
      }

      $i = 0;
      while (isset($parents[$i])) {
        // save mail to db
        $result3 = db_query("insert into mail_client values($dbIDnull,'$user_ID','$email[subject]','$email[body_text]','$email[sender]','$email[recipient]','$email[cc]',null,null,'$dbTSnull',0,'m',$parents[$i],'$email[date]','$email[header]','$email[replyto]',null,'$email[body_html]')") or db_die();
        // fetch ID as reference for attachment storage
        $result3 = db_query("select max(ID) from mail_client where von = $user_ID and date_received like '$dbTSnull'") or db_die();
        $row3 = db_fetch_row($result3);
        $mail_ID = $row3[0];

        // attachments?
        $attach = imap_fetchstructure($link2,$x);
        $attachments = $attach->parts;

        // loop over all attachments
        for ($a=0; $a < count($attachments); $a++) {

          // check whether the info is in parameters or dparameters
          if ($attachments[$a]->ifparameters) $count = count($attachments[$a]->parameters);
          else $count = count($attachments[$a]->dparameters);

          for ($c = 0; $c < $count; $c++) {
            // same thing here: infos could be in parameters or dparameters
            if ($attachments[$a]->ifparameters) $param = $attachments[$a]->parameters[$c];
            else $param = $attachments[$a]->dparameters[$c];

            // fetch encoding
            $att_enc = $attachments[$a]->encoding;

            // fetch filesize
            $att_size = $attachments[$a]->bytes;

            // fetch attachment name
            if (eregi("name",$param->attribute))  {
              $att_name1 = $param->value;

              // decode name
              $att_name2 =imap_mime_header_decode($att_name1);
              $att_name = addslashes($att_name2[0]->text);
              // here is a workaround for a real strange problem - admins report that sometimes
              // the file name to store begins with a " ' " causing a sql error -> workaround: delete the ' :-))
              while (substr($att_name,0,1) == "'") { $att_name = substr($att_name,1); }
              // end bloody workaround :-()

              // fetch content of attachment
              $a1 = $a + 1;
              $att_content = imap_fetchbody($link2, $x, $a1);

              // decode
              if ($att_enc == 2) { $att_content = imap_binary($att_content); }
              if ($att_enc == 3) { $att_content = imap_base64($att_content); }
              if ($att_enc == 4) { $att_content = imap_qprint($att_content); }
              // save file, first create random name
              $att_tempname = "";
              srand((double)microtime()*1000000);
              $char = "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMANOPQRSTUVWXYZ";
              while (strlen($att_tempname) < 12) { $att_tempname .= substr($char,(rand()%(strlen($char))),1);}
              // add extension to random name
              $att_tempname .= substr($att_name,-4,4);
              // write file
              $att_file = $path_pre."attach/$att_tempname";
              $fp = @fopen($att_file,'w+');
              $fw = fwrite($fp,$att_content);
              fclose($fp);
              // write record to db
              // if the attachment hasn't any size, just tell it so :)
              if (!$att_size) $att_size = "0";
              $result3 = db_query("insert into mail_attach values($dbIDnull,$mail_ID,'$att_name','$att_tempname','$att_size')") or db_die();

            }
          }
        }  // end loop over attachments
        $i++;
      } // end loop over different rules
      // mark mails for later deletion if $no_del is not set.
      if (!$no_del) { imap_delete($link2, $x); }

    } // end bracket store mail
    if ($n_deleted > 0 and !$no_del) { echo " / $n_deleted $opt_bm9"; }
  } // end for each mail
  // delete marked mails in the mailbox
  imap_expunge($link2);
  // close access to mailbox
  imap_close($link2);
}

?>