<?php

// projects_gantt.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// assign colours to categories
$colours = array("#000000","#00ff00","#0000ff","#ffff00","#ff00ff","#00ffff","#800080","#c0c0c0","#008000","#000080",
                 "#808000","#ff0000");

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// include librry to sort the projects
include_once "./projects_sort.php";

  $values = 12;
  $pixel = 650;
  $width_proj_names = 100;
  if (!$scaling) $scaling = "auto";

// clear projectlist
$projectlist = array();

// define start and end time
define_timeframe(); 

// fetch list of projects
fetch_projects();

// **************
// business chart
// **************

if ($chart) {
  if (!is_file("$lib_path/chart/jpgraph.php")) { die("Panic - cannot include plot library!"); }
  include ("$lib_path/chart/jpgraph.php");
  include ("$lib_path/chart/jpgraph_gantt.php");
  
  $graph = new GanttGraph(0,0,"auto");
  $graph->SetBox();
  $graph->SetShadow();
  $graph->ShowHeaders(GANTT_HMONTH);
  $graph->scale->tableTitle->SetFont(FF_FONT1,FS_BOLD);
  $graph->scale->SetTableTitleBackground("silver");  
  $graph->scale->month->SetStyle(MONTHSTYLE_SHORTNAMEYEAR2);
  $graph->scale->month->SetFontColor("white");
  $graph->scale->month->SetBackgroundColor("blue");
  $graph->SetLabelVMarginFactor(1);  

  foreach ($projectlist as $project) {
    add_chart($project);
  }  
  $graph->Stroke(); 
}
else {  

  // **************
  // navigation bar
  // *************
  echo "<form action='projects.php' method=post>";
  if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type=hidden name='mode' value='gantt'>\n";
  echo "<table bgcolor=$bgcolor2><tr>\n";
  // manual scaling?
  echo "<td><input type=radio name=scaling value='manual'";
  if ($scaling == "manual") { echo " checked"; }
  echo ">\n"; 
  // box for start year
  echo "$proj_text6 <select name=start_year>\n";

  for ($i=2000; $i <= 2005; $i++) {
    echo "<option value=$i";
    if ($i == $start_year) { echo " selected"; }
    echo ">$i\n";
  }
  echo "</select>\n";
  // box for start month
  echo "<td><select name=start_month>\n";
  for ($i=1; $i <= 12; $i++) {
    if ($i < 10) { $j = "0".$i; }
    else { $j = $i; }
    echo "<option value=$j";
    if ($i == $start_month) { echo " selected"; }
    echo ">$j\n";
  }
  echo "</select>\n";
  // end year
  echo "<td>$proj_text7 <select name=end_year>\n";
  for ($i=2000; $i <= 2010; $i++) {
    echo "<option value=$i";
    if ($i == $end_year) { echo " selected"; }
    echo ">$i\n";
  }
  echo "</select>\n";
  // end month
  echo "<td><select name=end_month>\n";
  for ($i=1; $i <= 12; $i++) {
    if ($i < 10) { $j = "0".$i; }
    else { $j = $i; }
    echo "<option value=$j";
    if ($i == $end_month) { echo " selected"; }
    echo ">$j\n";
  }
  echo "</select> | \n";
  // automatic scaling

  echo "<input type=radio name=scaling value=auto";
  if ($scaling=="auto" or !$scaling) echo " checked";  
  echo ">$proj_text43</td></tr>\n";
  
  // second row of navigation table
  // check whether the user just wants to have one major project
  echo "<tr><td colspan=5>$proj_text28a: <select name=single_project><option value=0>\n";
  $query = "where $sql_user_group";
  // call function to show all required elemts in a tree structure in the select box
  show_elements_of_tree("projekte","name",$query,"personen"," order by name",$single_project,"parent",0);   
  echo "</select> | \n";
  
    // checkbox for option 'only display main projects
  echo "<input type=checkbox name=only_main value='1'";
  if($only_main) echo " checked";
  echo ">$proj_text28 | ";
  
  // show chart
  if ($chart_support) { echo "chart: <input type=checkbox name=chart>\n"; }
  
  // submit button
  echo "<td><input type=image src='$img_path/los.gif' border=0 id=tr></td>\n";
  echo "<td> |&nbsp;<a href='projects.php?mode=view$sid'>$back</a>\n";  
  echo "</tr></table></form>\n";
  
  // end navigation bar
  // *****************
    


  // *********
  //calc chart
  // *********
  
  //**************
  // display range

  echo "<br><table border=1 cellspacing=0 cellpadding=0><tr>\n";
  echo "<td>&nbsp;</td>\n";
  // write values
  $months = round((mktime(0,0,0,$end_month,1,$end_year)-mktime(0,0,0,$start_month,1,$start_year))/(86400*30))+1;
  
  // short range? -> print each month
  if ($months <= $values) {  
    $width = $pixel/$values;
    for ($i = 0; $i < $months; $i++) {
      $a = date("m.y", mktime(0,0,0,($start_month+$i),1,$start_year));
      echo "<td width=$width>$a</td>\n";
    }
    echo "</tr>\n";
  }
  // higher range: -> just x values
  else {
    // try to find within reasonable frame whether more values would fit it
    if ($months <= 24) $values = $months;
    // number of months which will fall additionally into the last table cell
    $last_part = (($months/$values)-(floor($months/$values)))*$values;
    for ($i = 0; $i < $values; $i++) {
      if ($i < ($values-1)) { 
        if ($last_part > 0) { 
        // calculate the width for all cells except the last one
          $total_width = $pixel - floor($pixel*($last_part/$months));
          $width = floor($total_width/$values);
        }
        else {
          $width = floor($pixel/$values); 
        }   
        $sumwidth = $sumwidth + $width;
      }
      else { 
        $width = $pixel - $sumwidth; 
      }
      $j = $i*floor($months/$values);
      $a = date("m.y", mktime(0,0,0,($start_month+$j),1,$start_year));
      echo "<td width=$width>$a</td>\n";
    }
    echo "</tr>\n";
  }
  // end display range
  // *****************
  

  // ******************
  // print the projects
  foreach ($projectlist as $project) {
   
    // check whether this project is within the timeframe
    if ( $project[3] < $anfang or $project[2] > $ende) {}
    else {
       
      // define left edge of block
      if ($project[2] <= $anfang) { 
        $edgeleft = 0;
        $t1 = 0;
      }
      else { 
        $st = explode("-",$project[2]);
        $edgeleft = floor((mktime(0,0,0,$st[1],$st[2],$st[0])-mktime(0,0,0,$start_month,$start_day,$start_year))/86400*$pixel/$range);
        $t1 = $edgeleft;
      }
      // define right edge of block
      if ($project[3] >= $ende) { $edgeright = $pixel; }
      else {
        $st = explode("-",$project[3]);
        $edgeright = $pixel - floor((mktime(0,0,0,$end_month,$end_day,$end_year)-mktime(0,0,0,$st[1],$st[2],$st[0]))/86400*$pixel/$range);
      }

      // indent as transparent img on the left side      
      if ($edgeright < $pixel) {
        $t2 = $pixel - $edgeright; 
      }
      else { $t2 = 0; }
      $w1 = $edgeright - $edgeleft;
      // first table cell: name of project and indentation
      $indent = "";
      for ($b = 0; $b < $project[7]; $b++) { 
        $indent .="&nbsp;&nbsp;&nbsp;&nbsp;"; 
        // $bgc = $bgcolor1; 
      }  
      echo "<tr><td width=$width_proj_names>&nbsp;".$indent.html_out($project[1])."&nbsp;</td>\n";
      
      // define bar - special workaround for NN4
      if (eregi("4.7|4.6|4.5", $HTTP_USER_AGENT)) {
        echo "<td colspan=$values bgcolor='#eeeeee'><table cellspacing=0 cellpadding=0><tr valign=bottom>
            <td valign=bottom><img src='$img_path/t.gif' width=$t1 height=5 border=0 vspace=5></td>
            <td valign=bottom><img src='$img_path/s.gif' width=$w1 height=5 border=0 vspace=5 alt='$project[2] - $project[3]' title='$project[2] - $project[3]'></td>
            <td valign=bottom><img src='$img_path/t.gif' width=$t2 height=5 border=0 vspace=5></td>
            </tr></table></td></tr>\n";        
      }
      else {
        echo "<td colspan=$values bgcolor='#eeeeee'><table cellspacing=0 cellpadding=0><tr valign=bottom>
            <td valign=bottom><img src='$img_path/t.gif' width=$t1 height=5 border=0 vspace=5 style='background-color:transparent'></td>
            <td valign=bottom><img src='$img_path/t.gif' width=$w1 height=5 border=0 vspace=5 style='background-color:".$colours[$project[6]]."' alt='$project[2] - $project[3]' title='$project[2] - $project[3]'></td>
            <td valign=bottom><img src='$img_path/t.gif' width=$t2 height=5 border=0 vspace=5 style='background-color:transparent'></td>
            </tr></table></td></tr>\n";  
      }     
    }     
  }
  echo "</table><br>";
  
  // add legend
  if (!$add_legend and !eregi("4.7|4.6|4.5", $HTTP_USER_AGENT)) {
    echo "<b>$proj_text44<table cellpadding=3 cellspacing=0 border=1><tr>";
    // no value
    echo "<td><img src='$img_path/t.gif' style='background-color:black' width=7> $proj_text45</td>\n";
    foreach($categories as $cat_ID => $cat_name) {
      echo "<td><img src='$img_path/t.gif' style='background-color:".$colours[$cat_ID]."' width=7> ".$cat_name."</td>\n";
    }
    echo "</tr></table>\n";
  }  
}  
  
  
  // end print projects
  // ************************

function define_timeframe() { 
  global $anfang, $ende, $sql_user_group, $start_month, $start_day, $start_year, 
  $end_day, $end_month, $end_year, $single_project, $scaling;
  
  // set lowest stat month and year
  if ($scaling == "auto") { 
    if ($single_project) {
      $result = db_query("select ID, name, anfang, ende, depend_proj from projekte where ID = '$single_project'") or db_die();
    }
    else {
      $result = db_query("select ID, name, anfang, ende, depend_proj from projekte where parent = 0 and $sql_user_group") or db_die();
    }
    while ($row = db_fetch_row($result)) {$projectlist[] = $row;}
      
    foreach ($projectlist as $project) {
      // lowest
      if (!$lowest) $lowest = $project[2];
      elseif ($project[2] < $lowest) $lowest = $project[2];
      // highest
      if (!$highest) $highest = $project[3];
      elseif ($project[3] > $highest) $highest = $project[3];      
    }  
    $start_month = substr($lowest,5,2);
    $start_year = substr($lowest,0,4);

    $end_month = substr($highest,5,2);
    $end_year = substr($highest,0,4);
  }
  $start_day = "01";
  $end_day = date("t", mktime(0,0,0,$end_month+1,0,$end_year));   
  $anfang = $start_year."-".$start_month."-".$start_day;
  $ende = $end_year."-".$end_month."-".$end_day;
  if ($ende <= $anfang) {
    $end_year = $start_year;
    $end_month = $start_month+1; 
    $ende = $end_year."-".$end_month."-".$end_day;
  }
}

function fetch_projects() {
  global $start_day, $start_month, $start_year, $end_day, $end_month, $end_year, $single_project, 
         $sql_user_group, $ende, $anfang, $only_main, $range, $projectlist, $level; 
  // fetch projects
  $range = floor((mktime(0,0,0,$end_month,$end_day,$end_year)-mktime(0,0,0,$start_month,$start_day,$start_year))/86400);
  // fetch a branch from a single project 
  if ($single_project) { $result = db_query("select ID, ende, anfang from projekte where ID = '$single_project'") or db_die(); }
  // fetch main projects
  else { $result = db_query("select ID, ende, anfang from projekte where parent = 0 and $sql_user_group order by name") or db_die(); } 
  while ($row = db_fetch_row($result)) {
  
    if ($row[2] <= $ende and $row[1] >= $anfang) { 
      $liste[] = $row[0]; 
    }
  }  
  // sort the projects on the main level
  if (!$single_project) $liste = projects_sort($liste);
  
  foreach ($liste as $ID) {
    $projectlist[] = $ID;
    $level = 0;
    // fetch subprojects
    if (!$only_main) {
      $level++;
      sub2($ID);
      $level --;
    } // end only main projects
  }  // end loop over all projects
  $projectlist = add_values($projectlist);
} // end function

// add subprojects to Gantt
function sub2($ID) {
  global $sql_user_group, $projectlist, $anfang, $ende, $level, $single_project;
  $result = db_query("select ID, ende, anfang from projekte where parent = '$ID' and $sql_user_group order by name") or db_die();
  while ($row = db_fetch_row($result)) { 
    if ($row[2] <= $ende and $row[1] >= $anfang) { $liste[] = $row[0]; }
  }  
  if ($liste[0] > 0) {
    // sort the projects on this sublevel
    $liste = projects_sort($liste); 

    foreach ($liste as $ID) { 
      $projectlist[] = $ID;
      $level++;
      sub2($ID);
      $level--;
    }
  }  
} 

function add_values($liste) {
  foreach ($liste as $project) {
    $result = db_query("select ID, name, anfang, ende, depend_proj, status, kategorie from projekte where ID = '$project'") or db_die();
    $row = db_fetch_row($result);
    $row[] = fetch_sublevel($row[0]);
    $projectlist[] = $row;
  }
  return $projectlist;  
} 

function fetch_sublevel($ID) {
  global $level;
  $level = 0;
  $result = db_query("select parent from projekte where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);
  if ($row[0] > 0) {
    fetch_sublevel2($row[0]);
  }
  return $level;
}

function fetch_sublevel2($ID) { 
  global $level;
  $result = db_query("select parent from projekte where ID = '$ID'") or db_die();
  while ($row = db_fetch_row($result)) {
    $level++;
    fetch_sublevel2($row[0]);
  }
}

// ************
// experimental

// chart part
function add_chart($project) {
  global $graph, $lib_path, $number;
  $number++;

  $activity = new GanttBar($number,$project[1],$project[2],$project[3],$project[5]);

  // Yellow diagonal line pattern on a red background
  $activity->SetPattern(BAND_RDIAG,"yellow");
  $activity->SetFillColor("red");

  // Set absolute height
  $activity->SetHeight(5);  
  // Specify progress to 60%
  $status = $project[5]/100;
  $activity->progress->Set($status);
  $activity->progress->SetPattern(BAND_HVCROSS,"blue");  

  // Finally add the bar to the graph
  $graph->Add($activity); 
} 



?>
