<?php

// timecard_data.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// check role
if (check_role("timecard") < 2) { die("You are not allowed to do this!"); }

// delete entry for a whole day
if ($action == "delete") {
  // check permission
  $result = db_query("select users, datum from timecard where ID = '$ID'") or db_die();
  $row = db_fetch_row($result);
  if ($row[0] == "") { die("no entry found."); }
  if ($user_ID <> $row[0]) { die("you are not privileged for this!"); }
  // db actions - delete record in timecard ...
  $result2 = db_query("delete from timecard where ID = '$ID'") or db_die();
  // ... and in timeproj as well
  $result2 = db_query("delete from timeproj where users = '$user_ID' and datum like '$row[1]'") or db_die();
}

//Nachtragen - insert afterwards
if ($action == "fills") {
  // filter all speacial characters ou of the time string
  $time = ereg_replace("[.:,;/]","",$time);
  // check whether $day and $time have a valid format
  if (!ereg("(^[0-9]*$)",$day) or !ereg("(^[0-9]*$)",$time) or substr($time,0,2) > 24 or substr($time,2,2) > 59) { echo "<br><b>$m1_text4</b>"; $error = 1; }

  // validate date
  if (!checkdate($month,$day,$year)) {echo "<br><b>$m1_text5 <br>$back ...</b>"; $error = 1;}
  
  // first option: it is a new record - no ID
  if (!$ID) {  
    // check whether this start time is not between start and end time of another record on this day
    $result = db_query("select anfang, ende from timecard where datum = '$datum' and users = '$user_ID'") or db_die();
    while ($row = db_fetch_row($result)) {
      // oh - start time is already in another record -> error
      if ($time >= $row[0] and $time <= $row[1]) {
        echo "<h4>$tc_text15</h4>\n"; 
        $error = 1;
      }
    }
    // insert record into database     
    if (!$error) {
      $result = db_query("insert into timecard values($dbIDnull,'$user_ID','$datum',null,'$time',null,null,null,null,null,null,null,null)") or db_die(); 
    }
  }
  // otherwise this user wants to enter the end time 
  else {  
    // check permission
    $result = db_query("select users, anfang from timecard where ID = '$ID'") or db_die();
    $row = db_fetch_row($result); 
    if ($row[0] <> $user_ID) { die("You are not allowed to do this"); }  
    
    // check whether
    // 1. end time is bigger than start time
    if ($row[1] >= $time) {
      echo "<h4>$tc_text18</h4>\n";
      $error = 1;
    }        
    // 2. end time is not in conflict with another record on this day    
    $result = db_query("select anfang, ende from timecard where datum = '$datum' and users = '$user_ID'") or db_die();
    while ($row = db_fetch_row($result)) {
      if ($time >= $row[0] and $row[1] > 0 and $time <= $row[1]) {
        echo "<h4>$tc_text15</h4>\n";
        $error = 1;
      }  
    }    
    // update the record in the db 
    if (!$error) { $result = db_query("update timecard set ende = '$time' where ID = '$ID'") or db_die();  }
  }

  // mail note to the chief
  if ($timecard == "2") {
    // group system?
    if ($groups and $user_group > 0) {
      // search for chef of the group - if ther is one!
      $result2 = db_query("select users.email from gruppen, users where 
                           gruppen.ID = '$user_group' and gruppen.chef = users.ID") or db_die();
      $row2= db_fetch_row($result2);
    }
    // no chief given or no group system available? -> then take the first available chief
    elseif ($row[0] == "" or !$groups) {
      $result = db_query("select email from users where acc like '%c%'") or db_die();
      $row = db_fetch_row($result);
    }
    // only send mail if a mail adress exists
    if ($row2[0] <> "") {
      if ($type == "anfang") $type2 = "$tc_text3";
      if ($type == "ende") $type2 = "$tc_text6";
      mail($row2[0], $tc_text21, "$user_name  - $datum - $type2: $time","From: $user_email \nReply-To:$user_email");
    }
  }// endif for mail note to the chief
}


// Projektbezug - assign to project
if ($action == "proj") {

  // check dates
  if (!ereg("(^[0-9]*$)",$day)) { die("<tr><td>$m1_text5 <br>$back ...");}
  if (!checkdate($month, $day, $year)) { die("<tr><td>$m1_text5 <br>$back ..."); }

  // loop over all entries
  for ($i = 0; $i < count($nr); $i++) {
    if ($timeproj_ID[$i]) {
      $result = db_query("update timeproj set h = '$h[$i]', m = '$m[$i]', note = '$note[$i]' where ID = '$timeproj_ID[$i]'") or db_die();
    }

    elseif ($h[$i] > 0 or $m[$i] > 0) {
      $result = db_query("insert into timeproj values($dbIDnull,'$user_ID','$nr[$i]','$datum','$h[$i]','$m[$i]',null,'$note[$i]',null,null,null)") or db_die();
    }
  }
}

// **********************************
// enter a record into the time sheet
// first the form, the database insert will be executed in the index.php

// begin of work time
if ($action == "1" and !$sure) {
  echo "<b><h3>$tc_text3</h3>\n";
  echo "<form action=../index.php method=post target=_top>\n";
  echo "<input type=hidden name='module' value='timecard'>\n";  
  if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type=hidden name=action value=1>\n";
  echo "<input type=hidden name=sure value=1>\n";
  echo "<input type=submit value=$tc_text1></form><br><br>\n";
}
// stop a running work time entry
elseif ($action == "2" and !$sure) {
  echo "<b><h3>$tc_text6</h3>\n";
  echo "<form action=../index.php method=post target=_top>\n";
  echo "<input type=hidden name='module' value='timecard'>\n"; 
  if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
  echo "<input type=hidden name=action value=2>\n";
  echo "<input type=hidden name=sure value=1>\n";
  echo "<input type=submit value=$tc_text1></form><br><br>\n";
}

// clock the time for a project
elseif ($action == "clock_in") {
  // find out whether there is already a record for today
  $result = db_query("select ID from timeproj where users='$user_ID' and datum='$today' and projekt='$projekt'") or db_die();   
  $row = db_fetch_row($result);  
  // record exist - add the timestamp
  if ($row[0] > 0) {
    $result = db_query("update timeproj set div1 = '$dbTSnull' where ID = '$row[0]'") or db_die();   
  }
  // otherwise create this record
  else {   
    $result = db_query("insert into timeproj values($dbIDnull,'$user_ID','$projekt','$today',null,null,null,null,null,'$dbTSnull',null)") or db_die();
  }
}

elseif($action == "clock_out") { 
  //calculate difference between clock_in and clock_out
  $result = db_query("select ID, div1, h, m from timeproj where users = '$user_ID' and div1 <> ''") or db_die();  
  $row = db_fetch_row($result);   
  // calculate the sconds of the quicktimer span
  $seconds1 = (substr($dbTSnull,8,2)- substr($row[1],8,2))*3600 + 
             (substr($dbTSnull,10,2)- substr($row[1],10,2))*60 +
             (substr($dbTSnull,12,2)- substr($row[1],12,2));
  // calculate the seconds of the existing value
  $seconds2 = $row[2]*3600 + $row[3]*60;
  $seconds = $seconds1 + $seconds2;           
  $h = floor($seconds/3600);
  $m = floor(($seconds - $h*3600)/60);
  $result = db_query("update timeproj set h='$h', m='$m',div1='', datum='$today' where ID = '$row[0]'") or db_die(); 
}


$action = "";
include_once("./timecard_view.php");

?>
