<?php

// admin.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

$file="admin";
$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;
$read_o = "disabled style='background-color:$bgcolor3;'";

// include the crypt function to encrypt passwords
if ($pw_crypt) {
  $include_path = $path_pre."lib/crypt.inc.php";
  include_once $include_path;
}
// include the ldap library
if ($ldap){
  $include_path2 = $path_pre."lib/ldapconf.inc.php";
  include_once $include_path2;
}

//only root can select a group
if ($group_select) { 
  $group_ID = $group_select;
  reg_sess_vars(array("group_ID"));
  $sql_group = "(gruppe = '$group_ID')";
}
// a group admin is assigned to his group
elseif ($user_group <> "") {
  $group_ID = $user_group;
  reg_sess_vars(array("group_ID"));
  $sql_group = "(gruppe = '$group_ID')";  
}
else { $sql_group = "(gruppe = '$group_ID')"; }

// list of available languages
$languages = array( "Andorran" => "ad", "Brazilian" => "br", "Catalan" => "ct", 
                    "China,P.R.C.(GB)" => "zh", "Czech" => "cz", "Danish" => "da", "Deutsch" => "de", "Dutch" => "nl",
                    "English" => "en", "Espanol" => "es", 
                    "Euskadi" => "ba", "Finnish" => "fi", "Franais" => "fr", "Greek" => "gr", "Hungarian" => "hu",
                    "Italiano" => "it", "Icelandic" => "is", "Korean" => "ko", "Norwegian" => "no",
                    "Portugues" => "pt", "Polish" => "pl", "Romanian" => "ro", "Russian" => "ru",
                    "Slovenian" => "si", "Slovak" => "sk", "Svenska" => "se", "Turkish" => "tr",
                    "Taiwan,R.O.C.(TW)" => "tw");

// array with the different user modes: u = normal user, c = user with chief status, a = administrator
$acc = array( "u" => "$admin_text93a", "c" => "$admin_text93b", "a" => "$admin_text93c" );
$vis = array( "y" => "$admin_text28a", "v" => "$admin_text28c", "n" => "$admin_text28b");
$acc_level = array( "0" => "$roles_text2", "1" => "$roles_text3", "2" => "$roles_text4");
// Actions after the dialog
// ******************
// right frame
// ******************

if ($framenr == "r") {
  echo "<html><head><link rel=stylesheet type='text/css' href='$css_style'><title>$admin_text1</title>$lang_cfg\n";
  echo "<script language='JavaScript' src='$lib_path/chkform.js' type='text/javascript'></script>\n";
  echo "</head><body bgcolor='$bgcolor3'>\n";
  echo "<br><br>";

  // ******************
  // groups, second dialog: create, modify, delete group
  // ******************
  if ($action == "groups") {
     //create a new group
    if ($neu and $mode <> "anlegen") {
      // extended value for the input field of the short name
      echo "<form action='admin.php' method='post' target='l' name='frm'>\n";
      echo "<table>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type='hidden' name='action' value='groups'>\n";
      echo "<input type='hidden' name='mode' value='anlegen'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      // input fields for groupname, short name and remark
      echo "<tr><td>$admin_text68: </td><td><input type='text' name='name' size='30'></td></tr>\n";
      echo "<tr><td>$admin_text69: </td><td><input type='text' name='kurz' size='10' maxlength='10'></td></tr>\n";
      echo "<tr><td>$admin_text71: </td><td><input type='text' name='bemerkung' size='30'></td></tr>\n";
      // if you create a new group, you can't assign a chief right now: yet no users in the group!
      echo "<tr><td>&nbsp;</td><td><input type=submit name='neu' value='$admin_text6'></td></tr></table></form>\n";
    }
    // modify existing group
    elseif ($aendern and $mode <> "anlegen") {
      $result = db_query("select * from gruppen where ID = '$group_nr'") or db_die();
      $row = db_fetch_row($result);
      echo "<form action='admin.php' method='post' target='l'>\n";
      echo "<table>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type='hidden' name='action' value='groups'>\n";
      echo "<input type='hidden' name='mode' value='anlegen'>\n";
      echo "<input type='hidden' name='group_nr' value='$group_nr'>";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      // name of the group
      echo "<tr><td>$admin_text68: </td><td><input type='text' name='name' value='$row[1]' size='30'></td></tr>\n";
      // short name can't be changed after creation -> only display
      echo "<tr><td>$admin_text69: </td><td>$row[2]&nbsp;</td></tr>\n";
      //echo "<tr><td>$admin_text70: </td><td><input type='text' name='kategorie' value='$row[3]' size='20'></td></tr>\n";
      echo "<tr><td>$admin_text71: </td><td><input type='text' name='bemerkung' value='$row[4]' size='30'></td></tr>\n";
      // select chef
      echo "<tr><td>$proj_chef: </td><td> <select name=chef> <option value='0'>\n";
      $result2 = db_query("select user_ID from grup_user where grup_ID = '$group_nr'") or db_die();
      while ($row2 = db_fetch_row($result2)) {
        // fetch name from users
        $result3 = db_query("select vorname, nachname from users where ID = '$row2[0]'") or db_die();
        $row3 = db_fetch_row($result3);
        echo "<option value='$row2[0]'";
        if ($row2[0] == $row[5]) { echo " selected"; }
        echo "> $row3[1], $row3[0]\n";
      }
      echo "<tr><td>&nbsp;</td><td><input type=submit name='aendern' value='$admin_text7'></td></tr></table></form>\n";
    }
    // confirm delete record, choose group to merge
    elseif($loeschen) {
      // delete default group forbidden
      echo "<br><br>$admin_text85:\n";
      echo "<form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type=hidden name='action' value='groups'>\n";
      echo "<input type=hidden name='group_nr' value='$group_nr'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<select name='merge_target'>\n";
      // show all groups except the chosen
      $result = db_query("select ID, name from gruppen where ID <> '$group_nr' order by name") or db_die();
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1]\n"; }
      echo "</select>&nbsp;\n";
      echo "<input type=submit name='loeschen' value='$submit'>\n";
    }
  }

  //**********
  //Timecard
  if ($action == "timecard") {

    //Modification
    if ($mode == "change") {
      if (!ereg("(^[0-9]*$)",$day) or !ereg("(^[0-9]*$)",$time)) { die("<br><b>$m1_text4<br><a href='admin.php?".SID."'>$back</a> ...</b>"); }
      if (strlen($time) == 3) { $anfang = "0".$anfang; } // Zeitangabe nur 3-stellig?
      if (!checkdate($month,$day,$year)) { die("<br><b>$m1_text5 <br><a href='admin.php?".SID."'>$back</a> ...</b>"); }
      if (strlen($month) == 1) { $month = "0".$month; } // Zeitangabe nur 3-stellig?
      $datum = $year."-".$month."-".$day;
      $result = db_query("select * from timecard where users = '$pers' and datum = '$datum'") or db_die();
      $row = db_fetch_row($result);
      if ($type == "ende" and $time <= $row[4]) { echo "$tc_text16"; $error = 1; } // Ende < Anfang!
      if ($type == "out_end" and ($time < $row[6])) { echo "$tc_text16"; $error = 1; } // Dienstgang Ende < Dienstgang Anfang!
      if ($type == "out_end" and $time > $row[5] and $row[5]) { echo "$tc_text16"; $error = 1; }  // Ende Dienstgang > Arbeitsende
      if ($type == "out_begin" and ($time <= $row[4])) { echo "$tc_text16"; $error = 1; } // Anfang Dienstgang < Anfang!

      if (!$error) {
        $result = db_query("select * from timecard where users = '$pers' and datum = '$datum'") or db_die();
        $row = db_fetch_row($result);
        if (!$row[0]) { $result = db_query("insert into timecard values($dbIDnull,'$pers','$datum',null,null,null,null,null,null,null,null,null,null)") or db_die(); }
        $result = db_query("update timecard set $type = '$time' where datum = '$datum' and users = '$pers'") or db_die();
      }
    }

    //Form
    $result = db_query("select nachname, vorname from users where ID = '$pers'") or db_die();
    $row = db_fetch_row($result);
    echo "<h5>$o_timecard: $row[0], $row[1]</h5>";
    echo "<form action='admin.php' method=post target='r'>";
    echo "<input type=hidden name='action' value='timecard'>\n";
    echo "<input type=hidden name='pers' value='$pers'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<table><td>$tc_text23: <select name=month>\n";
    // box for month and year
    for ($a=1; $a<13; $a++) {
      $mo = date("n", mktime(0,0,0,$a,1,$year));
      $name_of_month = $name_month[$mo];
      if ($mo == $month) {echo "<option value=$a selected>$name_of_month\n";}
      else {echo "<option value=$a>$name_of_month\n";}
    }
    echo "</select></td><td>\n";
    $y = date("Y");
    echo "<select name=year>&nbsp;\n";
    for ($i=$y-2; $i<=$y+5; $i++) {
      if ( $i == $year) {echo "<option selected>$i\n";}
      else {echo"<option>$i\n";}
    }
    echo "</select></td><td><input type=image src='$img_path/los.gif' border=0 id=tr></table></form>\n";

    // Modification form
    echo "<table cellspacing=1 cellpadding=1 border=1><tr bgcolor='$bgcolor2'>";
    echo "<br><br><form action='admin.php' method=post target='r'>";
    echo "<input type=hidden name='action' value='timecard'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>";
    echo "<input type=hidden name='mode' value='change'>";
    echo "<input type=hidden name='pers' value='$pers'>\n";
    echo "<input type=hidden name='month' value='$month'>\n";
    echo "<input type=hidden name='year' value='$year'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<tr><td>$m1_text13:&nbsp;<input type=text name=day maxlength=2 size=2 value=01></td>\n";
    echo "<td colspan=2>$tc_text12:&nbsp;<input type=text name=time size=4 maxlength=4 value=0800></td>\n";
    echo "<td colspan=2><select name=type>\n";
    echo "<option value='anfang'>$tc_text3\n";
    echo "<option value='ende'>$tc_text6 \n";
    echo "<option value='out_begin'>$tc_text4\n";
    echo "<option value='out_end'>$tc_text5 </select>\n";
    echo "<input type=image src='$img_path/los.gif' border=0 id=tr></form></td></tr>\n";
    // list of records
    echo "<td width=60><b>$l_text6</b></td><td width=60><b>$m1_text14</b></td><td width=60><b>$m1_text15</b></td>\n";
    echo "<td width=60><b>$tc_text4</b></td><td width=60><b>$tc_text5</b></td></tr>\n";
    if (strlen($month) == 1) { $month = "0".$month; }
    $result = db_query("select * from timecard where users = '$pers' and datum like '%-$month-%' and datum like '$year-%' order by datum desc") or db_die();
    while ($row = db_fetch_row($result)) {
      if (($i/2) == round($i/2)) { $color = $bgcolor1;$i++; } else { $color = $bgcolor2;$i++; }   //Farben abwechselnd
      $datum2 = explode("-", $row[2]);
      echo "<tr bgcolor='$color'><td>$datum2[2].$datum2[1].$datum2[0]&nbsp;</td><td>$row[4]&nbsp;</td><td>$row[5]&nbsp;</td><td>$row[6]&nbsp;</td><td>$row[7]&nbsp;</td>\n";
    }
    echo "</table><br><br>";
    // csv export
    echo "<a href='../misc/export.php?file=timecard_admin&pers_ID=$pers&month=$month&year=$year".$sid."'>$exp1</a> \n";
    // separation bar
    echo "<br><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
  }

  // *******
  // Logging
  if ($action == "logs") {
    if (strlen($month) == 1) { $month = "0".$month; }
    $timestring = $year.$month;
    echo "<center><h5> $admin_text94 </h5> $tc_text23: $month/$year<br><br>\n";
    echo "<table cellspacing=1 cellpadding=3 border=1><tr bgcolor='$bgcolor2'>";
    // column titles: login, logout, duration h:m
    echo "<tr><td><b>$admin_text94a</b></td><td><b>$admin_text94b</b></td><td><b>h:m</b></td></tr>\n";
    $result = db_query("select login, logout from logs where von = '$pers' and login like '$timestring%' order by login desc") or db_die();
    while ($row = db_fetch_row($result)) {
      $diff = 0;
      $diff_h = 0;
      $diff_m = 0;
      $day0 = substr($row[0],6,2).".".$month;
      $h0 = substr($row[0],8,2);
      $m0 = substr($row[0],10,2);
      // only show values if the user has logged out -> means: a value exists
      if ($row[1]) {
        $day1 = substr($row[1],6,2).".".$month;
        $h1 = substr($row[1],8,2);
        $m1 = substr($row[1],10,2);
        $diff =($h1-$h0)*60 + $m1 - $m0;
        // look whether logout is on the next day . if yes, add theminutes of a day
        if (substr($row[1],0,8) > substr($row[0],0,8)) { $diff += 1440; }
        $diff_h = floor($diff/60);
        $diff_m = $diff - $diff_h*60;
        if (strlen($diff_h) == 1) { $diff_h = "0".$diff_h; }
        if (strlen($diff_m) == 1) { $diff_m = "0".$diff_m; }
      }
      else {
        $day1 = "--";
        $h1 = "--";
        $m1 = "--";
        $diff_h = "--";
        $diff_m = "--";
      }
      if (($i/2) == round($i/2)) { $color = $bgcolor1;$i++; } else { $color = $bgcolor2;$i++; }   //Farben abwechselnd
      echo "<tr bgcolor=$color><td>$day0 $h0.$m0 </td><td>$day1 $h1.$m1 </td><td>$diff_h : $diff_m </td></tr>\n";
    }
    echo "</table></center>\n";
  }

  // *****************
  // User admistration
  if ($action == "user") {
    // new user
    if ($neu) {
      if(!$ldap or ($ldap and $ldap_profile != "off" and $ldap_profile and $ldap_conf[$ldap_profile]["ldap_sync"] == 1) or ($ldap and $ldap_profile == "off")){
        // extended value for the input field of the short name

        // begin form and check whether the short name has a blank in the string
        echo "<form action='admin.php' method='post' name='frm' target='l'>\n";
        if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>";
        echo "<input type='hidden' name='framenr' value='l'>\n";
        echo "<table><tr><td>$info_text17: </td><td><input type=text name=anrede size='15' maxlength=15></td></tr>\n";
        echo "<tr><td>$m1_text25: </td><td><input type='text' name='vorname' size='20' maxlength='40'></td></tr>\n";
        echo "<tr><td>$m1_text26(*): </td><td><input type='text' name='nachname' size='20' maxlength='40'></td></tr>\n";
        echo "<tr><td>$m1_text27(*): </td><td><input type='text' name='kurz' size='10' onBlur=\"chkChrs('frm','kurz','Alphanumerics only, please!',/[a-zA-Z0-9_]+/,1)\"></td></tr>\n";
        echo "<tr><td>$admin_text83(*): </td><td><input type=text name='loginname' size=20></td></tr>\n";
        echo "<tr><td>$admin_text23(*): </td><td><input type='password' name='pw' size=20 maxlength=40></td></tr>\n";

        // assign to groups, only in group mode
        if ($groups ) {
          //only allowed to root
          if (!$user_group) {

            // default group
            echo "<tr><td>$admin_text24: </td><td><select name=gruppe>\n";
            $result = db_query("select ID, name from gruppen order by name") or db_die();
            while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1]\n";}
            echo "</select></td></tr>\n";

            // member in the following groups:
            echo "<tr><td>$admin_text81:</td><td><select name='grup_user[]' multiple size=4>\n";
            $result2 = db_query("select ID, name from gruppen order by name") or db_die();
            while ($row2 = db_fetch_row($result2)) { echo "<option value='$row2[0]'>$row2[1]\n"; }
            echo "</select></td></tr>\n";
          }
        }
        echo "<tr><td>$m1_text28: </td><td><input type=text name=firma size=20 maxlength=30></td></tr>\n";
        echo "<tr><td>Email:</td><td><input type=text name=email size=20 maxlength=50></td></tr>\n";

        // status
        echo "<tr><td>$admin_text25: </td><td><select name=access1>\n";
        foreach ($acc as $acc1 => $acc2) {
          echo "<option value=$acc1>$acc2 \n"; 
        }
        echo "</select></td></tr>\n";

        // calendar visible?
        echo "<tr><td>&nbsp;</td><td><select name=access2>\n";
        foreach($vis as $vis1 => $vis2) { 
          echo "<option value=$vis1>$vis2 \n"; 
        }
        echo "</select></td></tr>\n";
        // various fields, see field name
        echo "<tr><td>$m1_text29 1: </td><td><input type=text name=tel1 size=20 maxlength=20></td></tr>\n";
        echo "<tr><td>$m1_text29 2: </td><td><input type=text name=tel2 size=20 maxlength=20></td></tr>\n";
        echo "<tr><td>$m1_text29 $admin_text92: </td><td><input type=text name=mobil size=20 maxlength=30></td></tr>\n";
        echo "<tr><td>$m1_text30: </td><td><input type=text name=fax size=20 maxlength=20></td></tr>\n";
        echo "<tr><td>SMS: </td><td><input type=text name=sms size=20 maxlength=60></td></tr>\n";
        echo "<tr><td>$m1_text31: </td><td><input type=text name=strasse size=20 maxlength=30></td></tr>\n";
        echo "<tr><td>$m1_text32: </td><td><input type=text name=stadt size=20 maxlength=30></td></tr>\n";
        echo "<tr><td>$admin_text26: </td><td><input type=text name=plz size=10 maxlength=10></td></tr>\n";
        echo "<tr><td>$m1_text33: </td><td><input type=text name=land size=20 maxlength=20></td></tr>\n";
        // ldap name
        if ($ldap) {echo "<input type=hidden name='ldap_profile' value='".(($ldap_profile == "off") ? "" : $ldap_profile) ."'>\n";}

        // language, list of available languages in the header of this script as an array!
        echo "<tr><td>$admin_text27: </td><td><select name=sprache>\n";
        echo "<option value=''>\n";
        foreach($languages as $l_long => $l_short) {
          echo "<option value=$l_short>$l_long \n"; 
        }
        echo "</select></td></tr>\n";
        
        // Role
        echo "<tr><td>$roles_text5: </td><td> <select name=role><option value=0>\n";     
        $result2 = db_query("SELECT ID, title from roles order by title") or db_die();
        while ($row2 = db_fetch_row($result2)) { echo "<option value='$row2[0]'>$row2[1]\n"; } 
        echo "</select></td></tr>\n";         
        echo "<input type=hidden name=action value=user>\n";
        echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
        echo "</table><input type=submit value='$admin_text6'></form>\n";
        echo "<br>* $admin_text30\n";
      }
      else {
        if (!$ldap_profile){
          echo "<table>\n";
          echo "<form action='admin.php' method='post' target='r'>\n";
          echo "<tr><td>LDAP-Profile</td><td><select name='ldap_profile'>\n";
          for ($i = 0; $ldap_conf[++$i]["conf_name"] != ""; )
            echo "<option value='$i'>".$ldap_conf[$i]["conf_name"]."\n";
          echo "<option value='off'>LDAP off\n";
          echo "</select></td></tr>\n";
          echo "<input type=hidden name='action' value='user'>\n";
          if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
          echo "<input type='hidden' name='framenr' value='r'>\n";
          echo "<tr><td><input type=submit name='neu' value='Proceed'></form></td><tr>\n";
          echo "</table>";
        }
        else {
          // extended value for the input field of the short name
          echo "<table><form action='admin.php' method='post' target='l'>\n";
          if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>";
          echo "<input type='hidden' name='framenr' value='l'>\n";
          if (!$ldap_conf[$ldap_profile][1]){echo "<tr><td>$m1_text25: </td><td><input type='text' name='vorname' size='20' maxlength='40'></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][2]){echo "<tr><td>$m1_text26(*): </td><td><input type='text' name='nachname' size='20' maxlength='40'></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][3]){echo "<tr><td>$m1_text27(*): </td><td><input type='text' name='kurz' size=20></td></tr>\n";}
          echo "<tr><td>$admin_text83(*): </td><td><input type=text name='loginname' size=20></td></tr>\n";
          if ($groups ) {
            //only allowed to root
            if (!$user_group) {
              // default group
              echo "<tr><td>$admin_text24: </td><td><select name=gruppe>\n";
              $result = db_query("select ID, name from gruppen order by name") or db_die();
              while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1]\n";}
              echo "</select></td></tr>\n";

              // member in the following groups:
              echo "<tr><td>$admin_text81:</td><td><select name='grup_user[]' multiple size=4>\n";
              $result2 = db_query("select ID, name from gruppen order by name") or db_die();
              while ($row2 = db_fetch_row($result2)) { echo "<option value='$row2[0]'>$row2[1]\n"; }
              echo "</select></td></tr>\n";
            }
          }
          if (!$ldap_conf[$ldap_profile][5]){echo "<tr><td>$m1_text28: </td><td><input type=text name=firma size=20 maxlength=30></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][7]){echo "<tr><td>Email:</td><td><input type=text name=email size=20 maxlength=50></td></tr>\n";}
          echo "<tr><td>$admin_text25: </td><td><select name=access1>\n";
          foreach ($acc as $acc1 => $acc2) {
            echo "<option value=$acc1>$acc2 \n"; 
          }
          echo "</select></td></tr>\n";
          echo "<tr><td>&nbsp;</td><td><select name=access2>\n";
          foreach ($vis as $vis1 => $vis2) { 
            echo "<option value=$vis1>$vis2 \n"; 
          }
          echo "</select></td></tr>\n";
          if (!$ldap_conf[$ldap_profile][9]){echo "<tr><td>$m1_text29 1: </td><td><input type=text name=tel1 size=20 maxlength=20></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][10]){echo "<tr><td>$m1_text29 2: </td><td><input type=text name=tel2 size=20 maxlength=20></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][17]){echo "<tr><td>$m1_text29 $admin_text92: </td><td><input type=text name=mobil size=20 maxlength=30></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][11]){echo "<tr><td>$m1_text30: </td><td><input type=text name=fax size=20 maxlength=20></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][12]){echo "<tr><td>$m1_text31: </td><td><input type=text name=strasse size=20 maxlength=30></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][13]){echo "<tr><td>$m1_text32: </td><td><input type=text name=stadt size=20 maxlength=30></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][14]){echo "<tr><td>$admin_text26: </td><td><input type=text name=plz size=10 maxlength=10></td></tr>\n";}
          if (!$ldap_conf[$ldap_profile][15]){echo "<tr><td>$m1_text33: </td><td><input type=text name=land size=20 maxlength=20></td></tr>\n";}
          echo "<input type='hidden' name='ldap_profile' value='$ldap_profile'>\n";
          echo "<tr><td>$admin_text27: </td><td><select name=sprache>\n";
          echo "<option value=''>\n";
          foreach ($languages as $l_long => $l_short) {
            echo "<option value=$l_short>$l_long \n"; 
          }
          echo "</select></td></tr>\n";
          echo "<input type=hidden name=action value=user>\n";
          echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
          echo "</table><input type=submit value='$admin_text6'></form>\n";
          echo "<br>* $admin_text30\n";
        }
      }
    }
    // modify
    if($aendern) {
      if (!$pers_ID) { die("$admin_text37 <a href='admin.php?".SID."'>$back</a>"); }
      $result = db_query("select * from users where ID = '$pers_ID'") or db_die();
      $row = db_fetch_row($result);
      $row = explode("",html_out(implode("",$row)));
/*
 * for LDAP we depend on row 19, if it is either "" or NULL we will set it
 * to a default value of 1
 */
      if($ldap == 0) {
      	$user_ldap_conf = 0;
      } elseif(!isset($row[19]) || (strlen($row[19]) < 1)) {
        $user_ldap_conf = "1";
      } else {
        $user_ldap_conf = $row[19];
      }

      echo "<table><form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type=hidden name='pers_ID' value=$pers_ID>\n";
      echo "<input type='hidden' name='kurz' value='$row[3]'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      if(($ldap == 0) or ($user_ldap_conf == "off") or ($ldap_conf[$user_ldap_conf]["ldap_sync"] != "2")) {
      echo "<tr><td>$info_text17: </td><td><input type=text name=anrede size='15' maxlength=15 value='$row[20]'></td></tr>\n";
      
      echo "<tr><td>$m1_text25: </td><td><input type=text name=vorname size=20 maxlength=40 value='$row[1]'></td></tr>\n";
      echo "<tr><td>$m1_text26(*): </td><td><input type=text name=nachname size=20 maxlength=40 value='$row[2]'></td></tr>\n";
      echo "<tr><td>$m1_text27: </td><td>$row[3]</td></tr>\n";
      echo "<tr><td>$admin_text83(*): </td><td><input type=text name='loginname' size=20 value='$row[18]'></td></tr>\n";

      // password field (with remark: insert a value only if you want to have a new password)
      	if($ldap == 0) {
      echo "<tr><td>$admin_text23a: </td><td><input type=password name=pw size=20 maxlength=40 value=''><br>$admin_text23b</td></tr>\n";
      	} else {
      		echo "<input type=hidden name=pw value=\"\">";
      	}
     	} else {
	      echo "<tr><td>$info_text17: </td><td><input type=text name=anrede size='15' maxlength=15 value='$row[20]' $read_o></td></tr>\n";
      
	      echo "<tr><td>$m1_text25: </td><td><input type=text name=vorname size=20 maxlength=40 value='$row[1]' $read_o></td></tr>\n";
	      echo "<tr><td>$m1_text26(*): </td><td><input type=text name=nachname size=20 maxlength=40 value='$row[2]' $read_o></td></tr>\n";
	      echo "<tr><td>$m1_text27: </td><td>$row[3]</td></tr>\n";
	      echo "<tr><td>$admin_text83(*): </td><td><input type=text name='loginname' size=20 value='$row[18]'></td></tr>\n";

     		echo "<input type=hidden name=pw value=\"\">";
     	}

      // define group membership
      if ($groups) {
         //only allowed to root and if chosen user is not root
        if (!$user_group and $pers_ID > 1) {
          // default group
          echo "<tr><td>$admin_text24: </td><td><select name=gruppe><option value=''>\n";
          $result2 = db_query("select ID, name from gruppen order by name") or db_die();
          while ($row2 = db_fetch_row($result2)) {
            echo "<option value='$row2[0]'";
            if ($row[6] == "$row2[0]") { echo " selected"; }
            echo ">$row2[1]\n";
          }
          echo "</select></td></tr>\n";

          // member in the following groups:
          echo "<tr><td>$admin_text81:</td><td><select name='grup_user[]' multiple size=4>\n";
          $result2 = db_query("select ID, name from gruppen order by name") or db_die();
          while ($row2 = db_fetch_row($result2)) {
            $result3 = db_query("select ID from grup_user where grup_ID = '$row2[0]' and user_ID = '$pers_ID'") or db_die();
            $row3 = db_fetch_row($result3);
            echo "<option value='$row2[0]'";
            if ($row3[0] > 0) { echo " selected"; }
            echo ">$row2[1]\n";
          }
          echo "</select></td></tr>\n";
        }  else {

          // default group
          echo "<tr><td>$admin_text24: </td><td><select name=gruppe><option value=''>\n";
          $result2 = db_query("SELECT DISTINCT gruppen.* FROM gruppen, grup_user WHERE 
                              (grup_ID = gruppen.ID AND user_ID = '$user_ID')") or db_die();
          while ($row2 = db_fetch_row($result2)) {
            echo "<option value='$row2[0]'";
            if ($row[6] == "$row2[0]") { echo " selected"; }
            echo ">$row2[1]\n";
          }
          echo "</select></td></tr>\n";

          // member in the follwing groups:
          echo "<tr><td>$admin_text81:</td><td><select name='grup_user[]' multiple size=4>\n";
          
          $result2 = db_query("select distinct gruppen.* from gruppen, grup_user where 
                              (grup_ID = gruppen.ID and user_ID = $user_ID)") or db_die();
          while ($row2 = db_fetch_row($result2)) {
          	$result3 = db_query("select ID from grup_user where grup_ID = '$row2[0]' and user_ID = '$pers_ID'") or db_die();
          	$row3 = db_fetch_row($result3);
            echo "<option value='$row2[0]'";
            if ($row3[0] > 0) echo " selected";
            echo ">$row2[1]\n";
          }
          echo "</select></td></tr>\n";
        }
      }

      if(($ldap != 0) and (strcmp($user_ldap_conf, "off") != 0) and ($ldap_conf[$user_ldap_conf]["ldap_sync"] == "2")) {
        echo "<tr><td>Email: </td><td><input type=text name=email size=20 maxlength=50 value='$row[7]' $read_o></td></tr>\n";
      } else {
      echo "<tr><td>$m1_text28: </td><td><input type=text name=firma size=20 maxlength=30 value='$row[5]'></td></tr>\n";
      echo "<tr><td>Email: </td><td><input type=text name=email size=20 maxlength=50 value='$row[7]'></td></tr>\n";
      }
      $access1 = substr($row[8],0,1);
      $access2 = substr($row[8],1,1);
      echo "<tr><td>$admin_text25: </td><td><select name=access1>\n";
      foreach ($acc as $acc1 => $acc2) {
        echo "<option value=$acc1";
        if ($access1 == $acc1) { echo " selected"; }
        echo " >$acc2 \n";
      }
      echo "</select></td></tr>\n";
      echo "<tr><td>&nbsp;</td><td><select name=access2>\n";
      foreach ($vis as $vis1 => $vis2) {
        echo "<option value=$vis1";
        if ($access2 == $vis1) { echo " selected"; }
        echo " >$vis2 \n";
      }
      echo "</select></td></tr>\n";
      if(($ldap == 0) or ($user_ldap_conf == "off") or ($ldap_conf[$user_ldap_conf]["ldap_sync"] != "2")) {
      echo "<tr><td>$m1_text29 1: </td><td><input type=text name=tel1 size=20 maxlength=20 value='$row[9]'></td></tr>\n";
      echo "<tr><td>$m1_text29 2: </td><td><input type=text name=tel2 size=20 maxlength=20 value='$row[10]'></td></tr>\n";
      echo "<tr><td>$m1_text29 $admin_text92: </td><td><input type=text name=mobil size=20 maxlength=30 value='$row[17]'></td></tr>\n";
      echo "<tr><td>$m1_text30: </td><td><input type=text name=fax size=20 maxlength=20 value='$row[11]'></td></tr>\n";
      }
      echo "<tr><td>SMS: </td><td><input type=text name=sms size=20 maxlength=60 value='$row[21]'></td></tr>\n";
      if(($ldap == 0) or ($user_ldap_conf == "off") or ($ldap_conf[$user_ldap_conf]["ldap_sync"] != "2")) {
      echo "<tr><td>$m1_text31: </td><td><input type=text name=strasse size=20 maxlength=30 value='$row[12]'></td></tr>\n";
      echo "<tr><td>$m1_text32: </td><td><input type=text name=stadt size=20 maxlength=30 value='$row[13]'></td></tr>\n";
      echo "<tr><td>$admin_text26: </td><td><input type=text name=plz size=10 maxlength=10 value='$row[14]'></td></tr>\n";
      echo "<tr><td>$m1_text33: </td><td><input type=text name=land size=20 maxlength=20 value='$row[15]'></td></tr>\n";
      }
      // language
      echo "<tr><td>$admin_text27: </td>\n";
      echo "<td><select name=sprache><option value0''>";
      foreach ($languages as $l_long => $l_short) {
        echo "<option value=$l_short";
        if ($row[16] == $l_short) { echo " selected"; }
        echo ">$l_long \n";
      }
      echo "</select></td><tr>";
      // Role
      echo "<tr><td>$roles_text5: </td><td><select name=role><option value=0>\n";     
      $result2 = db_query("SELECT ID, title from roles order by title") or db_die();
      while ($row2 = db_fetch_row($result2)) {
        echo "<option value=$row2[0]";
        if ($row2[0] == $row[22]) { echo " selected"; }
        echo ">$row2[1]\n";
      }   
      echo "</select></td></tr>\n";   
      if ($ldap) {    
        echo "<tr><td>$admin_text91: </td><td><select name=ldap_name>";
        $result2 = db_query("SELECT distinct ldap_name from users") or db_die();
        while ($row2 = db_fetch_row($result2)) {
      	  if((strcasecmp($row2[0], "off") != 0) && (strcmp($row2[0], "1") != 0)) {
	          echo "<option value=$row2[0]";
	          if ($row2[0] == $row[19]) { echo " selected"; }
	          echo ">$row2[0]\n";
	        }
        }
        echo "<option value='1'";
        if(strcasecmp($row[19],"1") == 0) {
      	  echo "selected";
        }
        echo ">Default (1)\n"; /* XXX Need to nationalize this */
      
        echo "<option value='off'";
        if(strcasecmp($row[19],"off") == 0) {
      	  echo "selected";
        }
        echo ">Off\n"; /* XXX Need to nationalize this */
			  echo "</select></td></tr>\n";
      }  
			      
      echo "<input type=hidden name=action value=user>";
      echo "<input type=hidden name='anlegen' value='aendern'>\n";
      echo "</table><input type=submit value='$admin_text7'></form>\n";
      echo "<br> * $admin_text30\n";
    }

    // db actions modify and create record are moved to the other frame -> see below

    // confirm delete record
    elseif($loeschen) {
      echo "<br><br><h5>$confirm</h5>\n";
      echo "<form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type=hidden name=action value=user>";
      echo "<input type=hidden name='pers_ID' value=$pers_ID>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<input type=submit name=loeschen value='$submit'>\n";
    }
  }
  
   // *********************
  // file management, orphan files
  elseif ($action == "files") {
  
    // fetch all users from this group, build array   
    //1. case groupless system
    if (!$groups) {
      $result = db_query("select ID from users") or db_die();
    }
    // group system
    else {  
      $result = db_query("select user_ID from grup_user where grup_ID = '$group_ID'") or db_die();    
    }
    while ($row = db_fetch_row($result)) { $user_group_ID[] = $row[0]; }
    // end fetch all users from the group
    
    // loop over all files in this group
    $result = db_query("select ID, von, filename, tempname from dateien where gruppe = '$group_ID'") or db_die();
    while ($row = db_fetch_row($result)) {
      // if 1. owner not listed in array or 2. array is empty (means: no member in group) -> orphan!
      if (($user_group_ID and !in_array($row[1],$user_group_ID)) or !$user_group_ID) {
        if ($delete) {
          echo "$delete_it: $row[2]<br>";
          // unlink the file itself
          // scrambled filenames? -> use old filename
          if($dat_crypt) { unlink($dateien."/".$row[3]); }
          // else: take new filename for storage
          else { unlink($dateien."/".$row[2]); }
          
          // remove the record from the database
          $result2 = db_query("delete from dateien where ID = '$row[0]'") or db_die();
        }
        elseif ($move) {
          echo "$move_it: $row[2]<br>";
          $result2 = db_query("update dateien set von = $pers_ID where ID = '$row[0]'") or db_die();
        }
      }
    }
    echo "$admin_text46<br>\n";
  }

  
  
  
  
  // roles
  elseif ($action == "roles") {
    // new record
    if ($neu) { 
      echo "<form action=admin.php method=post target='l'><table>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>";
      echo "<input type='hidden' name='action' value='roles'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      // title of the role
      echo "<tr><td>$datei_text3:</td><td><input type=text name=title size=40 maxlength=30></td></tr>\n";
      // remark
      echo "<tr><td>$datei_text4:</td><td><textarea name=remark rows=10 cols=40></textarea></td></tr>\n";      
      // loop over all modules
      if ($summary) { echo "<tr><td>$o_summary</td><td>".role1("summary")."</td></tr>\n"; }     
      if ($calendar) { echo "<tr><td>$o_calendar</td><td>".role1("calendar")."</td></tr>\n"; }
      if ($adressen) { echo "<tr><td>$o_adresses</td><td>".role1("contacts")."</td></tr>\n"; }
      if ($chat) { echo "<tr><td>$o_chat</td><td>".role1("chat")."</td></tr>\n"; }
      if ($forum)  { echo "<tr><td>$o_forum</td><td>".role1("forum")."</td></tr>\n"; }
      if ($dateien) { echo "<tr><td>$o_files</td><td>".role1("filemanager")."</td></tr>\n"; }
      if ($projekte) { echo "<tr><td>$o_projects</td><td>".role1("projects")."</td></tr>\n"; }
      if ($timecard) { echo "<tr><td>$o_timecard</td><td>".role1("timecard")."</td></tr>\n"; }
      if ($notes) { echo "<tr><td>$o_notes</td><td>".role1("notes")."</td></tr>\n"; }      
      if ($rts) { echo "<tr><td>$o_rts</td><td>".role1("helpdesk")."</td></tr>\n"; }
      if ($quickmail) { echo "<tr><td>$o_mail</td><td>".role1("mail")."</td></tr>\n"; }          
      if ($todo) { echo "<tr><td>$o_todo</td><td>".role1("todo")."</td></tr>\n"; }     
      if ($news) { echo "<tr><td>$o_news</td><td>".role1("news")."</td></tr>\n"; }
      if ($votum) { echo "<tr><td>$inst_text16</td><td>".role1("votum")."</td></tr>\n"; }    
      if ($lesezeichen) { echo "<tr><td>$admin_text11</td><td>".role1("bookmarks")."</td></tr>\n"; }
      echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
      echo "<tr><td></td><td><input type=submit value='$admin_text6'></td></tr></table></form>\n";
    }
    // modify
    if ($aendern) {
      $result = db_query("select * from roles where ID = '$roles_ID'") or db_die();
      $row = db_fetch_row($result);     
      echo "<form action=admin.php method=post target='l'><table>\n";
      if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='anlegen' value='aendern'>\n";
      echo "<input type='hidden' name='action' value='roles'>\n";
      echo "<input type='hidden' name='roles_ID' value='$roles_ID'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<tr><td>$datei_text3:</td><td><input type=text name='title' value='".html_out($row[2])."' size=40 maxlength=40></td></tr>\n";
      // remark
      echo "<tr><td>$datei_text4:</td><td><textarea name=remark rows=10 cols=40>".html_out($row[3])."</textarea></td></tr>\n";  
      // loop over all modules
      if ($summary) { echo "<tr><td>$o_summary</td><td>".role1("summary")."</td></tr>\n"; }      
      if ($calendar) { echo "<tr><td>$o_calendar</td><td>".role1("calendar")."</td></tr>\n"; }
      if ($adressen) { echo "<tr><td>$o_adresses</td><td>".role1("contacts")."</td></tr>\n"; }
      if ($chat) { echo "<tr><td>$o_chat</td><td>".role1("chat")."</td></tr>\n"; }
      if ($forum)  { echo "<tr><td>$o_forum</td><td>".role1("forum")."</td></tr>\n"; }
      if ($dateien) { echo "<tr><td>$o_files</td><td>".role1("filemanager")."</td></tr>\n"; }
      if ($projekte) { echo "<tr><td>$o_projects</td><td>".role1("projects")."</td></tr>\n"; }
      if ($timecard) { echo "<tr><td>$o_timecard</td><td>".role1("timecard")."</td></tr>\n"; }
      if ($notes) { echo "<tr><td>$o_notes</td><td>".role1("notes")."</td></tr>\n"; }         
      if ($rts) { echo "<tr><td>$o_rts</td><td>".role1("helpdesk")."</td></tr>\n"; }
      if ($quickmail) { echo "<tr><td>$o_mail</td><td>".role1("mail")."</td></tr>\n"; }       
      if ($todo) { echo "<tr><td>$o_todo</td><td>".role1("todo")."</td></tr>\n"; }     
      if ($news) { echo "<tr><td>$o_news</td><td>".role1("news")."</td></tr>\n"; }
      if ($votum) { echo "<tr><td>$inst_text16</td><td>".role1("votum")."</td></tr>\n"; }            
      if ($lesezeichen) { echo "<tr><td>$admin_text11</td><td>".role1("bookmarks")."</td></tr>\n"; }
      echo "</select></td></tr>\n";
      echo "<tr><td></td><td><input type=submit value='$admin_text7'></td></tr></table></form>\n";
    }
    // confirm delete record
    elseif($loeschen) {
      echo "<br><br><h5>$confirm</h5>\n";
      echo "<form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type=hidden name='action' value='roles'>\n";
      echo "<input type=hidden name='roles_ID' value='$roles_ID'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<input type='submit' name='loeschen' value='$submit'>\n";
    }
  }  

  // *********************
  // helpdesk create categories
  elseif ($action == "rts_categories") {
    // new record
    if ($neu) {
      echo "<form action=admin.php method=post target='l'><table>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>";
      echo "<input type='hidden' name='action' value='rts_categories'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<tr><td>$datei_text3:</td><td><input type=text name=name size=30 maxlength=30></td></tr>\n";
      // assign the category to a group
      if ($groups) {
        echo "<tr><td>$admin_text75</td><td><select name='gruppe'> <option value=''> \n";
        $result = db_query("select kurz, name from gruppen order by name") or db_die();
        while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1]\n"; }
        echo "</select></td></tr>\n";
      }
      // assign the category to an user
      echo "<tr><td>$admin_text76</td><td><select name='user'> <option value=''> \n";
      if ($groups) {
        $result = db_query("select kurz, nachname, vorname from users,grup_user where
                            users.ID = user_ID and grup_ID = '$group_ID'") or db_die();      
      }
      else {
        $result = db_query("select kurz, nachname, vorname from users where $sql_group") or db_die();
      }  
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1], $row[2]\n"; }
      echo "</select></td></tr>\n";
      echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
      echo "<tr><td></td><td><input type=submit value='$admin_text6'></td></tr></table></form>\n";
    }
    // modify
    if ($aendern) {
      $result = db_query("select * from rts_cat where ID = '$rts_cat_ID'") or db_die();
      $row = db_fetch_row($result);
      echo "<form action=admin.php method=post target='l'><table>\n";
      if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='anlegen' value='aendern'>\n";
      echo "<input type='hidden' name='action' value='rts_categories'>\n";
      echo "<input type='hidden' name='rts_cat_ID' value='$rts_cat_ID'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      $row[1] = html_out($row[1]);
      echo "<tr><td>$datei_text3:</td><td><input type=text name='name' value='$row[1]' size=30 maxlength=30></td></tr>\n";
      // assign the category to a group
      if ($groups) {
        echo "<tr><td>$admin_text75</td><td><select name='gruppe'> <option value=''> \n";
        $result2 = db_query("select kurz, name from gruppen order by name") or db_die();
        while ($row2 = db_fetch_row($result2)) {
          echo "<option value='$row2[0]'";
          if ($row2[0] == $row[3]) { echo " selected"; }
          echo ">$row2[1]\n";
        }
        echo "</select></td></tr>\n";
      }
      // assign the category to an user
      echo "<tr><td>$admin_text76</td><td><select name='user'> <option value=''> \n";
      if ($groups) {
        $result2 = db_query("select kurz, nachname, vorname from users,grup_user where 
                             users.ID = user_ID and grup_ID = '$group_ID'") or db_die();      
      }
      else  {
        $result2 = db_query("select kurz, nachname, vorname from users where $sql_group") or db_die();
      }  
      while ($row2 = db_fetch_row($result2)) {
          echo "<option value='$row2[0]'";
          if ($row2[0] == $row[2]) { echo " selected"; }
          echo ">$row2[1], $row2[2]\n";
        }
      echo "</select></td></tr>\n";
      echo "<tr><td></td><td><input type=submit value='$admin_text7'></td></tr></table></form>\n";
    }
    // confirm delete record
    elseif($loeschen) {
      echo "<br><br><h5>$confirm</h5>\n";
      echo "<form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type=hidden name='action' value='rts_categories'>\n";
      echo "<input type=hidden name='rts_cat_ID' value='$rts_cat_ID'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<input type='submit' name='loeschen' value='$submit'>\n";
    }
  }

  // *********************
  // Resource management
  elseif ($action == "ress") {
    // new
    if ($neu) {
      echo "<form action=admin.php method=post target='l'><table>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>";
      echo "<tr><td>$ress_text1:</td><td><input type=text name=name size=19 maxlength=19></td></tr>\n";
      echo "<tr><td>$ress_note:</td><td><input type=text name=bemerkung size=19 maxlength=255></td></tr>";
      echo "<tr><td>$ress_cat:</td><td><input type=text name=kategorie size=19 maxlength=20></td></tr>\n";
      echo "<tr><td></td><td><input type=submit value='$admin_text6'></td></tr>\n";
      echo "<input type=hidden name='action' value='ress'>";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<input type=hidden name='anlegen' value='neu_anlegen'>\n";
      echo "</table></form>\n";
    }
    // modify
    if($aendern) {
      if (!$ress_ID) { echo "$admin_text53!";}
      else {
        $result = db_query("select * from ressourcen where ID = '$ress_ID'") or db_die();
        $row = db_fetch_row($result);
        $row[1] = html_out($row[1]);
        $row[2] = html_out($row[2]);
        $row[3] = html_out($row[3]);
        echo "<form action=admin.php method=post target='l'><table>\n";
        if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>";
        echo "<input type='hidden' name='framenr' value='l'>\n";
        echo "<tr><td>$ress_text1:</td><td><input type=text name=name size=19 maxlength=19 value='$row[1]'></td></tr>\n";
        echo "<tr><td>$ress_note:</td><td><input type=text name=bemerkung size=19 maxlength=255 value='$row[2]'></td></tr>";
        echo "<tr><td>$ress_cat:</td><td><input type=text name=kategorie size=19 maxlength=20 value='$row[3]'></td></tr>\n";
        echo "<tr><td></td><td><input type=submit value='$admin_text7'></td></tr>\n";
        echo "<input type=hidden name='action' value='ress'>";
        echo "<input type=hidden name='anlegen' value='aendern'>\n";
        echo "<input type=hidden name='ress_ID' value='$ress_ID'>\n";
        echo "</table></form>\n";
      }
    }
    // confirm delete record
    elseif($loeschen) {
      echo "<br><br><h5>$confirm</h5>\n";
      echo "<form action=admin.php method=post target='l'>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type=hidden name=action value=ress>";
      echo "<input type=hidden name='ress_ID' value=$ress_ID>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<input type=submit name=loeschen value='$submit'>\n";
    }
  }

  //****************************
  // Lesezeichen/bookmarks check for invalid links and delete them
  elseif ($action == "lesezeichen") {
    if ($proof) {
      echo "<form action='admin.php' method='post' target='l'>\n";
      echo "<input type=hidden name='action' value='lesezeichen'>\n";
      echo "<input type=hidden name='loeschen' value='loeschen'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      $error = 0; 
      $result = db_query("select * from lesezeichen where $sql_group") or db_die();
      while ($row = db_fetch_row($result)) {
        $url = eregi_replace("http://","",$row[3]);
        $ok = fsockopen($url, 80);
        if (!$ok) {
          echo "$row[4]: $admin_text58&nbsp;&nbsp;";
          echo "<input type='Checkbox' name='lesezeichen_ID[]' value='$row[0]'> $admin_text8<br>\n";
          $error = 1;
        }
      }
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>";
      if ($error) { echo "<input type=image src='$img_path/los.gif' id=tr onClick=\"return confirm('$confirm')\">\n"; }
      else { echo "$admin_text59.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>\n"; }
      echo "</form>\n";
    }
  }

  //****************************
  // delete forum threads
  elseif ($action == "forum") {
    // first case - only old threads
    if ($tage) {
      $treffer = 0;
      $zeit = mktime(0, 0, 0, date("m"), date("d")-$tage, date("Y"));
      $zeit = date("YmdHis", $zeit);
      $result = db_query("select ID from forum where datum < '$zeit' and $sql_group") or db_die();
      while ($row = db_fetch_row($result)) { $treffer++; }
      $result = db_query("delete from forum where datum < '$zeit' and $sql_group") or db_die();
      echo "$treffer $admin_text62.";
    }
    // second case - specific threads
    else {
      $result = db_query("select ID, titel, gruppe from forum where ID = '$ID'") or db_die();
      $row = db_fetch_row($result);
      // check permission (except the root who has access to all groups)
      if ($user_group > 0 and $row[2] <> $user_group) { die("you are not allowed to do this"); }
      // check whether such a posting exists
      if (!$row[0]) { echo "such a posting does not exist!"; $error = 1; }
      // o.k.? -> begin to delete, first the comments
      if(!$error){
         delete_comments($ID);
         // now delete the posting itself
         $result = db_query("delete from forum where ID = '$ID'") or db_die();
         echo "$row[1] $opt_bm9 \n";
      }
    }
  }

   //*****************************
   //delete Chat files
  elseif ($action == "chat") {
    if ($mode == "kill") {
      if ($groups) {
        $alivepath = "../chat/".$group_ID."_".$alivefile;
        $chatpath = "../chat/".$group_ID."_".$chatfile;
      }
      else {
        $chatpath = "../chat/".$chatfile;
        $alivepath = "../chat/".$alivefile;
      }
      if (file_exists($alivepath)) {unlink($alivepath); }
      if (file_exists($chatpath) ) {unlink($chatpath);  }
      echo "$admin_text63. <br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
    }
  }

}  // end code for right frame.


//****************************************
// LEFT FRAME ****************************
//****************************************
if ($framenr == "l") {

  // header of html page
  echo "<html><head><link rel=stylesheet type='text/css' href='$css_style'><title>$admin_text1</title>$lang_cfg\n";
  echo "<script language='JavaScript' src='$lib_path/chkform.js' type='text/javascript'></script>\n";
  echo "</head><body bgcolor='$bgcolor2'>\n";

  //***************************
  // output messages of actions
  echo "<br><h4>";

  // group management
  if ($action == "groups") {
    // db action
    if ($mode == "anlegen") {
      if (!$name) echo "$admin_text73!<br>\n";
      else {
        $result = db_query("select name, kurz from gruppen where ID <> '$group_nr' order by name") or db_die();
        while ($row = db_fetch_row($result)) {
          if ($row[0] == $name) { echo "$admin_text74!"; $error = 1; }
          // don't check for existing short name when you want to modify the record
          if ($neu and $row[1] == $kurz) { echo "$admin_text74!"; $error = 1; }
        }
      }

      if (!$error) {
        if ($neu) {
          // write record to db
          $result = db_query("insert into gruppen values($dbIDnull,'$name','$kurz','$kategorie','$bemerkung',null,null,null)") or db_die();
          echo "$name: $admin_text87.<br>\n";
          echo "<img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
        // modify record
        elseif ($aendern) {
          $result = db_query("update gruppen set name='$name', kategorie='$kategorie',
                              bemerkung='$bemerkung', chef = '$chef' where ID = '$group_nr'") or db_die();
        }                      
      }
    }
    $group_ID = $group_nr;
    reg_sess_vars(array("group_ID"));

    // merge group
    if ($loeschen) {
      // fetch name of group to delete
      $result = db_query("select name from gruppen where ID = '$group_nr'") or db_die();
      $row = db_fetch_row($result);
      $name = $row[0];

      // update tables
      if ($adressen) { $result = db_query("update contacts set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }
      if ($dateien) { $result = db_query("update dateien set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }
      if ($forum) { $result = db_query("update forum set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }
      if ($lesezeichen) { $result = db_query("update lesezeichen set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }
      if ($projekte) { $result = db_query("update projekte set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }
      if ($rts) { $result = db_query("update rts_cat set gruppe = $merge_target where gruppe = '$group_nr'") or db_die(); }

      // update table for assign user to groups, avoid double entries
      // select members of group to be deleted
      $result = db_query("select user_ID from grup_user where grup_ID = '$group_nr'") or db_die();
      while ($row = db_fetch_row($result)) {
        // look if this user is already member of the target group
        $result2 = db_query("select ID from grup_user where (user_ID = '$row[0]' and grup_ID = '$merge_target')") or db_die();
        $row2 = db_fetch_row($result2);
        // no entry? then move user to the new group
        if (!$row2[0]) $result3 = db_query("update grup_user set grup_ID = $merge_target where grup_ID = '$group_nr' and user_ID = '$row[0]'") or db_die();
        // look whether the old group is the primary group of this user and change it
        $result2 = db_query("select gruppe from users where ID = '$row[0]'") or db_die();
        $row2 = db_fetch_row($result2);
        if ($row2[0] == $group_nr) {
          $result3 = db_query("update users set gruppe = $merge_target where ID = '$row[0]'") or db_die();
        }
      }
      // last action: delete record in table gruppen and grup_user
      $result4 = db_query("delete from gruppen where ID = '$group_nr'") or db_die();
      $result5 = db_query("delete from grup_user where grup_ID = '$group_nr'") or db_die();
      echo "$name $opt_bm9 <br>";

    }
  }

  // user management actions
  if ($action == "user") {
    // database actions at user administration
    if ($anlegen) {
      // crypt password
      if ($pw_crypt and $pw <> "") {
        $pw = encrypt($pw,$pw);
      }

			$result = db_query("select ldap_name from users where ID = '$pers_ID'");
			$row = db_fetch_row($result);
      if($ldap == 0) {
      	$user_ldap_conf = 0;
      } elseif(!isset($row[0]) || (strlen($row[0]) < 1)) {
        $user_ldap_conf = "1";
      } else {
        $user_ldap_conf = $row[0];
      }

      //*** checks***
      // no family name at all or pw or short name at creating? -> error!
      // ldap_sync == 2 means everything comes from LDAP
      // ldap_sync == 1 means everything comes from db therefore update
      if ((!$ldap or ($ldap and $ldap_conf[$user_ldap_conf]["ldap_sync"] == "1")) and (!$nachname or !$kurz or !$pw) and $anlegen == "neu_anlegen") { echo "$admin_text31"; $error = 1; }
      // in case ldap is activated a loginname must exist
      elseif ($ldap and (strlen($loginname) < 1) and $anlegen == "neu_anlegen") { echo "$admin_text31"; $error = 1; }

      // check group status
      if ($groups) { 
         // if admin is limited to his group, no group is specified and the new user must be in his group
        if(!$gruppe) { $gruppe = $group_ID;}
        // check whether default group is in group list
        $found = 0;
        for ($i = 0; $i < count($grup_user); $i++) { if ($gruppe == $grup_user[$i]) { $found = 1; } }
        // not selected? -> add it
        if (!$found) { $grup_user[] = $gruppe; }
        $where = "where gruppe = '$gruppe'";
      }
      // check for double entries
      if(!$ldap or ($ldap_conf[$user_ldap_conf]["ldap_sync"] == "1")){
        if($anlegen == "aendern"){
            if($where) $where .= " and ";
            else $where = "where ";
            $where .= "ID <> '$pers_ID'";
        }
        $result = db_query("select ID, vorname, nachname, kurz, gruppe, pw, loginname from users $where") or db_die();
        while ($row = db_fetch_row($result)) {
          /* taken out of the script since if is not used anymore!
          // password must be unique
          if ($row[5] == $pw) { echo "$admin_text34"; $error = 1; }
          end taken out ... */
          // same group can't have 2 users with same first AND last name
            if ($nachname == $row[2] and $vorname == $row[1]) {echo "$admin_text34a"; $error = 1;}
            if ($loginname == $row[6]){ echo "$admin_text33b"; $error = 1; }
            if ($kurz == $row[3]) { echo "$admin_text33"; $error = 1; }
            if($ldap_conf[$user_ldap_conf]["ldap_sync"] == "1") {
			      	if(strlen($ldap_name) < 1) { echo "$admin_text91"; $error = 1; }
        }
      }
      } else {
      	// still check loginname
      	if(strlen($loginname) < 1) { echo "$admin_text31"; $error = 1; }
      	if(strlen($ldap_name) < 1) { echo "$admin_text91"; $error = 1; }
      }
      //*** end checks

      // *** no errors? -> db action
      if (!$error) {
        // status and calendar visibility tied together
        $access = $access1.$access2;

        // *** new record
        if ($anlegen == "neu_anlegen") {
          // insert new record in db
          $result = db_query("insert into users values($dbIDnull,'$vorname','$nachname','$kurz','$pw','$firma','$gruppe','$email','$access','$tel1','$tel2','$fax','$strasse','$stadt','$plz','$land','$sprache','$mobil','$loginname','$ldap_profile','$anrede','$sms','$role',null,null)") or db_die();
          // update group status
          if ($groups) {
            // fetch user ID from just created record
#            if(!$ldap){$result = db_query("select ID from users where nachname='$nachname' and pw = '$pw'") or db_die(); }
#            else {$result = db_query("select ID from users where loginname='$loginname'") or db_die(); }
            $result = db_query("select ID from users order by ID desc") or db_die();
            $row = db_fetch_row($result);
            // insert into grup_user
            for ($i = 0; $i < count($grup_user); $i++) {
              $result = db_query("insert into grup_user values($dbIDnull,'$grup_user[$i]','$row[0]')") or db_die();
            }
          }
          echo "$nachname, $vorname: $admin_text35<br>\n";
          echo "<img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }

        // **** modify
        elseif ($anlegen == "aendern") {

          // encrypt pw
          if (!$pw) { $pw_string = ""; }
          else { $pw_string = "pw='$pw',"; }

          // create query string for groups, but only if admin = root
          if ($groups and !$user_group and $pers_ID > 1) $group_string = "gruppe='$gruppe',";
          else $group_string = "";

					if(($ldap == 0) || ($ldap_conf[$user_ldap_conf]["ldap_sync"] == 1)) {
						$query = "update users set vorname='$vorname',nachname='$nachname', firma='$firma', $pw_string
                              $group_string email='$email',acc='$access',tel1='$tel1',tel2='$tel2',fax='$fax',strasse='$strasse',
                              stadt='$stadt',plz='$plz',land='$land',sprache='$sprache',mobil='$mobil',loginname='$loginname',
                    ldap_name='$ldap_name',anrede='$anrede',sms='$sms',role='$role' where ID = '$pers_ID'";
          } else {
            $query = "update users set $group_string acc='$access',loginname='$loginname',sms='$sms',
                      role='$role',ldap_name='$ldap_name' where ID = '$pers_ID'";
          }
                     
          // update db record in users table
          $result = db_query($query) or db_die();


          // update group status, but only if group mode activated and admin = root
          if (!$user_group and $groups) {
            $result = db_query("delete from grup_user where user_ID = '$pers_ID'") or db_die();
            if (!$grup_user[0]) { $grup_user[0] = $group_ID; }
            for ($i = 0; $i < count($grup_user); $i++) {
              $result = db_query("insert into grup_user values($dbIDnull,'$grup_user[$i]','$pers_ID')") or db_die();
            }
          }
          echo "$nachname, $vorname: $admin_text36.<br>\n";
          echo "<img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
      }
    }

    //**************
    // user: delete record
    if($loeschen) {

      // checks
      // 1. check: no user chosen
      if (!$pers_ID) { echo "$admin_text37!"; $error = 1; }
      // 2. check: don't delete the root!
      if ($pers_ID == 1) { echo "$admin_text90!"; $error = 1; }

      // no error? -> begin to delete ...
      if (!$error) {
        // fetch his name ..
        $result = db_query("select nachname, kurz from users where ID = '$pers_ID'") or db_die();
        while ($row = db_fetch_row($result)) { $name = $row[0]; $kurz = $row[1]; }

        // warn, if he's a member of a project team
        if ($projekte) {
          $result = db_query("select * from projekte where personen like '%$kurz%'") or db_die();
          if (db_fetch_row($result) > 0) { echo "<b>$name $admin_text38!</b><br>"; }
        }

        // delete membership in groups
        if ($groups) $result = db_query("delete from grup_user where user_ID = '$pers_ID'") or db_die();

        // delete profiles
        if ($profile) {
          // 1. his own
          $result = db_query("delete from profile where von = '$pers_ID'") or db_die();
          echo "$name: $admin_text39. <br>";
          // 2. as a participant
          $result = db_query("select * from profile where personen like '%$kurz%'") or db_die();
          while ($row = db_fetch_row($result)) {
            $an = unserialize($row[3]);
            for ($i=0; $i<count($an); $i++) {if ($an[$i] == $kurz) { $a = $i; }  }
            unset ($an[$a]);
            $an2 = serialize($an);
            $return2 = db_query("update profile set personen = '$an2' where ID = '$row[0]'") or db_die();
          }
          echo "$name $admin_text40.<br>";
        }

        // delete todos
        if ($todo) {
          $result = db_query("delete from todo where von = '$pers_ID'") or db_die();
          echo "$name: $admin_text41. <br>";
        }

        // delete his files, links and dirs set to private
        if ($dateien) {
          $result = db_query("select ID, filename, tempname, typ, filesize, acc, remark from dateien where von = '$pers_ID'") or db_die();
          while ($row = db_fetch_row($result)) {
            // delete files if they are set top private
            if ($row[5] =="private") {
              // only delete file when it is not a link
              if ($row[4] > 0) {
                if ($dat_crypt) { $path = "$dateien/$row[2]"; }
                else { $path = "$dateien/$row[1]"; }
                unlink($path);
              }
              $result2 = db_query("delete from dateien where ID = '$row[0]'") or db_die();
              // look for files in the subdirectory or if it si a file with versioning
              if ($row[3] == "d" or $row[3] == "fv") del($row[0]); 
            }
            // if set to non-private, add a remark in the remark :)
            else {
              $remark = "[ $name ]".$row[6];
              $result2 = db_query("update dateien set remark = '$remark' where ID = '$row[0]'") or db_die();
            }
          }
        }

        // delete notes set to private
        if ($notes) {
          $result = db_query("delete from notes where von = '$pers_ID' and (ext is null or ext = '0')") or db_die();
        }

        // update polls
        if ($votum) {
          $result = db_query("select * from votum where an like '%$kurz%' and fertig not like '%$kurz%'") or db_die();
          while ($row = db_fetch_row($result)) {
            $ID = $row[0];
            $an = unserialize($row[5]);
            for ($i=0; $i<count($an); $i++) {if ($an[$i] == $kurz) { $a = $i; } }
            unset ($an[$a]);
            $an2 = serialize($an);
            $return2 = db_query("update votum set an = '$an2' where ID = '$row[0]'") or db_die();
          }
          echo "$name $admin_text42.<br>";
        }

        // delete schedule
        $result = db_query("delete from termine where an = '$pers_ID'") or db_die();
        echo "$name: $admin_text43. <br>";
        // delte user itself
        $result = db_query("delete from users where ID = '$pers_ID'") or db_die();
        echo "$name: $admin_text44. <br>";
        echo "<i>$name: $admin_text45 ;-))</i><br><br>";
        echo "$admin_text46.";
      }
    }
  }
  
  // *****
  // roles
  // *****
  if ($action == "roles") {
    //delete
    if ($loeschen) {
      // remove the assignment to users
      $result = db_query("update users set role = '' where role = '$roles_ID'") or db_die();      
      // delete record itself
      $result = db_query("delete from roles where ID = '$roles_ID'") or db_die();
      // show message
      echo "$admin_text96a. <br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>\n";
    }

    if ($anlegen) {
      if (!$roles_ID) $roles_ID = 0;
      // check for double entries
      $result = db_query("select ID from roles where title = '$title' and ID <> '$roles_ID'") or db_die();
      $row = db_fetch_row($result);
      if ($row[0] > 0) {     
        if (($anlegen == "aendern" and $row[0] <> $roles_ID) or $anlegen == "neu_anlegen") {
          echo "$datei_text19"; 
          $error = 1; 
        }  
      }  

      if (!$error) {
        // new
        if($anlegen == "neu_anlegen") {
          if (!$title) { die("$admin_text73!"); } 
          $result = db_query("insert into roles values($dbIDnull,'$user_ID','$title','$remark','$summary','$calendar_m','$contacts_m','$forum_m','$chat_m','$filemanager_m','$bookmarks_m','$votum_m','$mail_m','$notes_m','$helpdesk_m','$projects_m','$timecard_m','$todo_m','$news_m')") or db_die();
          echo " $title: $admin_text96b.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
        // modify
        if ($anlegen == "aendern") { 
          if (!$title) { die("$admin_text73!"); }
          $result = db_query("update roles set title='$title',remark='$remark',summary='$summary',calendar='$calendar_m',contacts='$contacts_m',forum='$forum_m',chat='$chat_m',filemanager='$filemanager_m',bookmarks='$bookmarks_m',votum='$votum_m',mail='$mail_m',notes='$notes_m',helpdesk='$helpdesk_m',projects='$projects_m',timecard='$timecard_m',todo='$todo_m',news='$news_m'  where ID = '$roles_ID'") or db_die();
          echo " $title: $admin_text96c.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
      }
    }  
  }
  
  
  // ******************************
  // actions on helpdesk categories
  if ($action == "rts_categories") {
    //delete
    if ($loeschen) {
      $result = db_query("delete from rts_cat where ID = '$rts_cat_ID'") or db_die();
      echo "$admin_text78. <br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>\n";
    }

    if ($anlegen) {
      // check for double entries
      if ($anlegen == "aendern") { $mod_strg = "where ID <> '$rts_cat_ID'"; }
      $result = db_query("select name from rts_cat $mod_strg") or db_die();
      while ($row = db_fetch_row($result)) {
        if ($name == $row[0]) { echo "$datei_text19"; $error = 1; }
      }

      if (!$error) {
        // new
        if($anlegen == "neu_anlegen") {
          if (!$name) { die("$admin_text73!"); }
          $result = db_query("insert into rts_cat values($dbIDnull,'$name','$user','$gruppe')") or db_die();
          echo " $name: $admin_text79.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
        // modify
        if ($anlegen == "aendern") {
          if (!$name) { die("$admin_text73!"); }
          $result = db_query("update rts_cat set name='$name', gruppe = '$gruppe', users = '$user' where ID = '$rts_cat_ID'") or db_die();
          echo " $name: $admin_text80.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
      }
    }
  }

  // actions on resources
  if ($action == "ress") {
    if($loeschen) {   // delete
      if (!$ress_ID) { die("$admin_text53!"); }
      $result = db_query("select name from ressourcen where ID = '$ress_ID'") or db_die();
      while ($row = db_fetch_row($result)) { $ress_name = $row[0]; }
      $result = db_query("delete from ressourcen where ID = '$ress_ID'") or db_die();
      echo "$ress_name: $admin_text54.<br>";
      $result = db_query("update termine set ressource = '' where ressource = '$ress_ID'") or db_die();
      echo "$admin_text55 <br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>\n";
    }

    if ($anlegen) {
      // check for double entries
      if ($anlegen == "aendern") { $mod_strg = "where ID <> '$ress_ID'"; }
      $result = db_query("select name from ressourcen $mod_strg") or db_die();
      while ($row = db_fetch_row($result)) {
        if ($name == $row[0]) { echo "$datei_text19"; $error = 1; }
      }

      if (!$error) {
        // write new record
        if($anlegen == "neu_anlegen") {
          if (!$name) { die("$admin_text73!"); }
          $result = db_query("insert into ressourcen values($dbIDnull,'$name','$bemerkung','$kategorie',null,null,null)") or db_die();
          echo "$name: $admin_text56.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
        // modify record
        if ($anlegen == "aendern") {
          if (!$name) { die("$admin_text73!"); }
          $result = db_query("update ressourcen set name='$name', bemerkung='$bemerkung',kategorie='$kategorie' where ID = '$ress_ID'") or db_die();
          echo "$name: $admin_text57.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
        }
      }
    }
  }

  // delete bookmarks
  elseif ($action == "lesezeichen") {
    if ($loeschen) {
      if (!$lesezeichen_ID) { die("$admin_text60! <br><a href='admin.php?".SID."'>$back</a>"); }
      for ($i=0; $i < count($lesezeichen_ID); $i++) {
        $result = db_query("select bezeichnung from lesezeichen where ID = '$lesezeichen_ID[$i]'") or db_die();
        while ($row = db_fetch_row($result)) { echo "$row[0]: $admin_text61. <br>";  }
        $result = db_query("delete from lesezeichen where ID = '$lesezeichen_ID[$i]'") or db_die();
      }
      echo "$admin_text46.<br> <img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0>";
    }
  }
  echo "</h4>\n";



  //****************************************
  // DIALOG
  //****************************************


  // no groupID? -> You are superadmin! first dialog: choose a group or work on groups
  if (($groups and !$user_group)) {
    $result = db_query("select name from gruppen where ID = '$group_ID'") or db_die();
    $row = db_fetch_row($result);

    //if (!$action or $action == "groups") {
    echo "<form action='admin.php' method='post' target='l'>\n";
    if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='framenr' value='l'>\n";
    //Link for help
    echo "<table><tr><td><a href='$doc/admin.html' target='_blank'><b>$admin_text1</b> | </a></td>\n";
    // choose group js select box
    echo "<td><b>$admin_text67:</b></td>\n";
    echo "<td><select name='group_select' onchange='document.forms[0].submit()'>\n";
    // no groups selected? show him a blank entry
    if (!$group_ID) { echo "<option value=''>\n"; }
    // fetch ID and name for db
    $result = db_query("select ID, name from gruppen order by name") or db_die();
    while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'";
    if ($row[0] == $group_ID) { echo " selected"; }
    echo ">$row[1]\n"; }
    echo "</select></td></tr></table></form>\n";
  }

  // start main table
  echo "<table width=430>\n";

  // check for root
  if ($groups and !$user_group) {
    // work on groups
    echo "<form action='admin.php' method='post' target='r'>\n";
    echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    echo "<tr><td colspan=4><h5>$admin_text72</h5></td></tr>\n";
    if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='action' value='groups'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    // submit button for a new entry ...
    echo "<tr><td><input type='submit' name='neu' value='$admin_text6'>&nbsp; &nbsp; $admin_text64</td>\n";
    // modify exsting entry and ...
    echo "<td><input type='submit' name='aendern' value='$admin_text7'>&nbsp;</td>\n";
    echo "<td><select name='group_nr'>\n";
    $result = db_query("select ID, name from gruppen order by name") or db_die();
    while ($row = db_fetch_row($result)) {
       echo "<option value='$row[0]'";
       if ($row[0] == $group_ID) echo " selected";
       echo ">$row[1]\n";
    }
    echo "</select>&nbsp;</td>\n";
    // delete button
    echo "<td><input type='submit' name='loeschen' value='$admin_text8'></td></tr>\n";
    echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    echo "</form>\n";
  }

  //**************************
  // groupID set -> main dialog

  // user management
  if (!$groups or $group_ID) {
    // set query string for the user list
    if (!$groups) { $groupstring = ""; }
    else { $groupstring = "where gruppe = $group_ID"; }

    echo "<tr><td colspan=4><h5>$admin_text5</h5></td></tr>\n";
    // new user
    echo "<form action='admin.php' method='post' target='r'>\n";
    echo "<input type=hidden name='action' value='user'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<tr><td><input type=submit name='neu' value='$admin_text6'>&nbsp; &nbsp; $admin_text64</form></td>\n";
    // new form: modify or delete user
    echo "<form action='admin.php' method='post' target='r' name=frm1 onSubmit=\"return chkForm('frm1','pers_ID','$admin_text86!')\">\n";
    echo "<input type=hidden name='action' value='user'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<td><input type=submit name='aendern' value='$admin_text7'>&nbsp;</td>\n";
    echo "<td><select name='pers_ID'><option value=''>\n";
    // list users
    // no group system -> fetch all users
    if (!$groups) { $result2 = db_query("select ID, nachname, vorname from users order by nachname") or db_die(); }
    // group system
    else { $result2 = db_query("select users.ID, nachname, vorname from users, grup_user where 
                                users.ID = user_ID and grup_ID = '$group_ID' order by nachname") or db_die(); }
    // loop over all entries
    while ($row2 = db_fetch_row($result2)) { echo "<option value='$row2[0]'>$row2[1], $row2[2]\n"; }
    echo "</select>&nbsp;</td>\n";
    // end list users
    echo "<td><input type=submit name='loeschen' value='$admin_text8'>\n";
    echo "</tr></form>\n";
    echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    
    // *****
    // roles
    // *****
    echo "<tr><td colspan=4><h5>$roles_text1</h5></td></tr>\n";
    // form: new category
    echo "<form action='admin.php' method='post' target='r'>\n";
    echo "<input type=hidden name='action' value='roles'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<tr><td><input type=submit name='neu' value='$admin_text6'>&nbsp; &nbsp; $admin_text64</form></td>\n";
    // new form: modify rts category
    echo "<form action='admin.php' method='post' target='r' name=frm2 onSubmit=\"return chkForm('frm2','roles_ID','$admin_text86!')\">\n";
    echo "<input type=hidden name='action' value='roles'>\n";
    if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
    echo "<input type='hidden' name='framenr' value='r'>\n";
    echo "<td><input type=submit name='aendern' value='$admin_text7'>&nbsp;</td>\n";
    echo "<td><select name='roles_ID'><option value=''>\n";
    $result = db_query("select ID, title from roles order by title") or db_die();
    while ($row = db_fetch_row($result)) {
    $row[1] = html_out($row[1]);
    echo "<option value=$row[0]>$row[1]\n"; }
    echo "</select>&nbsp;</td>\n";
    echo "<td><input type=submit name='loeschen' value='$admin_text8'></td>\n";
    echo "</tr></form>\n";
    echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";    
    
    

    // ****************************
    // helpdesk category management
    if ($rts) {
      echo "<tr><td colspan=4><h5>$admin_text77</h5></td></tr>\n";
      // form: new category
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='rts_categories'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td><input type=submit name='neu' value='$admin_text6'>&nbsp; &nbsp; $admin_text64</form></td>\n";
      // new form: modify rts category
      echo "<form action='admin.php' method='post' target='r' name=frm2 onSubmit=\"return chkForm('frm2','rts_cat_ID','$admin_text86!')\">\n";
      echo "<input type=hidden name='action' value='rts_categories'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<td><input type=submit name='aendern' value='$admin_text7'>&nbsp;</td>\n";
      echo "<td><select name='rts_cat_ID'><option value=''>\n";
      $result = db_query("select ID, name from rts_cat order by name") or db_die();
      while ($row = db_fetch_row($result)) {
      $row[1] = html_out($row[1]);
      echo "<option value=$row[0]>$row[1]\n"; }
      echo "</select>&nbsp;</td>\n";
      echo "<td><input type=submit name='loeschen' value='$admin_text8'></td>\n";
      echo "</tr></form>\n";
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    }

    // ressourcen management
    if ($ressourcen) {
      echo "<tr><td colspan=4><h5>$admin_text10</h5></td></tr>\n";
      // new resource
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='ress'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td><input type=submit name='neu' value='$admin_text6'>&nbsp; &nbsp; $admin_text64</form></td>\n";
      // modify resource
      echo "<form action='admin.php' method='post' target='r' name=frm3 onSubmit=\"return chkForm('frm3','ress_ID','$admin_text86!')\">\n";
      echo "<input type=hidden name='action' value='ress'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<td><input type=submit name='aendern' value='$admin_text7'>&nbsp;</td>\n";
      echo "<td><select name='ress_ID'><option value=''>\n";
      $result = db_query("select ID, name from ressourcen order by name") or db_die();
      while ($row = db_fetch_row($result)) {
      $row[1] = html_out($row[1]);
      echo "<option value=$row[0]>$row[1]\n"; }
      echo "</select>&nbsp;</td>\n";
      // delete button
      echo "<td><input type=submit name='loeschen' value='$admin_text8'></td>\n";
      echo "</tr></form>\n";
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    }

    // timecard
    if ($timecard) {
      echo "<tr><td colspan=4><h5>$admin_text65</h5></td></tr>\n";
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='timecard'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td colspan=6><input type=submit name='pers' value='$admin_text66'>\n";
      echo "<select name=pers>\n";
      $result = db_query("select ID, nachname, vorname from users where $sql_group order by nachname") or db_die();
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1], $row[2]\n"; }
      echo "</select>\n";
      echo "<select name=month>\n";
      // Monatsbox
      if (!$month) { $month = date("m"); }
      if (!$year)  { $year = date("Y"); }
      for ($a=1; $a<13; $a++) {
        $mo = date("n", mktime(0,0,0,$a,1,$year));
        $name_of_month = $name_month[$mo];
        if ($mo == $month) {echo "<option value=$a selected>$name_of_month\n";}
        else {echo "<option value=$a>$name_of_month\n";}
      }
      echo "</select>\n";
      $y = date("Y");
      echo "<select name=year>&nbsp;\n";
      for ($i=$y-2; $i<=$y+5; $i++) {
        if ( $i == $year) {echo "<option value='$i' selected>$i\n";}
        else {echo"<option value='$i'>$i\n";}
      }
      echo "</select></td></tr></form>\n";
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    }

    // Logging
    if ($logs) {
      echo "<tr><td colspan=4><h5>$admin_text94</h5></td></tr>\n";
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='logs'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td colspan=6><input type=submit name='pers' value='$admin_text66'>\n";
      echo "<select name=pers>\n";
      if ($groups) {
        $result = db_query("select users.ID, nachname, vorname from users,grup_user where 
                            users.ID = user_ID and grup_ID = '$group_ID' order by nachname") or db_die();      
      }
      else {
        $result = db_query("select ID, nachname, vorname from users where $sql_group order by nachname") or db_die();
      }  
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1], $row[2]\n"; }
      echo "</select>\n";
      echo "<select name=month>\n";
      // Monatsbox
      if (!$month) { $month = date("m"); }
      if (!$year)  { $year = date("Y"); }
      for ($a=1; $a<13; $a++) {
        $mo = date("n", mktime(0,0,0,$a,1,$year));
        $name_of_month = $name_month[$mo];
        if ($mo == $month) {echo "<option value=$a selected>$name_of_month\n";}
        else {echo "<option value=$a>$name_of_month\n";}
      }
      echo "</select>\n";
      $y = date("Y");
      echo "<select name=year>&nbsp;\n";
      for ($i=$y-2; $i<=$y+5; $i++) {
        if ( $i == $year) {echo "<option value='$i' selected>$i\n";}
        else {echo"<option value='$i'>$i\n";}
      }
      echo "</select></td></tr></form>\n";
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    }

    // orphan files
    if ($dateien) {
      echo "<tr><td colspan=2><h5>$admin_text88</h5></td></tr>\n";
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type='hidden' name='action' value='files'>\n";
      if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td colspan=2>$admin_text89:</td></tr>\n";
      echo "<tr><td><input type=submit name=delete value='$delete_it'></td>\n";
      echo "<td colspan=2> &nbsp; $admin_text64 <input type='submit' name='move' value='$move_it'></td>\n";
      echo "<td><select name='pers_ID'>\n";
      if ($groups) {
        $result = db_query("select users.ID, nachname, vorname from users,grup_user where 
                            users.ID = user_ID and grup_ID = '$group_ID' order by nachname") or db_die();      
      }
      else {
        $result = db_query("select ID, nachname, vorname from users where $sql_group order by nachname") or db_die();
      }  
      while ($row = db_fetch_row($result)) { echo "<option value='$row[0]'>$row[1], $row[2]\n"; }
      echo "</select>&nbsp;</td></tr></form>\n";
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
    }

    // bookmark management
    if ($lesezeichen) {
      // check bookmarks
      echo "<tr><td colspan=2><h5>$admin_text11</h5></td></tr>\n";

      // delete bookmarks
      echo "<form action='admin.php' method='post' target='l'>\n";
      echo "<input type=hidden name='action' value='lesezeichen'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='l'>\n";
      echo "<tr><td colspan=2><select name='lesezeichen_ID[]' multiple>\n";
      $result = db_query("select * from lesezeichen where $sql_group order by bezeichnung") or db_die();
      while ($row = db_fetch_row($result)) {
      $row[4] = html_out($row[4]);
      echo "<option value=$row[0]>$row[4]\n"; }
      echo "</select>\n";
      echo "<input type=submit name='loeschen' value='$admin_text8'></td></form>\n";

      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name=action value=lesezeichen>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<td><input type=submit name=proof value=$admin_text13><br>\n";
      echo "$admin_text12</td></form></tr>\n";


    }

    // Forum
    if ($forum) {
    // first form: delete threads in forum which are older than x days
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
      echo "<tr><td colspan=3><h5>$admin_text17</h5></td></tr>\n";
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='forum'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td><input type='submit' name='loeschen' value='$admin_text8' onClick=\"return confirm('$confirm')\"></td>\n";
      echo "<td colspan=6> $admin_text18 &nbsp;\n";
      echo "<select name=tage><option value>15<option value>30<option value>45<option value>60</select>\n";
      echo "&nbsp;$admin_text19</td>\n";
      echo "</form></tr>\n";

      // second form: admin can delete a specified thread (including the comments
      echo "<form action='admin.php' method='post' target='r'>\n";
      echo "<input type=hidden name='action' value='forum'>\n";
      if(SID) echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td><input type='submit' name='loeschen' value='$admin_text8' onClick=\"return confirm('$confirm')\"></td>\n";
      echo "<td colspan=6>$admin_text95: <input type=text name=ID size=4></form></td></tr>\n";
    }

    // chat
    if ($chat) {
      if ($groups) { $chatpath = "../chat/".$group_ID."_".$chatfile; }
      else { $chatpath = "../chat/".$chatfile; }
      echo "<tr><td colspan=6><img src='$img_path/s.gif' width=390 height=1 vspace=2 border=0></td></tr>\n";
      echo "<tr><td colspan=3><h5>$admin_text20</h5></td></tr>\n";
      echo "<form action='admin.php' method='post' target='r'>\n";
      if(SID) echo "<input type=hidden name=PHPSESSID value=$PHPSESSID>\n";
      echo "<input type='hidden' name='framenr' value='r'>\n";
      echo "<tr><td><input type=submit value='$admin_text8'></td>\n";
      echo "<td colspan=2>$admin_text22</td>\n";
      echo "<input type=hidden name='action' value='chat'>\n";
      echo "<input type=hidden name='mode' value='kill'></tr>\n";
      // if the file with the chat text exists, offer a link to save this file
      if (file_exists($chatpath)) {echo "<tr><td colspan=4><a href='$chatpath' target=_blank>$admin_text21</a></td></tr></form>\n"; }
    }
  } // close $group_ID
  echo "</table>\n";
} //close $dialog


// subroutine for deleting subdirectories, taken from filemanager.php
function del($delete_ID) {
  global $dateien;
  $result = db_query("select ID, filename, tempname, typ, filesize from dateien where div1 = '$delete_ID'") or db_die();
  while ($row = db_fetch_row($result)) {
    // only delete file when it is not a link
    if ($row[4] > 0) {
      if ($dat_crypt) { $path = "$dateien/$row[2]"; }
      else {$path = "$dateien/$row[1]"; }
      unlink($path);
    }
    $result2 = db_query("delete from dateien where ID = '$row[0]'") or db_die();
    if ($row[3] == "d") del($row[0]); // look for files/links etc. in the subdirectory
  }
}

// subroutine to delete all comments to a posting
function delete_comments($ID) {
  $result = db_query("select ID from forum where antwort = '$ID'") or db_die();
  while ($row = db_fetch_row($result)) {
    delete_comments($row[0]);
    $result2 = db_query("delete from forum where ID = '$row[0]'") or db_die();
  }
}

// display the option 0 = no access, 1 = read, 2 = write for the roles
function role1($module) {
  global $acc_level, $roles_ID;
  // check the db only if it is in the modify mode
  if ($roles_ID > 0) { 
    $result = db_query("select $module from roles where ID = '$roles_ID'") or db_die();
    $row = db_fetch_row($result); 
    $string = "<select name='".$module."_m'>\n";
    foreach ($acc_level as $acc1 => $acc2) {
      $string .= "<option value='$acc1'";
      if ($row[0] == $acc1) $string .= " selected";
      $string .= ">$acc2 \n"; 
    }
    $string .= "</select>\n";     
  }
  else {
    $string =  "<select name='".$module."_m'>\n";
    foreach ($acc_level as $acc1 => $acc2) {     
      $string .= "<option value='$acc1'>$acc2 \n"; 
    }
    $string .= "</select>\n";
  }
  return $string;  
} 


?>
</body></html>
