<?php
// env_test.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

/*
Welcome to the test routine of PHProjekt!
But already now I can tell you that it won't work -
because you see this text here! :-)
This means that your php parser is not working -
otherwise this text would be recognized as a comment and
not shown onthe screen :-|
The requirements for a setup of PHProjekt
are a webserver with a php parser and a sql database.
A typical combination would be a LAMP or WAMP system.
Installation tutorials can be found e.g. here:
http://www.dynamic-webpages.de/07.installation.php
'til later!
*/

// this script will produce tio's own error messages, in this case we
//don't need any additional warnings from the parser :-)
error_reporting(0);
// the variables for this script will partly be treansferred via sessions
// session_start();
// include the gpc_vars library to get all post and get variables, regardsless the value of register_globals
include_once("lib/gpcs_vars.inc.php");
$PHPSESSID=session_id();
// to restart the script all session data have to be deleted
if ($free == 1 or $HTTP_GET_VARS["free"] == 1) {
  session_destroy();
  $parser_test = 0; $env_test = 0; $session_test =0; $db_test = 0; $mail_test = 0; $file_test = 0;
}


echo "<html><head><title>PHProjekt SYSTEM test</title></head><body bgcolor=#E2E2E2>";
echo "<h2>PHProjekt environment test</h2>";
echo "Thank you for taking the time to check whether your <br>environment meets to the needs of a PHProjekt installation<br><br>";

// PHP Version  - exclude PHP3
echo "<br>**********************";
echo "<h4>PHP Parser test</h4>";
if (!$parser_test) {
  echo "<form><input type=hidden name=parser_test value=1>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "First we have a look on the used PHP version<br><br>\n";
  echo "<input type=submit value='Parser test'></form>";
}
elseif ($parser_test == 1) {
  // PHP Version  - exclude PHP3
  if (substr(phpversion(),0,1) == "3") {
    ("<b>sorry, PHP 4 required!</b><br><br> Please download the actual version at <a href='http://www.php.net'>www.php.net</a>. (exit)\n");
  $parser_test = "failed";
  }
  elseif (substr(phpversion(),0,3) == "4.0" and ereg("0|1",substr(phpversion(),4,1))) {
    echo "The used PHP version is 4.0.0 or 4.0.1 - we strongly recommend you to update to a newer version.<br><br>";
  $parser_test = "update recommended";
  }
  else {
    echo "The version of the used PHP parser is 4.x - perfect!";
    $parser_test = "o.k.";
  }
  reg_sess_vars(array("parser_test"));
}
else { echo "<i>PHP version test done, result: $parser_test</i>"; }
// end parser test

// begin environment test
echo "<br>**********************";
echo "<h4>PHP environment test</h4>";
// offer env test
if (!$env_test) {
  echo "<form><input type=hidden name=env_test value=1>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "Now we check whether how the configuration of PHP is set.<br><br>\n";
  echo "<input type=submit value='env test'></form>";
}
// env_test submitted, start test
elseif ($env_test == 1) {

  // magic quotes runtime test
  if (get_cfg_var("magic_quotes_runtime")) {
    echo "Please change the value of 'magic_quotes_runtime' in the php.ini to 'off' <br>\n";
    // add this string to the env-test variable
    $env_test = "change magic_quotes_runtime to 'off' in the php.ini <br>"; 
  }
  else { echo "variable 'magic_quotes_runtime' is set to off - o.k.! <br>"; }

  // open_basedir test
  if (get_cfg_var("open_basedir")) {
    echo "Please delete the value of 'open_basedir' in the php.ini<br>\n";
    $env_test .= "delete the value of 'open_basedir' in the php.ini <br>\n";
  }
  // open basedir correct?
  else {
    echo "variable 'open_basedir' is empty - o.k.! <br>";
  }
  
  // safe mode test
  if ((get_cfg_var("safe_mode") == "on") or (get_cfg_var("safe_mode") == 1))  {  
    echo "your php runs in the safe mode configuration. In this case the PHProjekt directory and all subdirectories have to be owned by the webserver.";
    $env_test .= "safe mode is on! -> the webserver must own all subdirectories of PHProjekt";
  }
  else {
    echo "variable 'safe_mode' is 'off' - o.k.! <br>";
  }  

  // if none of the above test has written an error message into the variable -> "o.k."! :-)
  if ($env_test == 1) { $env_test = "o.k."; }
  // write variable into session
  reg_sess_vars(array("env_test"));
}
// env_test done, show result
else { echo "<i>PHP environment test done, result: $env_test</i>"; }



// session test
echo "<br>**********************";
echo "<h4>Session Test</h4>";

if (!$session_test) {
  echo "<form><input type=hidden name=session_test value=1>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "PHProjekt uses sessions to store information <br>Now we check whether the server has a working session management.<br><br>\n";
  echo "<input type=submit value='session test'></form>";
  $session_ok = 1;
  reg_sess_vars(array("session_ok"));
}
elseif ($session_test == 1) {

  // check whether session.auto_start is on
  if (get_cfg_var("session.auto_start") <> "1") echo "<br>it is recommended that you put session.auto_start to 1<br>";

  if ($session_ok == 1) {
    echo "<i>Session management works!</i>";
    $session_test = "o.k.";
  }
  else {
    echo "oops - can't find my session!";
    $session_test = "failed";
  }
  // look whether the tmp path is set
  if (!is_dir(session_save_path()) and !preg_match("/^[a-zA-Z0-9]*\.[a-zA-Z0-9]*$/",session_save_path())) {
    echo"<br>Hint: There is no path given in the php.ini. It is recommended to insert a path<br> in the variable session.save_path at php.ini which has write permission for the webserver.";
    $session_test = "failed";
  }
  reg_sess_vars(array("session_test"));
}
else { echo "<i>Session management test done, result: $session_test</i>";  }


// sql test
echo "<br>**********************";
echo "<h4>Database Access</h4>";

if (!$db_test) {
  echo "Please enter your db access parameters, the script will try to connect to the database:\n";
  echo "<form>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type=hidden name=db_test value=1>\n";
  // select database
  echo "<table><tr><td>db_type:</td><td> <select name=db_type>\n";
  echo "<option value='mysql'>mysql\n";
  echo "<option value='oracle'>oracle\n";
  echo "<option value='informix'>informix\n";
  echo "<option value='postgresql'>postgres\n";
  echo "<option value='ms_sql'>MS SQL\n";
  echo "</select></td></tr>\n";
  echo "<tr><td>Host:</td><td><input type=text name=db_host></td></tr>\n";
  echo "<tr><td>Username:</td><td><input type=text name=db_user></td></tr>\n";
  echo "<tr><td>Password:</td><td><input type=Password name=db_pass></td></tr>\n";
  echo "<tr><td>Database name:</td><td><input type=text name=db_name></td></tr>\n";
  echo "<tr><td>&nbsp;</td><td><input type=submit value='db test'></td></tr>\n";
  echo "</table></form>\n";
}
elseif($db_test == 1) {
    //*** db test
    // test mysql access
    if ($db_type == "mysql") { $link = mysql_connect($db_host,$db_user,$db_pass) or $db_test = "failed"; }

    // test interbase access
    elseif ($db_type == "interbase") {
      $db_host2 =  "$db_host:$db_name";
      $link = ibase_connect($db_host2, $db_user, $db_pass) or $db_test = "failed";
    }
    // test ms_sql
    elseif ($db_type == "ms_sql") {
      $link = mssql_connect($db_host, $db_user, $db_pass) or $db_test = "failed";
    }
    // test oracle
    elseif ($db_type == "oracle") {
      $link = OCILogon($db_user, $db_pass, $db_name) or $db_test = "failed";
      $datestmt = OCIParse($link, "alter session set NLS_DATE_FORMAT='YYYY-MM-DD HH:MI:SS'");
      OCIExecute($datestmt);
    }
    // test informix
    elseif ($db_type == "informix") {
      if ($db_host == "") { $db = $db_name; }
      else { $db = $db_name."@".$db_host; }
      $link = ifx_connect($db, $db_user, $db_pass) or $db_test = "failed";
    }
    // test postgres
    elseif ( $db_type == "postgresql" ) {
      echo "<br>Trying to connect to $db_name";
      $link = pg_connect((($db_host == "") ? "" : "host = $db_host ").(($db_pass == "") ? "" : "password=$db_pass ")."dbname=$db_name user=$db_user");
      echo "<br>$link";
      if (!$link) {
        echo "<br>Trying to connect to template1";
        $link = pg_connect((($db_host == "") ? "" : "host = $db_host ").(($db_pass == "") ? "" : "password=$db_pass ")."dbname=template1 user=$db_user") or $db_test = "failed";
        echo "<br>Trying to create database $db_name";
        $result = pg_exec($link, "CREATE DATABASE $db_name") or $db_test = "failed";
        echo "<br>Database create, closing connection to template1";
        $link = pg_close($link) or die("Can't close database connection");
        echo "<br>Opening new connection to db $db_name";
        $link = pg_connect((($db_host == "") ? "" : "host = $db_host ").(($db_pass == "") ? "" : "password=$db_pass ")."dbname=$db_name user=$db_user") or $db_test = "failed";
        }
    }
    //** end test db access

    // output error message
    if ($db_error == 1 or !$link or (isset($conn) and !$conn)) {
      echo "oops - no connection to the dataase!<br>Reasons could be:<ul>
      <li>Wrong access parameter, <li>The database is not running, <li>The database hasn't been setup correctly,
      <li>The PHP parser has not been installed with this db support
      </ul>Please fix it and try it again ...<br><br>";
      $db_test = "failed";
    }
    else {
      echo "Seems that connecting the database has been successful :-)";
      $db_test = "o.k.";
    }
    reg_sess_vars(array("db_test"));
}

else { echo "<i>Database acess test done, result: $db_test</i>";  }
// end db test


// **********
// mail check
echo "<br>**********************";
echo "<h4>Mail Test</h4>\n";

if (!$email) {
  echo "Here you can test whether you are able to send and receive mails with PHProjekt.<br>
  Enter your email adress here, the script will send you an email:<br>\n";
  echo "<form><input type=text name=email>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type=submit value='send mail'></form>\n";
}
elseif ($email <> 2) {
  mail($email,"PHProjekt Mail Test","Congratulations!\n Now you know that you can
  use PHProjekt to send mails\n","From:$user_email\nReply-To:$user_email\nSender:$user_email\nReturn-Path:$user_email");
  echo "Please check your mailbox whether you got a mail from PHProjekt. If not, you should examine the mail settings in your php.ini";

// imap extensions test
  if (function_exists('imap_open')) {
    echo "<br>Checking your mail configuration ... the IMAP library is active, therefore you can use the full mail client";
    $email_receive_test = "o.k.";
  }
  else {
    "<br>oh, the imap library from PHP is missing, at the moment you cannot install the full email client :-(
    <br /> pleae tell your sysadmin or provider to install the imap library of php (not to be mixed with the imap server). ";
    $email_receive_test = "failed";
  }
  reg_sess_vars(array("email_receive_test"));
}
else { echo "<i>Email test done, result: receive email $email_receive_test</i>";  }


// *********
// file test
echo "<br>**********************";
echo "<h4>File writing Test</h4>";

if (!$file_test) {
  echo "<form><input type=hidden name=file_test value=1>\n";
  echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "Now the script proofs whether it is able to write <br>a test file in the PHProjekt root diretory.<br><br>\n";
  echo "<input type=hidden name=file_test value=1>\n";
  echo "<input type=submit value='file_test'></form><br>\n";
}
elseif ($file_test == 1) {
  $fp = fopen("test_phprojekt.txt",'w');

  if (!$fp or $fp == "FALSE") {
    echo "I couldn't write this file!<br>Please give the webserver read and write permission for this directory!\n";
    $file_test = "failed";
  }
  else {
    $fw = fwrite($fp,"This file was created for testing reasons. You can delete it.");
    echo "test file successfully written! Now it will be deleted again ...<br>\n";
    $file_test = "o.k.";
    fclose($fp);
    $delete = unlink("test_phprojekt.txt");
    if (!$delete) {
      echo ".. but it failed to erase this file!";
      $file_test = "failed";
    }
  }

  // additional test - check whether file_uploads is set to "on"
  if (get_cfg_var("file_uploads") <> "1") {
    echo "Please change the value of 'file_uploads' in the php.ini to 'on', otherwise you can't use the file or mail module!";
    if ($file_test == "o.k.") $file_test .= " but please change 'file_uploads' in the php.ini to 'on'.";
  }
  reg_sess_vars(array("file_test"));
}
else { echo "<i>file management test done, result: $file_test</i>";  }

echo "<br>**********************";
echo "<br><br>If you want to run this test another time, please follow <a href='env_test.php?free=1'>this link here</a><br>";

// read and write permissions for root, attach, chat and upload directory
// blank screen problem! -> include of en.inc.php possible?

// next proof: file_uploads in the php.ini must be set to on ..



?>
</body></html>