<?php
// lib.inc.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// array with available languages
$languages = array("ad","ba","br","ct","cz","da","de","en","es","fi","fr","gr","hu","is","it","ko","nl",
                   "no","pl","pt","ro","ru","se","si","sk","tr","tw","zh");
$perpage_values = array("10","20","30","50","100");   
// array with port types, will be used on several stages
// array for mail account types and ports
$port = array("pop3" => "110","pop3s" => "995","imap" => "143","imap3" => "220","imaps" => "993","imap4-ssl" => "585",
              "imap/NOTLS" => "143/NOTLS", "imap/NOVALIDATE" => "143/NOVALIDATE");                

//***************
// include config

// fetch parameters from config.inc.php - could be placed in the PHProjekt root or two levels above = outside the webroot!
// only avoid including the config if the setup routine is active ...
if (!defined("setup_included")) {
  $config_path = $path_pre."config.inc.php";  // set config path for files in subdir
  if (is_readable("./$config_path")) { include_once("./$config_path"); }  
  elseif (is_readable("../../$config_path")) { include_once("../../$config_path"); }
  else { die("panic: config.inc.php doesn't exist!! Did you backup it after installation? ...<br>(If you run this tool for the first time: please read the file INSTALL in the PHProjekt root directory)"); }
}

// ****************************
// set variables and contstants
// ****************************

// set include path.
$var_ini_set = ini_set('include_path','./');
// parse transmitted variables
$include_path = $path_pre."lib/gpcs_vars.inc.php";
include_once $include_path; 
// change path if a script from a subdir is calling ...
$lang_path = $path_pre."lang";
$lib_path = $path_pre."lib";
$img_path = $path_pre."img";
// set constant to ensure that the lib is included (especially for those who want to access a script directly)
define ("lib_included","1");
// set time
$dbTSnull = date("YmdHis", mktime(date("H")+$timezone,date("i"),date("s"),date("m"),date("d"),date("Y")));



// ******************
// error and security
// ******************

// define the error level
if (!isset($error_reporting_level) or !$error_reporting_level) { error_reporting(0); }
else { error_reporting( E_ALL & ~E_NOTICE); }
// avoid this d... error warning since it does not affect the scritps here
$var_ini_set = ini_set("session.bug_compat_42", 1);
$var_ini_set = ini_set("session.bug_compat_warn", 0);

// check whether $path_pre doesn't redirect to some outer place
if (isset($path_pre) and $path_pre <> "./" and $path_pre <> "../" and $path_pre <> "../../") { die("You are not allowed to do this"); }

// limit session to a certain time [minutes]
if ($session_time_limit) {
  if (!$begin) {
    $begin = time();
    reg_sess_vars(array("begin"));
  }
  else {
    $now = time();
    if (($now - $begin) > ($session_time_limit*60)) {
      session_unset();
      $indexpath = $path_pre."index.php";
      die ("<a href='$indexpath' target='_top'>$index_text5!</a>");
    }
    else {
      $begin = $now;
      reg_sess_vars(array("begin"));
    }
  }
}

// ************
// db functions
// ************
include_once("$lib_path/db/$db_type.inc.php"); 
// ************

// ****************
// string functions
// ****************

// safe HTML output
function html_out($outstr){
  if ($outstr <> "") return ereg_replace("'","&#39;",htmlspecialchars($outstr));
}
// the same specialy for hidden form fields and select field option values (uev -> UrlEncodedValues)
function uev_out($outstr){return ereg_replace("'","&#39;",htmlspecialchars(urlencode($outstr)));}  #

// here we will build the iso format
function show_iso_date1($date) { return substr($date,0,4)."-".substr($date,4,2)."-".substr($date,6,2)." ".substr($date,8,2).":".substr($date,10,2); }
function show_iso_date2($date) { return substr($date,0,4)."-".substr($date,4,2)."-".substr($date,6,2); }

// quotation related string treatment for arrays
  // to call with array_walk()
// function arr_addsl(&$item,$key){$item = addslashes($item);}
   // is moved to gpcs_vars.inc.php because used before loading lib.inc.php
function arr_stripsl(&$item,$key){$item = stripslashes($item);}
function arr_dequote(&$item,$key){$item = addslashes(ereg_replace('^\"|\"$','',$item));}

// change colours in list view
function tr_tag ($dblclick,$parent="") {
  global $cnr, $bgcolor1, $bgcolor2, $tr_hover;
  // alternate bgcolor
  if (($cnr/2) == round($cnr/2)) { $color = "$bgcolor1"; $cnr++;}
  else { $color = "$bgcolor2"; $cnr++; }
  // highlight table rows?
  if ($tr_hover) { $tr_hover_on = "onmouseover=\"this.style.backgroundColor = '#ffffff'\" onmouseout=\"this.style.backgroundColor = '$color'\" onDblClick=\"".$parent."location.href = '$dblclick'\""; }
  else { $tr_hover_on = ""; }
  // html output
  echo "<tr bgcolor=$color $tr_hover_on>\n";
}

// ***************************
// Authentication and settings
// ***************************

// fetch user data
// pass this check only it the constant 'avoid_auth' is set in the script
if (!defined("avoid_auth")) { include_once("$lib_path/auth.inc.php"); }
  
// end authentication
// ***************

// *************
// language part
// *************

// language given? -> include language file
if ($langua) { include_once("$lang_path/$langua.inc.php"); }
// determine language for login and -if no language is given in the db- further on
else { 
  // determine language of browser
  $langua = getenv("HTTP_ACCEPT_LANGUAGE");
  // special patch for canadian users
  if (eregi("ca",$langua)) {
    if (eregi("en",$langua)) { $langua = "en"; $found = 1; } // english canadian
    if (eregi("fr",$langua)) { $langua = "fr"; $found = 1; } // french canadian
  }
  // special patch for user with konqueror :-)
  elseif (eregi("queror",$langua)) { $langua = "en"; $found = 1; }
  // otherwise loop over all available languages
  else {
    foreach($languages as $langua1) {
      if (eregi($langua1,$langua)) {
        $langua = $langua1; $found = 1;
      }
    }
  }
  // include the found language
  if ($found) { include_once("$lang_path/$langua.inc.php"); }
  // nothing found? -> take english
  else { $langua = "en"; include_once("$lang_path/en.inc.php"); }
}
// set charset
if     (eregi('pl|cz|hu|si',$langua)) { $lcfg="charset=iso-8859-2"; }
elseif ($langua=="sk") {$lcfg  = "charset=windows-1250"; }
elseif ($langua=="ru") { $lcfg = "charset=windows-1251"; }
elseif ($langua=="tw") { $lcfg = "charset=big5"; }
elseif ($langua=="zh") { $lcfg = "charset=gb2312"; }
if ($lcfg <> "") { $lang_cfg = "<meta http-equiv='Content-Type' content='text/html; $lcfg'>"; }

// assign help files
  // list all languages without own help files, they have to take english
  if (eregi('br|da|hu|gr|is|ko|no|pl|pt|ru|se|sk',$langua)) { $doc = $path_pre."/help/en"; }
  elseif ($langua=="tw") { $doc = $path_pre."/help/zh"; }
  // assuming catalan users would like to read spanish help  :)
  elseif ($langua=="ct" or $langua == "ad") { $doc = $path_pre."help/es"; }
  // the rest gets their own help files
  else { $doc = $path_pre."help/$langua"; }
// end help files

// end language definitions
// ************************

// ******
// layout
// ******

// *********** 
// skins & css
 
// fetch skin
// if no skin is given, take the dafault one
if (!$skin) $skin = "default";
// include the chosen skin
include($path_pre."layout/".$skin."/".$skin.".php");

// Determine OS for style sheet
$css_style = def_style(); 
// end skins & css

// ****************
// menu & separator

  // separation bar
function separation($width = 200){
  global $img_path;
  echo "<img src='$img_path/s.gif' width=$width height=1 vspace=0>\n";
}
  // show a module related submenu
function submenu($menubar,$width = 200){

  echo "<table width=$width cellpadding=2 border=0><tr>";
  foreach($menubar as $but){
    echo"<td id=m".($but[0]?"h":"l")."><a id=m".($but[0]?"h":"l")." href=\"$but[1]\">$but[2]</a></td>\n";
  }
  echo"</tr></table>";
}
// end submenu and separator

// perpage values
if (!$perpage) {
  if ($start_perpage) { $perpage = $start_perpage; }
  else { $perpage = "30"; }    
}

// end layout
// **********

// group string for sql queries
if ($user_group) { $sql_user_group = "(gruppe = '$user_group')"; }
// all groups available for e.g. admin root, must be true in all cases
else { $sql_user_group = "(1 = 1)"; }

// transmit PHPSESSID in GET-strings if needed (no cookies) only
$sid = (SID?"&".SID:"");

// this function returns the level of an szb-element - useful to indent elements in a list
// parameter: table and column name, $query, $access column,order by, value of element to show as selected, name of parent column
function show_elements_of_tree($table,$name,$query,$acc,$order,$selected,$parent,$parent_ID) {
  global $indent, $user_kurz, $user_access, $subdirs;

  // fetch parent project
  $result = db_query("select ID,$acc,$name from $table $query and $parent = '$parent_ID' $order") or db_die();
  while ($row = db_fetch_row($result)) {

    // if the table is table projects, check whether the user is a participant of the project
    switch ($table) {
      case "projekte":
        if (ereg("\"$user_kurz\"",$row[1]) or ereg("c",$user_access)) { $allowed = 1; }      
        break;
      case "contacts":
        // last name, first name in the select box gives a better distinction
        $row[2] = $row[2].",".$row[3];
        // since in the query the permission is already included we don't need another criterium
        $allowed = 1;
        break; 
      case "dateien":               
        $row[2] = ereg_replace(""," ",$row[2]); 
        // exclude all diretories which are in the 'below current object' list
        if (!in_array($row[0],$subdirs)) $allowed = 1;   
        break;
    }

    // access allowed
    if ($allowed == 1) {
      echo "<option value='$row[0]'";
      if ($row[0] == $selected) { echo " selected"; }
      echo ">";
      for ($i = 1; $i <= $indent; $i++) { echo "&nbsp;&nbsp;"; }
      echo "$row[2]</option>\n";
    }

    // look for subelements
    $indent++;
    show_elements_of_tree($table,$name,$query,$acc,$order,$selected,$parent,$row[0]);
    $indent--;
  }
}

// adds hidden fields to some forms
//   - for modules that have different forms for create and modify data
$view_param = array('up'=>$up,'sort'=>$sort,'perpage'=>$perpage,'page'=>$page,'filter'=>$filter,'keyword'=>$keyword);

function hidden_fields($hid){
  reset($hid);
  foreach($hid as $key=>$value) {
        echo "<input type=hidden name=$key value=$value>\n";
   }
}

// routine to check which access status the user has concerning a module and according to his role
function check_role($module) {
  global $user_ID;
  $result = db_query("select roles.ID, $module from roles, users where users.role = roles.ID and users.ID = '$user_ID'") or db_die();
  $row = db_fetch_row($result);
  // is there a role for this user?
  if ($row[0] > 0) {
    // return the numeric value of the status: 0 = no access, 1 = read, 2 = write
    return $row[1];
  }
  // otherwise give him the full rights
  else { return "2"; }  
}    

// simple select form for export options
function show_export_form($file) { 
  global $img_path, $print, $exp1, $keyword, $filter, $sort, $up, $month, $year, $anfang, $ende, $pdf_support, $PHPSESSID;
  $hidden = array('file'=>$file,'PHPSESSID'=>$PHPSESSID,'filter'=>$filter,'keyword'=>$keyword,'up'=>$up,'sort'=>$sort,'month'=>$month,'year'=>$year);
  if ($file == "project_stat") {  $hidden = array_merge(array('anfang'=>$anfang,'ende'=>$ende), $hidden); }
  echo "<form action='../misc/export.php' method=post>\n";
  hidden_fields($hidden);  
  echo "$exp1: <select name=medium>\n";   
  if ($pdf_support) echo "<option value=pdf>PDF\n";
  echo "<option value=xml>XML\n";
  echo "<option value=html>HTML\n";  
  echo "<option value=csv>CSV\n";
  echo "<option value=xls>XLS\n";    
  echo "<option value=rtf>RTF\n";
  echo "<option value=doc>DOC\n";  
  echo "<option value=print>$print\n";          
  echo "</select> <input type=image src='$img_path/los.gif' border=0 id=tr></form>&nbsp;";
}

// this function gets the OS of the browser and chooses the appropiate css file
function def_style() {
  global $HTTP_USER_AGENT, $path_pre, $skin;
  // mac platform ...
  if (eregi("mac", $HTTP_USER_AGENT)) { return $path_pre."layout/".$skin."/css/mac.css"; }
  // windows OS ...
  elseif (eregi("win", $HTTP_USER_AGENT)) {
    // special css for 4.x NN browsers
    if (eregi("4.7|4.6|4.5", $HTTP_USER_AGENT)) { return $path_pre."layout/".$skin."/css/nn4.css"; }
    // css for IE and opera
    else  { return $path_pre."layout/".$skin."/css/win.css"; }
  }
  // default layout - not very nice but could fit a bit at least
  else { return $path_pre."layout/".$skin."/css/common.css"; }
} // end find style sheet

// for ldap
function logit($message) {
	openlog("phprojekt", LOG_NDELAY|LOG_PID, LOG_USER);
	syslog(LOG_DEBUG, $message);
	closelog();
}

?>
