<?php

// export.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther, Norbert Ku:ck

$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;

  switch ($file){
    case "timecard":
      $fields = array("datum",     "anfang",   "ende"   );
      $f_lang = array($datei_text6,$proj_start,$proj_end);       
      $sql_fields = implode(",",$fields);
      $query = "select $sql_fields from timecard where users = '$user_ID' and datum like '%-$month-%' and datum like '$year-%' order by datum";
      $export_array = make_export_array($query);
      break;
       
    case "timecard_admin":
      check_admin_perm();
      $fields = array("datum",     "anfang",   "ende"   );
      $f_lang = array($datei_text6,$proj_start,$proj_end);       
      $sql_fields = implode(",",$fields);           
      $query = "select $sql_fields from timecard where users = '$pers_ID' and datum like '%-$month-%' and datum like '$year-%' order by datum";
      $export_array = make_export_array($query);
    break;
    
    case "users":
      $fields = array("anrede",    "vorname",  "nachname",  "kurz",   "firma",    "email","tel1",        "tel2", "fax", "strasse", "plz",       "stadt",     "land"   );
      $f_lang = array($info_text17,$info_text9,$info_text10,$m1_text27,$m1_text28,"Email",$m1_text29."1",$m1_text29."2",$m1_text31,$admin_text26,$info_text13,$info_text14);     
      $sql_fields = implode(",",$fields); 
      $query = "select anrede, vorname, nachname, kurz, firma, email, tel1, tel2, fax, strasse, plz, stadt, land from users where $sql_user_group";
      $export_array = make_export_array($query);
      break;
       
    case "contacts":
      if ($keyword) {
         if ($filter == "all" or $filter == '') { $where = "and (nachname like '%$keyword%' or firma like '%$keyword%' or email like '%$keyword%' or stadt like '%$keyword%' or land like '%$keyword%' or kategorie like '%$keyword%' or bemerkung like '%$keyword%')"; }
         else { $where = "and $filter like '%$keyword%'"; }
      }
      $fields = array("anrede",    "vorname",  "nachname",  "firma",     "email","email2","tel1",         "tel2",         "fax",     "mobil",      "strasse",   "plz",        "stadt",     "land",      "state",     "kategorie","bemerkung",  "url");
      $f_lang = array($info_text17,$info_text9,$info_text10,$info_text11,"Email","Email2",$m1_text29."_1",$m1_text29."_2",$m1_text30,$admin_text92,$info_text12,$admin_text26,$info_text13,$info_text14,$info_text18,$ress_cat,  $admin_text71,"URL",$inst_text19b."_1",$inst_text19b."_2");
      $sql_fields = implode(",",$fields);     
      $query = "select $sql_fields from contacts where (von = '$user_ID' or acc like 'a') and $sql_user_group $where order by nachname";
      $export_array = make_export_array($query);
      break;
       
    case "bookmarks":
      $fields = array("url","bezeichnung","bemerkung");
      $f_lang = array("url",$m1_text35,   $m1_text36);       
      $sql_fields = implode(",",$fields);     
      $query = "select $sql_fields from lesezeichen where gruppe = $user_group";
      $export_array = make_export_array($query);
      break;
         
    case "timeproj":
      $fields = array("timeproj.datum","projekte.name","timeproj.h","timeproj.m","timeproj.note");
      $f_lang = array($info_text2,     $proj_name,     $proj_time2,  $rem_text2, $info_text7);       
      $sql_fields = implode(",",$fields);    
      $query = "select $sql_fields from timeproj,projekte  where
                timeproj.projekt = projekte.ID and timeproj.users = $user_ID and timeproj.datum like '$year-$month-%'
                order by timeproj.datum asc";
      $export_array = make_export_array($query);                
      break;
      
    case "project_stat":
      if ($userlist and $projectlist) { 
        foreach ($userlist as $person) {
          foreach ($projectlist as $project) { 
            $fields = array("users.vorname","users.nachname","projekte.name","timeproj.datum","timeproj.h","timeproj.m","timeproj.note");
            $f_lang = array($info_text9,    $info_text10,     $proj_name,    $info_text2,     $proj_time2, $rem_text2,  $info_text7);
            $sql_fields = implode(",",$fields);        
            $query = "select $sql_fields from users, projekte, timeproj where 
                              timeproj.projekt = projekte.ID and timeproj.users = users.ID and 
                              timeproj.projekt = '$project' and timeproj.users = '$person' and  
                              timeproj.datum >= '$anfang' and timeproj.datum <= '$ende' order by timeproj.datum";
            $export_array = array_merge($export_array, make_export_array($query)); 
          }
        }
      }  
      break;
          
    default:
      die("You are not allowed to do this!");     
  }

// **********  
// set header  
$name = $file.".".$medium;
// print and html should be shown inline, the rest delivered as attachment
if (ereg("html|print",$medium)) { $file_download_type = "inline"; }
else { $file_download_type = "attachment"; }
$include_path = $path_pre."lib/get_contenttype.inc.php";
include_once $include_path; 
// end set header

switch ($medium) {

  // **********
  // pdf output
  case "pdf":
    $table = array();
    if (!is_file("./class.ezpdf.php")) { die("Panic - cannot find the required pdf classes! Read the faq_install.html for the required steps to install this library or disable the pdf support in the config or choose another export format"); }
    else { include ("./class.ezpdf.php"); }
    $pdf = new Cezpdf();
    $pdf->selectFont('../lib/fonts/Helvetica');
    foreach ($export_array as $line) {
      $line2 = array();
      for ($i=0;$i < count($line); $i++) {
        $line2[$f_lang[$i]] = $line[$i]; 
      }
      $table[] = $line2;
    }
    $pdf->ezTable($table);
    $pdf->ezStream(); 
  break;
  
  // ************
  // chart output
  // ************
   
  case "chart":
  break;
  
  // **********
  // xml output
  case "xml":
    $xmlstring = "<?xml version=\"1.0\"?>\n";
    $xmlstring .= "<table>\n";
    if ($export_array) {    
      foreach ($export_array as $line) {
        $xmlstring .= "  <record>\n";  
        for ($i=0;$i < count($line); $i++) {  
          $xmlstring .= "    <".$f_lang[$i].">".$line[$i]."</".$f_lang[$i].">\n";
        }
        $xmlstring .= "  </record>\n";    
      }
    }  
    $xmlstring .= "</table>";
    echo $xmlstring;
  break;
  
   // **********
  // rtf output
  case "rtf":
    $rtfstring = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang2055{\\fonttbl{\\f0\fnil\\fcharset0 Helvetica;}}\n";
    $rtfstring .= "\\viewkind4\\uc1\\pard\\f0\\fs20";
    // first the header ...
    for ($i=0; $i<count($f_lang)-1;$i++) { 
      $rtfstring .= "\\b $f_lang[$i]\\b0\\tab";      
    }
    $i++;
    $rtfstring .= "\\b $f_lang[$i]\\b0\\par\n";    
    
    // now the content
    foreach ($export_array as $line) {
      for ($i=0;$i < count($line)-1; $i++) {  
        $rtfstring .= " $line[$i] \\tab";
      }
      $i++;
      $rtfstring .= " $line[$i]\\par\n";
    }
    $rtfstring .="}";
    echo $rtfstring;
  break; 
  
   // **********
  // doc output - same as rtf, but only theheader is slightly different :-)
  case "doc":
    $rtfstring = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang2055{\\fonttbl{\\f0\fnil\\fcharset0 Helvetica;}}\n";
    $rtfstring .= "\\viewkind4\\uc1\\pard\\f0\\fs20";
    // first the header ...
    for ($i=0; $i<count($f_lang)-1;$i++) { 
      $rtfstring .= "\\b $f_lang[$i]\\b0\\tab";      
    }
    $i++;
    $rtfstring .= "\\b $f_lang[$i]\\b0\\par\n";    
    
    // now the content
    foreach ($export_array as $line) {
      for ($i=0;$i < count($line)-1; $i++) {     
        if (!$line[$i]) $line[$i] = " ";
        $rtfstring .= " $line[$i]\\tab";
      }
      $i++; 
      if (!$line[$i]) $line[$i] = " ";
      $rtfstring .= " $line[$i]\\par\n";
    }
    $rtfstring .="}";
    echo $rtfstring;
  break;   
  
  // ****************
  // normal print page
  case "print":
  // begin body of html page and table
  echo "<html><body bgcolor=ffffff onLoad='self.print()'><table border=1 cellpadding=1 cellspacing=0>\n";
  // first put the colums
  echo "<tr>";
  for ($i=0; $i<count($f_lang);$i++) { echo "<td>$f_lang[$i]</td>\n"; }
  echo "</tr>\n";
  // now the content
  foreach ($export_array as $line) {
    echo "<tr>\n";
    foreach ($line as $element) {
      echo "<td>$element&nbsp;</td>";
    }
    echo "</tr>\n";
  }
  // end of table and html page
  echo "</table></body></html>";
  break;
  
  // ***********************
  // xls export - very similar to csv
  case "xls":
    // begin file
    $xlsstring = pack( "ssssss", 0x809, 0x08, 0x00,0x10, 0x0, 0x0 );
    // write 1. line = field names
    for ($i=0; $i<count($f_lang);$i++) { 
      $xlsstring .= pack( "s*", 0x0204, 8+strlen($f_lang[$i]), 0, $i, 0x00, strlen($f_lang[$i]) );
      $xlsstring .= $f_lang[$i];      
    }
    // write content  
    $a=0;
    foreach ($export_array as $line) {
      for ($i=0;$i < count($line); $i++) {
        $xlsstring .= pack( "s*", 0x0204, 8+strlen($line[$i]), $a+1, $i, 0x00, strlen($line[$i]) );
        $xlsstring .= $line[$i];
      }
      $a++;
    }
    $xlsstring .= pack("ss", 0x0A, 0x00);
    echo $xlsstring;
    break;  
    
  // ***********************
  // html - similar to print page
  case "html":
    // begin body of html page and table
    echo "<html><body bgcolor=$bgcolor3><table border=1 cellpadding=1 cellspacing=0>\n";
    // first put the colums
    echo "<tr bgcolor=$bgcolor2>";
    for ($i=0; $i<count($f_lang);$i++) { echo "<td><b>$f_lang[$i]</b></td>\n"; }
    echo "</tr>\n";
    // now the content
    if ($export_array) { 
      foreach ($export_array as $line) {
        // alternate bgcolor
        if (($cnr/2) == round($cnr/2)) { $color = "$bgcolor1"; $cnr++;}
        else { $color = "$bgcolor2"; $cnr++; }
        echo "<tr bgcolor=$color>\n";
          foreach ($line as $element) {
          echo "<td>$element&nbsp;</td>";
        }
        echo "</tr>\n";
      }  
    }
    // end of table and html page
    echo "</table></body></html>";
    break;     

  // ***********************
  // default case: csv export
  default:
    foreach ($export_array as $line) { 
       foreach ($line as $element) {
        /* 
        if (ereg(":{",$element)) {
          $element = unserialize($element);
          $element = implode(":", $element);
        }*/
        // delete end of lines in data
        $element = rtrim(eregi_replace("\n|\r"," ",$element));
        
        // mask doublequotes in data for reimport
        $element = ereg_replace('"','""',$element);
        echo "\"$element\"";
        if ( $i < (count($line)-1) ) { echo ","; $i++; }
        else { echo "\n";  $i = 0; }
        
      }
    }
    break; 
}  


// check whether this admin has the permission to export the timecard from this user
function check_admin_perm() {
  global $user_group, $user_access, $groups, $pers_ID;

  // 1. check: is this user an admin?
  if (!ereg("a",$user_access)) { die("you are not allowed to do this!"); }

  // 2. check for the right group - only if it is a group admin
  if ($groups and $user_group > 0) {
    // loop over all groups where the mentioned user is member
    $result = db_query("select grup_ID from grup_user where user_ID = '$pers_ID'") or db_die();
    while ($row = db_fetch_row($result)) {
      // one entry matches the group of the admin? -> fine :-)
      if ($row[0] == $user_group) { $ok = 1; }
    }
    // no entry found -> die ...
    if (!$ok) { die("you are not allowed to do this!"); }
  }
}

function make_export_array($query) {
  $result = db_query($query) or db_die();
  while ($row = db_fetch_row($result)) { 
    $line = array();
    foreach($row as $element) { $line[] = $element; }
    $export_array[] = $line;
  } 
  return $export_array;
}

?>
