<?php

// notes_view.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// check role
if (check_role("notes") < 1) { die("You are not allowed to do this!"); }

$include_path = $path_pre."lib/permission.inc.php";
include_once $include_path;

// *********
// list view
// *********
if ((!$new_note and !$ID and !$contact_ID and !$projekt_ID) or $notes_view_both ){


  // **************
  // navigation bar

  // filter & items per page
  echo "<table bgcolor=$bgcolor2 border=0>\n";
  echo "<form action='notes.php' method=post>\n";
  if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
  echo "<input type='hidden' name='up' value='$up'>\n";
  echo "<input type='hidden' name='sort' value='$sort'>\n";

  // title and link to help file
  echo "<tr><td><a href='$doc/notes.html' target=m><b>$o_notes</b></a></td>\n";

  // filter
  echo "<td>$rts_21:</td><td><input type='text' size='15' name='keyword' value='$keyword'></td><td>$rts_22</td>\n";
  echo "<td><select name='filter'>";
  foreach ($fields as $field1 => $field2) {  
    echo "<option value='$field1'";
    if ($field1 == $filter) { echo " selected"; }
    echo ">$field2\n";
  }
  echo "</select></td>\n";
  // end filter

  // perpage select box
  echo "<td>&nbsp;<select name='perpage'>\n";
  foreach ($perpage_values as $j) {
    echo "<option value='$j'";
    if ($j == $perpage) { echo " selected"; }
    echo ">$j\n";
  }
  echo "</select> $items</td>\n";
  // end perpage slect box, next submit button
  echo "<td><input type=image src='$img_path/los.gif' border='0' id='tr'></td></form></tr>\n";

  // link for new notes
  if(!$notes_view_both and check_role("notes") > 1) {
    echo "<tr><td><a href='notes.php?mode=view&new_note=1&sort=$sort&up=$up&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter$sid'>$con_text4</a> | </td>\n";
  }
  else echo "<tr><td>&nbsp;</td>\n";

  // keyword
  if ($keyword) {
    if ($filter == "all") { $where =  "(notes.name like '%$keyword%' or notes.remark like '%$keyword%') and"; }
    else { $where = "$filter like '%$keyword%' and"; }
  }
  
  // define access: 
  // 1. groupless system
  if (!$groups) { $where .= " (notes.von = $user_ID or notes.ext = '1')"; }
  
  // 2.a) if user is root in group system (doesn't belong to any group and $user_ID = 1), he has access to his own notes
  elseif ($groups and $user_ID == 1) { $where .= " notes.von = $user_ID"; }

  // 2.b) all other users in the group system: own notes and additionally to the open notes of his/her group  
  else { $where .= " (notes.von = $user_ID or notes.ext = $user_group)"; }

  // define 'next' & 'previous' button
  $result = db_query("select count(ID) from notes where $where") or db_die();
  $row = db_fetch_row($result);
  if ($row[0] > $perpage) { echo "<td colspan=6>&nbsp;\n"; }
  $page_n = $page + 1;
  $page_p = $page - 1;
  if ($page) {
    echo "<a href='notes.php?mode=view&perpage=$perpage&page=$page_p&up=$up&sort=$sort&filter=$filter&keyword=$keyword$sid'>$previous</a>&nbsp;&nbsp;\n";
  }
  if ($row[0] > $page_n*$perpage) {
    echo "<a href='notes.php?mode=view&perpage=$perpage&page=$page_n&up=$up&sort=$sort&filter=$filter&keyword=$keyword$sid'>$next</a>\n";
  }
  // end of navigation bar
  echo "</td></tr></table><br>";

  // ***********
  // record list
  // ***********

  // sort & direction
  if (!$sort) { $sort = "div2"; }
  if ($up == "1") { $direction = "ASC"; $up2 = 0; } else { $direction="DESC"; $up2 = 1; }

  // end table form and begin table with record list
  echo "<table  border=0 cellpadding=2 cellspacing=1 width=100%>\n";
  echo "<tr bgcolor=$bgcolor3><td>&nbsp;</td>\n";
  $e1="<td><b><a href='notes.php?mode=view&sort=";
  $e2="&up=$up2&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter$sid'>";
  $e3="</a></b></td>\n";
  // sort by title
  echo $e1."name".$e2.$forum_text5.$e3;
  // sort by date of creation
  echo $e1."div1".$e2.$notes_text2.$e3;
  // sort by date of last change
  echo $e1."div2".$e2.$notes_text3.$e3;
  // contact
  if ($adressen and !$contacts_nolink) { echo $e1."contact".$e2.$proj_text12.$e3; }
  // sort by project
  if ($projekte) {  echo $e1."projekt".$e2.$l_text11.$e3; }
  echo "</tr>\n";

  // query
  $query = "select ID,name,remark,contact,div1,div2,projekt,ext,von from notes where $where order by $sort $direction";
  $result = db_query($query) or db_die();
  while ($row = db_fetch_row($result)) {
    if ($b >= $page*$perpage and $b < ($page+1)*$perpage) {
      $ref = "notes.php?ID=$row[0]&mode=view&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter&sort=$sort&direction=$direction$sid";
      tr_tag($ref);
      // button with text of the remark
      echo "<td width=40><img src=$img_path/b.gif alt='".html_out(trim(substr($row[2],0,60)))."' title='".html_out(trim(substr($row[2],0,60)))."' width=7>&nbsp;\n";
      // ... delete button
      if ($row[8] == $user_ID) {
        echo "<a href='notes.php?ID=$row[0]&mode=data&action=delete&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter&sort=$sort&direction=$direction$sid'><img src='$img_path/r.gif' alt='$delete_it' title='$delete_it' border=0 width=7></a>&nbsp;\n";
        // ... and personal button
        if (!$row[7]) { echo "<img src=$img_path/g.gif alt='$datei_text13' title='$datei_text13' width=7>&nbsp;\n"; }
      }
      // title and link to the full note
      echo "<td><b><a href='notes.php?ID=$row[0]&mode=view&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter&sort=$sort&direction=$direction$sid'>".html_out($row[1])."</a></b></td>\n";
      // dates
      /* forget this - we use ISO format now!

      $datum1 = substr($row[4],6,2).".".substr($row[4],4,2).".".substr($row[4],0,4)." ".substr($row[4],8,2).":".substr($row[4],10,2);
      $datum2 = substr($row[5],6,2).".".substr($row[5],4,2).".".substr($row[5],0,4)." ".substr($row[5],8,2).":".substr($row[5],10,2);
      */
      $datum1 = show_iso_date1($row[4]);
      $datum2 = show_iso_date1($row[5]);
      echo "<td width=95>$datum1&nbsp;</td><td width=95>$datum2&nbsp;</td>\n";
      // contact
      if ($adressen and !$contacts_nolink) {
        echo "<td>";
        if ( $row[3] > 0) {
          $result2 = db_query("select nachname from contacts where ID = '$row[3]'") or db_die();
          $row2 = db_fetch_row($result2);
          echo "$row2[0]";
        }
        else { $row2[0] = ""; }
        echo "&nbsp;</td>\n";
      }
      // project
      if ($projekte) {
        echo "<td>";
        if ($row[6] > 0) {
          $result3 = db_query("select name from projekte where ID = '$row[6]'") or db_die();
          $row3 = db_fetch_row($result3);
          echo "$row3[0]";
        }
        else { $row2[0] = ""; }
        echo "&nbsp;</td>\n";
      }
      echo "</tr>\n";
    }
    $b++;
  }

echo "</table><br>";
}

// form - appears whether the button new has been selected, a link from other modules asks to create a new record, an ID has been given or it should appear anyway :-)
if ($new_note or $contact_ID or $projekt_ID or $ID or $notes_view_both){
  // fetch data from record
  if ($ID) {
    // fetch values from db
    $result = db_query("select * from notes where ID = '$ID'") or db_die();
    $row = db_fetch_row($result);
    // only check whether the user is the owner if 
    // 1. notes is private or 
    // 2. in group system user is not in this group or
    // in groupless system the value ext is not set to 1
    if (!$row[5] or ($groups and $row[5] <> $user_group) or (!$groups and $row[5] <> 1)) {
      // check permission and if a record exist
      check_permission("notes","von",$ID);
    }
  }
  
  // check permission to modify this record
  if (check_role("notes") < 2) {
    $read_o = "disabled style='background-color:$bgcolor3;'";
  }

  // display input form
  $hidden = array_merge(array('ID'=>$ID,'mode'=>'data'), $view_param);
  if(SID) { $hidden['PHPSESSID'] = $PHPSESSID; }
  echo "<br><table border=0 bgcolor=$bgcolor2>\n";
  // title and link to help file
  echo "<tr><td><a href='$doc/notes.html' target=m><b>$o_notes</b></a></td>\n";
  echo "<tr><td><form action='notes.php' method='post' name=frm onSubmit=\"return chkForm('frm','title','$opt_bm4!')\">\n";
  hidden_fields($hidden);
  // title ...
  echo "<tr><td colspan=2>$forum_text5: <input type='text' name='title' size='70' value='".html_out($row[2])."' $read_o></td></tr>\n";
  // ... and remark
  echo "<tr><td><textarea rows=20 cols=70 name=remark wrap=physical $read_o>".html_out($row[3])."</textarea></td><td>\n";
  // little table just to align the input fields contacts, projects and 'open to all'
  echo "<table border=0>\n";
  // contact link
  if ($adressen and !$contacts_nolink) {
    if (!$contact_ID) { $contact_ID = $row[4]; }
    echo "<tr><td>$proj_text12:</td><td> <select name=contact $read_o>\n";
    echo "<option value=0>\n";
    $result2 = db_query("select ID, nachname, vorname from contacts where (von = '$user_ID' or acc like 'a') and $sql_user_group order by nachname") or db_die();
    while ($row2 = db_fetch_row($result2)) {
      echo "<option value='$row2[0]'";
      if ($contact_ID == $row2[0]) { echo " selected"; }
      echo ">$row2[1], $row2[2]\n";
    }
    echo "</select></td></tr>\n";
  }


  // project link
  if ($projekte) {
    if (!$projekt_ID) { $projekt_ID = $row[8]; }
    echo "<tr><td>$l_text11:</td><td> <select name=projekt $read_o><option value=0>\n";
    // prepare query for function
    $query = "where $sql_user_group";
    // call function to show all required elemts in a tree structure in the select box
    show_elements_of_tree("projekte","name",$query,"personen"," order by name",$projekt_ID,"parent",0);

    echo "</select></td></tr>\n";
  }
  // checkbox for general note
  // show only if you are the author
  if ($row[1] == $user_ID or !$ID) {
 
    // in the group system the value for this field is be the group ID
    if ($groups == "1") { $ext_value = $user_group; }    
    // but the groupless system the group doesn't have any number, so define the value of this field simply as '1'
    else { $ext_value = "1"; } 
    // if the 'external filed' in the db has a value, mark this box as checked.    
    if ($row[5] > 0) { $checked = "checked"; }
    echo "<tr><td>$con_text11:</td><td> <input type='checkbox' name='ext' value='$ext_value' $read_o$checked>&nbsp;</td></tr>\n";
  }
  // otherwise as hidden field so the other user shouldn't change this flag
  else { echo "<input type='hidden' name='ext' value='$row[5]'>\n"; }

  // actions submit form, copy, print etc. only possible if this user has write access for notes in his role
  if (check_role("notes") > 1) {
    echo"<tr><td colspan=2><input type=image src='$img_path/los.gif' border='0' id='tr'><br></td></tr>";
    // several actions: copy, mail or print
    if ($ID) {
      // copy or mail - only if the note is to privae, otherwise it wouldn't make sense
      if (!$row[5]) {
        echo "<tr><td colspan=2>\n";
        if(SID) echo "<input type='hidden' name='PHPSESSID' value='$PHPSESSID'>\n";
        echo "<input type='hidden' name='ID' value='$ID'>\n";
        echo "<br><select name='pers_ID'>\n";
        if ($user_group) {$result3 = db_query("select user_ID from grup_user where grup_ID = $user_group and user_ID <> $user_ID") or db_die();}
        else {$result3 = db_query("select ID from users where ID <> '$user_ID'") or db_die();}
        while ($row3 = db_fetch_row($result3)) {
          $result2 = db_query("select ID, nachname, vorname from users where ID = '$row3[0]' order by nachname") or db_die();
          $row2 = db_fetch_row($result2);
          echo "<option value=$row2[0]>$row2[1], $row2[2]\n";
        }
        echo "</select>";
        // copy button
        echo "&nbsp;&nbsp;<input type='submit' name='copy' value='$copy_it' border='0' onClick=\"return confirm('$confirm')\"> &nbsp; ";
        // mail button
        echo "<input type=submit name=mail value=$mail_text9 border=0 onClick=\"return confirm('$confirm')\"></td></tr></form>\n";
      } // end check owner of record
    } // end  check for role 
    // print
    echo "<tr><td colspan=2><a href='../misc/print.php?ID=$ID&module=notes$sid' target=_blank>$print</a></td></tr>\n";
  }
  echo "<tr><td colspan=2><a href='notes.php?mode=view&sort=$sort&up=$up&page=$page&perpage=$perpage&keyword=$keyword&filter=$filter$sid'>$back</a></td></tr>\n";
  echo "</table></td></tr></table>\n";
}
?>
