<?php

// setup.php - PHProjekt Version 4.0
// copyright  2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

session_start();

// set some variables
$PHPSESSID = session_id();
error_reporting(0);
$ini_var = ini_set('include_path','./');
// bypass lib authentication (will use it's own) ...
define ("avoid_auth","1");

// include routine for session_register
include_once("lib/gpcs_vars.inc.php");

// check some possible exploits
if (strlen($langua) > 2) { die("You are not allowed to do this!"); }
if (strlen($step) > 2) { die("You are not allowed to do this!"); }

// *** first check some limits and possible errors
// still PHP3? -> udpate!
if (substr(phpversion(),0,1) == "3") die ("<b>sorry, PHP 4 required!</b><br><br> Please download the current version at <a href='http://www.php.net'>www.php.net</a>\n");

// session test: test for real path to files or db option
if (!is_dir(session_save_path()) and !preg_match("/^[a-zA-Z0-9]*\.[a-zA-Z0-9]*$/",session_save_path())) echo"<b>There is no path to store the sessions given in the php.ini. Please run the session test in the tst script env_test.php to check whether sessions work in your environment. If this is not the case then you should define a temp path in the variable session.save_path which has write permissions for the webserver.<br><br>";

//check whether language files exist in their directory
if (!file_exists("lang/de.inc.php") and !file_exists("lang/en.inc.php"))
  die("Oops! Can't include or find the language files in the directory 'lang'!
       Thee folder structure must be kept while unzipping and the path to the language dir
       (as well to the /lib and other directories) must be in the include_path variable in the php.ini\n");

// config exists? then check authentification
if ((file_exists("./config.inc.php") and filesize("config.inc.php") > 0) or (file_exists("../../config.inc.php") and filesize("../../config.inc.php") > 0)) {
  if (!$ok) {
    if ($admin_pw) {
      include_once("lib/lib.inc.php");
      $result = db_query("select pw, acc from users where nachname='$nachname'");
      while ($row = db_fetch_row($result)) {
        // crypting password
        if ($pw_crypt) {
          include_once("lib/crypt.inc.php");
          $enc_pw = encrypt($admin_pw, $row[0]);
        }
        else $enc_pw = $admin_pw;

        // check authentification
        if (ereg("a",$row[1]) and $enc_pw == $row[0]) {
          $ok = 1;  // admin password valid
          reg_sess_vars(array("ok"));
        }
        else {  // not an admin password
          // destroy the session - on some system the first, on some system the second function doesn't work :-))
          @session_unset();
          @session_destroy();
          die("This is not an admin login combination!");
        }
      }
    }
    // no admin_pw given? -> show him the form
    else {
      session_unset();
      echo "<form action=setup.php method=post><br>Config.inc.php found!<br> Please enter:<br>\n";
      echo "<table><tr><td>admin <b>last name</b>:</td><td><input type=text name=nachname></td></tr>\n";
      echo "<tr><td>admin password:</td><td><input type=password name=admin_pw></td></tr>\n";
      echo "<tr><td>&nbsp;</td><td>(e.g. root/root)</td></tr></table>\n";
      echo "<input type=submit value=submit></form>\n";
      exit;
    }
  }

  // last thing for extisting config: writeable?
  if (!is_writable("config.inc.php") and !is_writable("../../config.inc.php")) { die("<br><b>PANIC! config.inc.php can't be written! Please ensure that the webserver is able to write a new config"); }

}
// end check authentification
// else -> config not ex. -> test write for config. If it fails, show message
else {
  if (!$step) {
    $alert = "Alert: Cannot create file 'config.inc.php'!<br>
              The webserver needs the permission to write the file config.inc.php in the PHProjekt root directory.";
    $fp = @fopen("config.inc.php",'wb+');
    // impossible to write the test file? -> error message
    if (!$fp) { die("$alert"); }
    else {
      fclose($fp);
      unlink("config.inc.php");
      reg_sess_vars(array("ok"));
    }
  }
}
// next check for config file: if update or config, look whether the file is writeable
if ($setup <> "install") {
  if ((file_exists("./config.inc.php") and !is_writeable("config.inc.php")) or (file_exists("../../config.inc.php") and !is_writeable("../../config.inc.php"))) { die ("Pleae remove the write protection"); }
}


// **********
// write header of html output

// set charset
if     (eregi('pl|cz|hu|si',$langua)) { $lcfg="charset=iso-8859-2"; }
elseif ($langua=="sk") {$lcfg  = "charset=windows-1250"; }
elseif ($langua=="ru") { $lcfg = "charset=windows-1251"; }
elseif ($langua=="tw") { $lcfg = "charset=big5"; }
elseif ($langua=="zh") { $lcfg = "charset=gb2312"; }
if ($lcfg <> "") { $lang_cfg = "<meta http-equiv='Content-Type' content='text/html; $lcfg'>"; }

// Determine OS for style sheet
if (eregi("mac", $HTTP_USER_AGENT)) $css_style = "mac.css";
elseif (eregi("4.7", $HTTP_USER_AGENT)) $css_style = "nn4.css";
elseif (eregi("win", $HTTP_USER_AGENT)) $css_style = "win.css";
else { $css_style = "common.css"; }
echo "<html><head><title>PHProjekt SETUP</title>";
echo "<link rel=stylesheet type='text/css' href='layout/default/css/$css_style'>$lang_cfg</head>\n";
echo "<body bgcolor='#B8B8B8'><center>\n";

// only Configuration? -> send him to the big form
if ($step == "1" and $setup <> "install") { $step = "2a"; }

// ... but make sure the files stepx.php will not accessed directly
// check whether the lib has been included - authentication!
define ("setup_included","1");

//begin steps
include("setup/step".$step.".php");


?>
</center></body></html>