<?php

// step3.php - PHProjekt Version 4.0
// copyright  2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether setup.php calls this script - authentication!
if (!defined("setup_included")) { die("Please use index.php!"); }

  // save default language to avoid new setting in the lib
  $langua2 = $langua;

  // set contstant avoid_auth in order to bypass authentication in lib
  define ("avoid_auth","1");

  // include lib
  include ("lib/lib.inc.php");
  // fetch db definitions
  include ("setup/db_var.inc.php");
  // restore language and load appropiate language file
  $langua = $langua2;
  include_once("lang/$langua.inc.php");


// updates
include_once ("setup/updates.php");


  // crypt passwords
  if ($pw_crypt_update) {
     echo "$inst_text77 ...<br>";
     $result = db_query("select ID, pw, nachname from users") or db_die();
     while ($row = db_fetch_row($result)) {
       include_once("lib/crypt.inc.php");
       $enc_pw = encrypt($row[1],$row[1]);
       $result2 = db_query("update users set pw = '$enc_pw' where ID = '$row[0]'") or db_die();
     }
     $pw_crypt = "1";
     echo "$admin_text46!<br><br>";
  }

  // crypt filenames
  if ($dat_crypt_update) {
     echo "$inst_text77b ...<br>";
     // set random name
     srand ((double)microtime()*1000000);
     // loop over all files in the upload directory
     $result = db_query("select ID, filename from dateien") or db_die();
     while ($row = db_fetch_row($result)) {
       // exclude directories
       if (is_file("$dat_rel/$row[1]")) {
         $rnd = "";
         $char = "0123456789ABCDEFGHIJKLMANOPQRSTUVWXYZ";
         while (strlen($rnd) < 9) { $rnd .= substr($char,(rand()%(strlen($char))),1);}
         $result2 = db_query("update dateien set tempname = '$rnd' where ID = '$row[0]'") or db_die();
         // because renaming is difficult on various OS, use copy and unlink
         copy("$dat_rel/$row[1]","$dat_rel/$rnd");
         unlink("$dat_rel/$row[1]");
       }
     }
     $dat_crypt = "1";
     echo "$admin_text46!<br><br>";
  }

// ******************************
  // Begin table setup ************
  // Filemanagement    ************

  if ($dateien and ($setup == "install" or !$dateien_old)) {
    $result = db_query("
      CREATE TABLE dateien (
        ID $db_int8_auto[$db_type],
        von $db_int8[$db_type],
        filename $db_varchar255[$db_type],
        remark $db_varchar255[$db_type],
        kat $db_varchar40[$db_type],
        acc $db_text[$db_type],
        datum $db_varchar20[$db_type],
        filesize $db_int11[$db_type],
        gruppe $db_int4[$db_type],
        tempname $db_varchar255[$db_type],
        typ $db_varchar40[$db_type],
        div1 $db_varchar40[$db_type],
        div2 $db_varchar40[$db_type],
        pw $db_varchar255[$db_type],
        acc_write $db_text[$db_type],
        version $db_int4[$db_type],
        lock_user $db_varchar10[$db_type],
        contact $db_int6[$db_type],
        PRIMARY KEY (ID)
      ) ");
    if ($result) { echo "$inst_text41.<br>\n"; }
    else { echo "$inst_text4a 'dateien'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("dateien"); }
    if ($db_type == "interbase") {ib_autoinc("dateien"); }
  }

  //**************************************

  // Gruppenansichten - profiles
  if ($profile and ($setup == "install" or !$profile_old)) {
    $result = db_query("
      CREATE TABLE profile (
        ID $db_int8_auto[$db_type],
        von $db_int8[$db_type],
        bezeichnung $db_varchar10[$db_type],
        personen $db_text[$db_type],
        PRIMARY KEY (ID)
      ) ");
    if ($result) { echo "$inst_text45.<br>\n"; }
    else { echo "$inst_text4a 'profile' <br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("profile"); }
    if ($db_type == "interbase") {ib_autoinc("profile"); }
  }

//**************************************

  // Todo lists
  if ($todo and ($setup == "install" or !$todo_old)) {
    $result = db_query("
      CREATE TABLE todo (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      remark $db_varchar60[$db_type],
      ext $db_int8[$db_type],
      div1 $db_text[$db_type],
      div2 $db_varchar40[$db_type],
      note $db_text[$db_type],
      deadline $db_varchar20[$db_type],
      datum $db_varchar20[$db_type],
      status $db_int1[$db_type],
      priority $db_int1[$db_type],
      progress $db_int3[$db_type],
      project $db_int6[$db_type],
      contact $db_int8[$db_type],
      sync1 $db_varchar20[$db_type],
      sync2 $db_varchar20[$db_type], 
      comment1 $db_text[$db_type],
      comment2 $db_text[$db_type],                 
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text47.<br>\n"; }
    else { echo "$inst_text4a 'todo'<br>\n"; $error = 1;  }
    if ($db_type == "oracle") { sequence("todo"); }
    if ($db_type == "interbase") {ib_autoinc("todo"); }
  }

//**************************************

  //  Forum
  if ($forum and ($setup == "install" or !$forum_old)) {
    $result = db_query("
      CREATE TABLE forum (
      ID $db_int8_auto[$db_type],
      antwort $db_int8[$db_type],
      von $db_int8[$db_type],
      titel $db_varchar80[$db_type],
      remark $db_text[$db_type],
      kat $db_varchar20[$db_type],
      datum $db_varchar20[$db_type],
      gruppe $db_int4[$db_type],
      lastchange $db_varchar20[$db_type],
      notify $db_varchar2[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text49.<br>\n"; }
    else { echo "$inst_text4a 'forum'<br>\n"; $error = 1; }
    // create own index for antworten
    $result = db_query("CREATE INDEX forum_antwort ON forum (antwort)");

    if ($db_type == "oracle") { sequence("forum"); }
    if ($db_type == "interbase") {ib_autoinc("forum"); }
  }

//******************************************

  // polls/votum/Umfragen
  if ($votum and ($setup == "install" or !$votum_old)) {
    $result = db_query("
      CREATE TABLE votum (
      ID $db_int8_auto[$db_type],
      datum $db_varchar20[$db_type],
      von $db_int8[$db_type],
      thema $db_varchar255[$db_type],
      modus $db_char1[$db_type],
      an $db_text[$db_type],
      fertig $db_text[$db_type],
      text1 $db_varchar60[$db_type],
      text2 $db_varchar60[$db_type],
      text3 $db_varchar60[$db_type],
      zahl1 $db_int4[$db_type],
      zahl2 $db_int4[$db_type],
      zahl3 $db_int4[$db_type],
      kein $db_int4[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text51.<br>\n"; }
    else { echo "$inst_text4a 'votum'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("votum"); }
    if ($db_type == "interbase") {ib_autoinc("votum"); }
  }

//*******************************************

  // Lesezeichen - bookmarks
  if ($lesezeichen and ($setup == "install" or !$lesezeichen_old)) {
    $result = db_query("
      CREATE TABLE lesezeichen (
      ID $db_int8_auto[$db_type],
      datum $db_varchar20[$db_type],
      von $db_int8[$db_type],
      url $db_varchar255[$db_type],
      bezeichnung $db_varchar40[$db_type],
      bemerkung $db_varchar255[$db_type],
      gruppe $db_int4[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text53.<br>\n"; }
    else { echo "$inst_text4a 'lesezeichen'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("lesezeichen"); }
    if ($db_type == "interbase") {ib_autoinc("lesezeichen"); }
  }

//********************************************

  // Ressourcen - resources
  if ($ressourcen and ($setup == "install" or !$ressourcen_old)) {
    $result = db_query("
      CREATE TABLE ressourcen (
      ID $db_int8_auto[$db_type],
      name $db_varchar20[$db_type],
      bemerkung $db_varchar255[$db_type],
      kategorie $db_varchar20[$db_type],
      typ $db_varchar40[$db_type],
      div1 $db_varchar40[$db_type],
      div2 $db_varchar40[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'ressourcen'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("ressourcen"); }
    if ($db_type == "interbase") {ib_autoinc("ressourcen"); }

    $result = db_query("
      CREATE TABLE termine_res_rel (
      ID $db_int8_auto[$db_type],
      termin_ID $db_int8[$db_type],
      res_ID $db_int8[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text55.<br>\n"; }
    else { echo "$inst_text4a 'termine_res_rel'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("termine_res_rel"); }
    if ($db_type == "interbase") {ib_autoinc("termine_res_rel"); }
  }

//********************************************

   // Projekte - projects
  if ($projekte and ($setup == "install" or !$projekte_old)) {
    $result = db_query("
      CREATE TABLE projekte (
      ID $db_int8_auto[$db_type],
      name $db_varchar20[$db_type],
      ende $db_varchar10[$db_type],
      personen $db_text[$db_type],
      wichtung $db_varchar20[$db_type],
      status $db_int3[$db_type],
      statuseintrag $db_varchar10[$db_type],
      anfang $db_varchar10[$db_type],
      gruppe $db_int4[$db_type],
      chef $db_varchar20[$db_type],
      typ $db_varchar40[$db_type],
      parent $db_int6[$db_type],
      ziel $db_varchar255[$db_type],
      note $db_text[$db_type],
      kategorie $db_varchar40[$db_type],
      contact $db_int8[$db_type],
      stundensatz $db_int8[$db_type],
      budget $db_int11[$db_type],
      div1 $db_varchar40[$db_type],
      div2 $db_varchar40[$db_type],
      depend_mode $db_int2[$db_type], 
      depend_proj $db_int6[$db_type],  
      next_mode $db_int2[$db_type], 
      next_proj $db_int6[$db_type],    
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57.<br>\n"; }
    else { echo "$inst_text4a 'projekte'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("projekte"); }
    if ($db_type == "interbase") {ib_autoinc("projekte"); }
  }

  // book work time on projects
  if ($projekte > 1 and ($setup == "install" or $projekte_old < 2)) {
    $result = db_query("
      CREATE TABLE timeproj (
      ID $db_int8_auto[$db_type],
      users $db_int4[$db_type],
      projekt $db_int4[$db_type],
      datum $db_varchar10[$db_type],
      h $db_int2[$db_type],
      m $db_int2[$db_type],
      kat $db_varchar255[$db_type],
      note $db_varchar40[$db_type],
      ext $db_int2[$db_type],
      div1 $db_varchar40[$db_type],
      div2 $db_varchar40[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57e.<br>\n"; }
    else { echo "$inst_text4a 'timeproj'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("timeproj"); }
    if ($db_type == "interbase") {ib_autoinc("timeproj"); }
  }

//********************************************

   // Kontakte - contacts
   if ($adressen and ($setup == "install" or !$adressen_old)) {
    $result = db_query("
      CREATE TABLE contacts (
      ID $db_int8_auto[$db_type],
      vorname $db_varchar20[$db_type],
      nachname $db_varchar40[$db_type],
      gruppe $db_int4[$db_type],
      firma $db_varchar60[$db_type],
      email $db_varchar80[$db_type],
      tel1 $db_varchar60[$db_type],
      tel2 $db_varchar60[$db_type],
      fax $db_varchar60[$db_type],
      strasse $db_varchar60[$db_type],
      stadt $db_varchar60[$db_type],
      plz $db_varchar10[$db_type],
      land $db_varchar40[$db_type],
      kategorie $db_varchar40[$db_type],
      bemerkung $db_text[$db_type],
      von $db_int8[$db_type],
      acc $db_varchar4[$db_type],
      email2 $db_varchar80[$db_type],
      mobil $db_varchar60[$db_type],
      url $db_varchar80[$db_type],
      div1 $db_varchar60[$db_type],
      div2 $db_varchar60[$db_type],
      anrede $db_varchar20[$db_type],
      state $db_varchar40[$db_type],
      import $db_char1[$db_type],
      parent $db_int8[$db_type], 
      sync1 $db_varchar20[$db_type],
      sync2 $db_varchar20[$db_type],           
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57a.<br>\n"; }
    else { echo "$inst_text4a 'contacts'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("contacts"); }
    if ($db_type == "interbase") {ib_autoinc("contacts"); }
  }

//********************************************

   // Notizen - notes
  if ($notes and ($setup == "install" or !$notes_old)) {
    $result = db_query("
      CREATE TABLE notes (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      name $db_varchar255[$db_type],
      remark $db_text[$db_type],
      contact $db_int4[$db_type],
      ext $db_int4[$db_type],
      div1 $db_varchar40[$db_type],
      div2 $db_varchar40[$db_type],
      projekt $db_int6[$db_type],
      sync1 $db_varchar20[$db_type],
      sync2 $db_varchar20[$db_type],       
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57b.<br>\n"; }
    else { echo "$inst_text4a 'notes'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("notes"); }
    if ($db_type == "interbase") {ib_autoinc("notes"); }
  }

//********************************************

   // Zeitkarte - timecard
  if ($timecard and ($setup == "install" or !$timecard_old)) {
    $result = db_query("
      CREATE TABLE timecard (
      ID $db_int8_auto[$db_type],
      users $db_int8[$db_type],
      datum $db_varchar10[$db_type],
      projekt $db_int8[$db_type],
      anfang $db_int4[$db_type],
      ende $db_int4[$db_type],
      out_begin $db_int4[$db_type],
      out_end $db_int4[$db_type],
      out_begin2 $db_int4[$db_type],
      out_end2 $db_int4[$db_type],
      note $db_varchar40[$db_type],
      div1 $db_varchar40[$db_type],
      div2 $db_varchar40[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57c.<br>\n"; }
    else { echo "$inst_text4a 'timecard'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("timecard"); }
    if ($db_type == "interbase") {ib_autoinc("timecard"); }
  }

//********************************************

   // Gruppen - groups
  if ($groups and ($setup == "install" or !$groups_old)) {
    $result = db_query("
      CREATE TABLE gruppen (
      ID $db_int8_auto[$db_type],
      name $db_varchar255[$db_type],
      kurz $db_varchar10[$db_type],
      kategorie $db_varchar255[$db_type],
      bemerkung $db_varchar255[$db_type],
      chef $db_int6[$db_type],
      div1 $db_varchar255[$db_type],
      div2 $db_varchar255[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!result) { echo "$inst_text4a 'groups'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("gruppen"); }
    if ($db_type == "interbase") {ib_autoinc("gruppen"); }

    // additional groups
    $result = db_query("
      CREATE TABLE grup_user (
      ID $db_int8_auto[$db_type],
      grup_ID $db_int8[$db_type],
      user_ID $db_int8[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57d.<br>\n"; }
    else { echo "$inst_text4a 'grup_user'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("grup_user"); }
    if ($db_type == "interbase") {ib_autoinc("grup_user"); }
  }

//********************************************

   // helpdesk
  if ($rts and ($setup == "install" or !$rts_old)) {
    $result = db_query("
      CREATE TABLE rts (
      ID $db_int8_auto[$db_type],
      contact $db_int4[$db_type],
      email $db_varchar80[$db_type],
      submit $db_varchar20[$db_type],
      recorded $db_int6[$db_type],
      name $db_varchar255[$db_type],
      note $db_text[$db_type],
      due_date $db_varchar20[$db_type],
      status $db_varchar20[$db_type],
      assigned $db_varchar20[$db_type],
      priority $db_int1[$db_type],
      remark $db_text[$db_type],
      solution $db_text[$db_type],
      solved $db_int4[$db_type],
      solve_time $db_varchar20[$db_type],
      acc $db_int1[$db_type],
      div1 $db_varchar255[$db_type],
      div2 $db_varchar255[$db_type],
      proj $db_int6[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'rts'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("rts"); }
    if ($db_type == "interbase") {ib_autoinc("rts"); }

    //helpdesk_cat
    $result = db_query("
      CREATE TABLE rts_cat (
      ID $db_int8_auto[$db_type],
      name $db_varchar60[$db_type],
      users $db_varchar10[$db_type],
      gruppe $db_varchar10[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57f.<br>\n"; }
    else { echo "$inst_text4a 'rts_cat'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("rts_cat"); }
    if ($db_type == "interbase") {ib_autoinc("rts_cat"); }
  }

//********************************************

  // mail reader
  if ($quickmail == 2 and ($setup == "install" or $quickmail_old < 2)) {

    // mail account
    $result = db_query("
      CREATE TABLE mail_account (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      accountname $db_varchar40[$db_type],
      hostname $db_varchar80[$db_type],
      type $db_varchar10[$db_type],
      username $db_varchar60[$db_type],
      password $db_varchar60[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'mail_account'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("mail_account"); }
    if ($db_type == "interbase") {ib_autoinc("mail_account"); }

    // mail attachments
    $result = db_query("
      CREATE TABLE mail_attach (
      ID $db_int8_auto[$db_type],
      parent $db_int8[$db_type],
      filename $db_varchar255[$db_type],
      tempname $db_varchar255[$db_type],
      filesize $db_int11[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'mail_attach'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("mail_attach"); }
    if ($db_type == "interbase") {ib_autoinc("mail_attach"); }
    // create own index for field parent (reference to field ID of table mail_client
    // -> the mail ID
    $result = db_query("CREATE INDEX mail_attach_parent ON mail_attach (parent)");

    // mail sender/signature
    $result = db_query("
      CREATE TABLE mail_sender (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      title $db_varchar80[$db_type],
      sender $db_varchar255[$db_type],
      signature $db_text[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'mail_sender'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("mail_sender"); }
    if ($db_type == "interbase") {ib_autoinc("mail_sender"); }

    // mail client
    $result = db_query("
      CREATE TABLE mail_client (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      subject $db_varchar255[$db_type],
      body $db_text[$db_type],
      sender $db_varchar128[$db_type],
      recipient $db_text[$db_type],
      cc $db_text[$db_type],
      kat $db_varchar40[$db_type],
      remark $db_text[$db_type],
      date_received $db_varchar20[$db_type],
      touched $db_int1[$db_type],
      typ $db_char1[$db_type],
      parent $db_varchar40[$db_type],
      date_sent $db_varchar20[$db_type],
      header $db_text[$db_type],
      replyto $db_varchar128[$db_type],
      acc $db_text[$db_type],
      body_html $db_text[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'mail_client'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("mail_client"); }
    if ($db_type == "interbase") {ib_autoinc("mail_client"); }
    // create own index for field 'von' (fererence to field ID, table users
    $result = db_query("CREATE INDEX mail_client_von ON mail_client (von)");

    // mail rules
    $result = db_query("
      CREATE TABLE mail_rules (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      title $db_varchar80[$db_type],
      phrase $db_varchar60[$db_type],
      type $db_varchar60[$db_type],
      is_not $db_varchar3[$db_type],
      parent $db_int8[$db_type],
      action $db_varchar10[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57g.<br>\n"; }
    if (!$result) { echo "$inst_text4a 'mail_rules'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("mail_rules"); }
    if ($db_type == "interbase") {ib_autoinc("mail_rules"); }
  }

//********************************************

   // Logging
  if ($logs and ($setup == "install" or !$logs_old)) {
    $result = db_query("
      CREATE TABLE logs (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      login $db_varchar20[$db_type],
      logout $db_varchar20[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57h.<br>\n"; }
    else { echo "$inst_text4a 'logs'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("logs"); }
    if ($db_type == "interbase") {ib_autoinc("logs"); }
  }

//*******************************************

   // Contact profiles
  if ($contacts_profiles and ($setup == "install" or !$contacts_profiles_old)) {
    $result = db_query("
      CREATE TABLE contacts_profiles (
      ID $db_int8_auto[$db_type],
      von $db_int8[$db_type],
      name $db_varchar128[$db_type],
      remark $db_text[$db_type],
      kategorie $db_varchar20[$db_type],
      acc $db_varchar4[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if (!$result) { echo "$inst_text4a 'contacts_profiles'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("contacts_profiles"); }
    if ($db_type == "interbase") {ib_autoinc("contacts_profiles"); }

    $result = db_query("
      CREATE TABLE contacts_prof_rel (
      ID $db_int8_auto[$db_type],
      contact_ID $db_int8[$db_type],
      contacts_profiles_ID $db_int8[$db_type],
      PRIMARY KEY (ID)
    ) ");
    if ($result) { echo "$inst_text57i.<br>\n"; }
    else { echo "$inst_text4a 'contacts_prof_rel'<br>\n"; $error = 1; }
    if ($db_type == "oracle") { sequence("contacts_prof_rel"); }
    if ($db_type == "interbase") {ib_autoinc("contacts_prof_rel"); }
  }

//********************************************
// end of the step 'creating tables' according to the settings in the config.inc.php
// the next four tables users, termine, roles & setings will be created in all cases
// *******************************************

if ($setup == "install") {
  $result = db_query("
    CREATE TABLE users (
    ID $db_int8_auto[$db_type],
    vorname $db_varchar40[$db_type],
    nachname $db_varchar40[$db_type],
    kurz $db_varchar10[$db_type],
    pw $db_varchar40[$db_type],
    firma $db_varchar40[$db_type],
    gruppe $db_int4[$db_type],
    email $db_varchar60[$db_type],
    acc $db_varchar4[$db_type],
    tel1 $db_varchar40[$db_type],
    tel2 $db_varchar40[$db_type],
    fax $db_varchar40[$db_type],
    strasse $db_varchar40[$db_type],
    stadt $db_varchar40[$db_type],
    plz $db_varchar10[$db_type],
    land $db_varchar40[$db_type],
    sprache $db_varchar2[$db_type],
    mobil $db_varchar40[$db_type],
    loginname $db_varchar40[$db_type],
    ldap_name $db_varchar40[$db_type],
    anrede $db_varchar10[$db_type],
    sms $db_varchar60[$db_type],
    role $db_int4[$db_type],
    proxy $db_text[$db_type],      
    settings $db_text[$db_type],  
    PRIMARY KEY (ID)
  ) ");
  if ($result) { echo "$inst_text63.<br>\n"; }
  else { echo "$inst_text4a 'users'<br>"; $error = 1; }
  if ($db_type == "oracle") { sequence("users"); }
  if ($db_type == "interbase") {ib_autoinc("users"); }

  //********************************************

  $result = db_query("
    CREATE TABLE termine (
    ID $db_int8_auto[$db_type] ,
    von $db_int8[$db_type],
    an $db_int8[$db_type],
    event $db_varchar128[$db_type],
    note $db_varchar128[$db_type],
    projekt $db_int8[$db_type],
    erstellt $db_varchar20[$db_type],
    datum $db_varchar10[$db_type],
    anfang $db_varchar4[$db_type],
    ende $db_varchar4[$db_type],
    ressource $db_int8[$db_type],
    ort $db_varchar40[$db_type],
    contact $db_int8[$db_type],
    note2 $db_text[$db_type],
    div1 $db_varchar40[$db_type],
    div2 $db_varchar40[$db_type],
    remind $db_int4[$db_type],
    visi $db_char1[$db_type],
    sync1 $db_varchar20[$db_type],
    sync2 $db_varchar20[$db_type],    
    PRIMARY KEY (ID)
  ) ");
  if ($result) { echo "$inst_text64.<br>\n"; }
  else { echo "$inst_text4a 'termine'<br>\n"; $error = 1; }
  if ($db_type == "oracle") { sequence("termine"); }
  if ($db_type == "interbase") {ib_autoinc("termine"); }

  // Roles
  $result = db_query("
    CREATE TABLE roles (
    ID $db_int8_auto[$db_type],
    von $db_int6[$db_type],
    title $db_varchar60[$db_type],
    remark $db_text[$db_type],
    summary $db_int1[$db_type],    
    calendar $db_int1[$db_type],
    contacts $db_int1[$db_type],
    forum $db_int1[$db_type],
    chat $db_int1[$db_type],
    filemanager $db_int1[$db_type],  
    bookmarks $db_int1[$db_type], 
    votum $db_int1[$db_type], 
    mail $db_int1[$db_type], 
    notes $db_int1[$db_type], 
    helpdesk $db_int1[$db_type], 
    projects $db_int1[$db_type],  
    timecard $db_int1[$db_type],
    todo $db_int1[$db_type], 
    news $db_int1[$db_type],                                                        
    PRIMARY KEY (ID)
  ) ");  
  if ($db_type == "oracle") { sequence("roles"); }
  if ($db_type == "interbase") {ib_autoinc("roles"); }


    
    // settings   
    
  //*********************************************
  // Example user and group data ****************

  // crypt example user data?
  if ($pw_crypt) {
    include_once("lib/crypt.inc.php");
    $pw_root = encrypt($rootpass, $rootpass);
    $pw_test = encrypt("test", "test");
  }
  else {
    $pw_root = $rootpass;
    $pw_test = "test";
  }
  // short names
  $l_root = "root1";
  $l_test = "test1";
  // if groups -> create group default
  if ($groups) {
    $result = db_query("
      INSERT INTO gruppen VALUES ($dbIDnull,'default','def','default','','1',null,null)
    ") or db_die();
    if (!$result) $error = 1;
    $result = db_query("
      INSERT INTO grup_user VALUES ($dbIDnull,'1','2')
    ") or db_die();
    if (!$result) $error = 1;
    echo " $inst_text65b.<br>";
    $gr_var = "1";   // Flag for next insert: user test is assigned to group default
  }
  // create user root and test
  $result = db_query("INSERT INTO users (ID,vorname,nachname,kurz,pw,acc,sprache,loginname) VALUES ($dbIDnull,'root','root','$l_root','$pw_root','an','$langua','root')") or db_die();
  if (!$result) $error = 1;
  $result = db_query("INSERT INTO users (ID,vorname,nachname,kurz,pw,gruppe,acc,sprache,loginname) VALUES ($dbIDnull,'test','test','$l_test','$pw_test','$gr_var','cy','$langua','test')") or db_die();
  if (!$result) $error = 1;

  echo "<br> $inst_text65.<br><br>";

  // tell the login parameters - login via short name and normal condition
  if ($login_kurz == 0) { echo "<b>LOGIN: root/$rootpass - test/test</b><br>"; }
  elseif ($login_kurz == 1) { echo "<b>LOGIN: $l_root/$rootpass - $l_test/test</b><br>"; }
  elseif ($login_kurz == 2) { echo "<b>LOGIN: root/$rootpass - test/test</b><br>"; }

  //*********************************************

}
// Ende Klammer install  - end of install brace
// ************************************************
// compose string to be written into the config file.
$datei = "<?php
\$version = \"4.0\";

// database
\$db_type = \"$db_type\";  // $inst_text28a
\$db_host = \"$db_host\";  // $inst_text28
\$db_user = \"$db_user\";  // $inst_text29
\$db_pass = \"$db_pass\";  //  $inst_text30
\$db_name = \"$db_name\";  //  $inst_text31

// system
\$login = \"$login\";              // 1: $inst_text26i login.php, 0: $inst_text26i index.php
\$login_kurz = \"$login_kurz\";    // $inst_text26x - $inst_text26y
\$pw_change = \"$pw_change\";      // $inst_text26d
\$pw_crypt = \"$pw_crypt\";        // $inst_text26h
\$groups = \"$groups\";            // $inst_text26m
\$ldap = \"$ldap\";  //  $inst_text90
\$timezone = \"$timezone\";  //  $inst_text93
\$session_time_limit = \"$session_time_limit\";
\$maxhits = \"$maxhits\";          // $inst_text94
\$logs = \"$logs\";                // $admin_text94
\$pdf_support = \"$pdf_support\";
\$error_reporting_level = \"0\";

// modules
\$todo = \"$todo\";       // $inst_text48
\$votum = \"$votum\";     // $inst_text52
\$lesezeichen = \"$lesezeichen\";  // $inst_text54

// calendar
\$calendar = \"$calendar\";
\$events_par = \"$events_par\";    // $inst_text92
\$groupviewuserheader = \"$groupviewuserheader\";        // $inst_text86
\$mail_new_event = \"$mail_new_event\";    // $inst_text80
\$tagesanfang = \"$tagesanfang\";  // $inst_text39: 6,7,8,9
\$tagesende = \"$tagesende\"; // $inst_text40: 17,18,19,21
\$profile = \"$profile\"; // $inst_text46
\$ressourcen = \"$ressourcen\";    // $inst_text56

// reminder
\$reminder = \"$reminder\";        // $inst_text73a, $inst_text73b: = 2
\$remind_freq = \"$remind_freq\";  // $inst_text73
\$sms_remind_service = \"$sms_remind_service\";  // $inst_text22f

// projects
\$projekte = \"$projekte\";        // $inst_text58, $inst_text59: = 2

// timecard
\$timecard = \"$timecard\";        // $o_timecard, $inst_text75: = 2

// contacts
\$adressen = \"$adressen\";        // $inst_text60
\$contacts_nolink = \"$contacts_nolink\"; // $inst_text95
\$cont_usrdef1 = \"$cont_usrdef1\";  // $inst_text19a 1
\$cont_usrdef2 = \"$cont_usrdef2\";  // $inst_text19a 2
\$contacts_profiles = \"$contacts_profiles\"; // $inst_text19c

// notes
\$notes = \"$notes\";              // $o_notes

// mail
\$quickmail = \"$quickmail\";      // $inst_text61
\$faxpath = \"$faxpath\";          // $inst_text81
\$mail_send_arg = \"$mail_send_arg\";  

// file manager
\$dateien = \"$dateien\"; //  $inst_text42,  $inst_text43
\$dat_rel = \"$dat_rel\"; // $inst_text44
\$dat_crypt = \"$dat_crypt\"; // $inst_text26v
\$filemanager_notify = \"$filemanager_notify\";
\$filemanager_versioning = \"$filemanager_versioning\";

// forum
\$forum = \"$forum\";     // $inst_text50
\$forum_tree_open = \"$forum_tree_open\"; // $inst_text88;
\$forum_notify = \"$forum_notify\"; //

// helpdesk - rts
\$rts = \"$rts\";                  // $inst_text26n
\$rts_mail = \"$rts_mail\";        // $inst_text26u
\$rts_duedate = \"$rts_duedate\";  //1: $inst_text26p
\$rts_chef = \"$rts_chef\";        // $inst_text26s: $inst_text26t
\$rts_cust_acc = \"$rts_cust_acc\";//1: $inst_text26q, $inst_text26r

// Chat
\$chat = \"$chat\";                // $inst_text62
\$alivefile = \"$alivefile\";
\$chatfile = \"$chatfile\";
\$chatfreq = \"$chatfreq\";
\$alivefreq = \"$alivefreq\";
\$max_lines = \"$max_lines\";

//Layout
\$skin = \"$skin\";
\$cur_symbol  = \"$cur_symbol\";  // $inst_text89
\$bgcolor1  = \"$bgcolor1\";      // $inst_text32
\$bgcolor2 = \"$bgcolor2\";       // $inst_text33
\$bgcolor3 = \"$bgcolor3\";       // $inst_text34
\$terminfarbe = \"$terminfarbe\"; // $inst_text35
\$logo = \"$logo\";               // $inst_text36
\$hp_url = \"$hp_url\";           // $inst_text37, $inst_text38
\$tr_hover = \"$tr_hover\";       // $inst_text96
?>
"; // end of string for $datei, now write config.inc.php

  if (!$error) {
    $fp = @fopen("config.inc.php",'wb+');
    $fw = fwrite($fp,$datei);
    if (!$fw) {
      $error = 1;
      echo "<br><b>PANIC! <br> config.inc.php can't be written!</b><br>";
    }
    fclose($fp);
  }

  // error or success?
  if(!$error) {
    echo "<b>$inst_text68!</b>\n";

    if ($setup == "install") {
      echo "<br><p style='font-size: 10pt;'>";
      echo "$inst_text69<br><br>\n";
      if ($groups) { echo "$inst_text71<br>"; }
      echo "<br>$inst_text72</p>";

      // try to create the directory for uploads
      if ($setup == "install" and $dat_rel and !is_dir($dat_rel)) {
        $result = mkdir($dat_rel,0777);
        // no created? -> show error message
        if (!result) { echo "<br><b>$inst_text87: '$dat_rel'</b><br><br>"; }
      }

      // try to create the directory for uploads
      if ($quickmail_old < 2 and $quickmail == 2 and !is_dir("attach")) {
        $result = mkdir("attach",0777);
        // not created? -> show error message
        if (!result) { echo "<br><b>$inst_text87: 'attach'</b><br><br>"; }
      }

      // ensure that the webserver has the read/write priviledge for attach, chat and upload dir
      if ($dateien or $chat or $quickmail == 2) {
        echo "$inst_text85:<br>\n";
        if ($dateien) { echo "<i>'$dat_rel'</i><br>\n"; }
        if ($chat) { echo "<i>'chat'</i><br>\n"; }
        if ($quickmail == 2) { echo "<i>'attach'</i><br>\n"; }
      }
    }
    // last message: call index.php :-)
    if ($login == 1) {echo "$log_text1:\n"; }
    else { echo "$index_text3 <a href='index.php'>index.php</a><br>\n"; }
  }
  // errors!!
  else {
    echo "<b>$inst_text68a!</b>\n";
    echo "$inst_text1b\n";
  }

  // destroy the session - on some system the first, on some system the second function doesn't work :-))
  @session_unset();
  @session_destroy();

?>