<?php

// todo_view.php - PHProjekt Version 4.0
// copyright    2000-2003 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// check whether the lib has been included - authentication!
if (!defined("lib_included")) { die("Please use index.php!"); }

// check role
if (check_role("todo") < 1) { die("You are not allowed to do this!"); }

  // ********************
  // add the condition that the user has to be sender or recipient of this todo
  switch ($category) {
    // case: own todos
    case "2":
      $where = "where ((von = '$user_ID' or von = '') and ext = '$user_ID') ";
      break;
    // case: delegated by the user to anyone else in the group
    case "3":
      $where = "where (von = '$user_ID' and ext <> '$user_ID') ";
      break;
    // case: delegated from anyone else to the user - only if the satus is higher than waiting = 1
    case "4":
      $where = "where (von <> '$user_ID' and von > 0 and ext = '$user_ID' and status > 1) ";
      break;
    case "5": 
      $where = "where (progress < 100 and status < 5) and (von = '$user_ID' or ext = '$user_ID') ";
      break;      
      // default should be case 1 - all todos
    default:
      $where = "where (von = '$user_ID' or ext = '$user_ID') ";
      break;
  }

  // add filter for status
  if ($status <> "all" and $status > 0) {
    if ($where) { $where .= " and status = '$status'"; }
    else { $where = "where status = '$status'"; } 
  }
  
  // Filter  for db query
  if ($keyword) {
    if ($filter == "all" or $filter == '') { 
      if ($where) { $where .= "and (remark like '%$keyword%' or note like '%$keyword%')"; }
      else { $where = "where (remark like '%$keyword%' or note like '%$keyword%')"; }
    }
    else {
      if ($where) { $where .= "and ($filter like '%$keyword%')"; }
      else { $where = $where = "where ($filter like '%$keyword%')"; } 
    }
  } 
  // end filter for db query

  // **************
  // navigation bar

  // sorting
  // default sorting criterium
  if (!$sort) { $sort = "deadline"; }
  // sort direction
  if($up == "1") { $direction = "ASC"; $up2 = 0; } else { $direction="DESC"; $up2 = 1; }

  //Filter form
  echo "<form action='todo.php' method='post'>";
  if (SID) { echo "<input type=hidden name='PHPSESSID' value='$PHPSESSID'>\n"; }
  echo "<table bgcolor=$bgcolor2>\n";
  echo "<tr><td><a href='$doc/todo.html' target='_blank'><b>$o_todo</b>&nbsp;&nbsp;</td>\n";
  // full text search filter
  echo "<td>$rts_21: <input type='text' name='keyword' value='$keyword' size=20 maxlength=20></td>\n";
  echo "<td><select name='filter'>";
  foreach ($fields as $field1 => $field2) {
    echo "<option value='$field1'";
    if ($field1 == $filter) { echo " selected"; }
    echo ">$field2\n";
  }
  echo "</select></td>\n";

  // select category: own, delegated, assigned
  echo "<td>$admin_text70: <select name='category'> \n";
  foreach ($category_arr as $category1 => $category2) {
    echo "<option value=$category1";
    if ($category1 == $category) { echo " selected"; }
    echo ">$category2";
  }
  echo "</select></td>";

  //select Status
  echo "<td>$rts_28: <select name='status'>\n";
  echo "<option value='all' selected>$proj_text8\n";
  foreach ($status_arr as $status1 => $status2) {
    echo "<option value=$status1";
    if ($status1 == $status) { echo " selected"; }
    echo ">$status2";
  }
  echo "</select></td>";
  
  // perpage select box
  echo "<td>&nbsp;<select name='perpage'>\n";
  foreach ($perpage_values as $j) {
    echo "<option value='$j'";
    if ($j == $perpage) { echo " selected"; }
    echo ">$j\n";
  }
  echo "</select> $items </td>\n";
  echo "<td>&nbsp;<input type=image src='$img_path/los.gif' border=0 id=tr>&nbsp;</td></form></tr>\n";

  // second line in the navigation bar
  echo "<tr><td>\n";
  // new request by the user itself
  if (check_role("todo") > 1) {
    echo "<a href='todo.php?mode=forms&create=create&perpage=$perpage&page=$page_p&up=$up&sort=$sort&keyword=$keyword&filter=$filter$sid'>$con_text4</a> | \n";
  }
  
  // define 'next' & 'previous' button
  // first find out, how many records are concerned
  $result = db_query("select count(ID) from todo $where") or db_die();
  $row = db_fetch_row($result);
  $page_n = $page + 1;
  $page_p = $page -1;
  if ($page) {
    echo "<a href='todo.php?sort=$sort&up=$up&keyword=$keyword&filter=$filter&status=$status&page=$page_p&perpage=$perpage$sid'>$previous</a>&nbsp;&nbsp;";
  }
  if ($row[0] > $page_n*$perpage) {
    echo "<a href='todo.php?sort=$sort&up=$up&keyword=$keyword&filter=$filter&status=$status&page=$page_n&perpage=$perpage$sid'>$next</a>";
  }
  echo "</td></tr></table><br>\n";
  // end navigation bar

  //List
  echo "<table border=0 cellpadding=2 cellspacing=1>\n";
  echo "<tr bgcolor=$bgcolor3>\n";
  $e1 = "<td width=";
  $e2 = "%><b><a href='todo.php?sort=";                                                                               
  $e3 = "&up=$up2&keyword=$keyword&filter=$filter&status=$status&category=$category&page=$page&perpage=$perpage$sid'>";
  $e4 = "</a></b></td>\n";

  // table headers
  // assigned - either own, from person or to him from user to colleague
  echo "<td width=16%><b>$proj_pers2</b></td>\n";
  echo $e1."29".$e2."remark".$e3.$rts_18.$e4;
  echo $e1."10".$e2."datum".$e3.$datei_text6.$e4;
  echo $e1."10".$e2."deadline".$e3.$r_proj2.$e4;
  // status: pending, accepted, rejected
  echo $e1."6".$e2."status".$e3.$rts_28.$e4;
  // progress
  echo $e1."5".$e2."progress".$e3.$todo_text4.$e4;
  // Priority
  echo $e1."1".$e2."priority".$e3."P.".$e4;
  // Contact                                                                                                       
  if ($adressen and check_role("contacts") > 0) { echo "<td width=11%>$proj_text12</td>\n"; }
  // project
  if ($projekte and check_role("projects") > 0) echo "<td width=11%>$l_text11</td>\n";
                                                                                                                    
  // Query
  $result = db_query("select ID, ext, von, remark, datum, deadline, status, progress, priority, contact, project from todo $where order by $sort $direction") or db_die();
  while ($row = db_fetch_row($result)) {
    if ($b >= $page*$perpage and $b < ($page+1)*$perpage) {

      // show row
      $ref = "todo.php?mode=forms&ID=$row[0]&up=$up&sort=$sort&status=$status&category=$category&keyword=$keyword&filter=$filter&page=$page&perpage=$perpage$sid";
      tr_tag($ref);

      // assigned
      // first case: its the user itself or the author is null ( = old todos)
      if ($row[1] == $row[2] or ($row[1] == $user_ID and !$row[2])) { echo "<td>$todo_text3</td>\n"; }
      // next case: user is the author
      elseif($row[1] <> $user_ID and $row[2] == $user_ID) { echo "<td>$mail_text46: ".fetch_name("nachname,vorname","users",$row[1])." </td>"; }
      // last possible case: user is the recipient and todo is beyond waiting - marked as italic
      else { echo "<td><i>$l_text7: ".fetch_name("nachname,vorname","users",$row[2])."</i> </td>"; }


      // title
      echo "<td><a href='$ref'><b>".$row[3]."</b></a></td>\n";


      // if the deadline has already passed, mark it as red
      $today = date("Y-m-d", mktime(date("H")+$timezone,date("i"),date("s"),date("m"),date("d"),date("Y")));
      if ($row[5] and $row[5] < $today) { $style = "<div style='color: red; font-weight: bold;'>"; }
      else { $style = "<div>"; }

      // creation date and deadline
      echo "<td align=right>".show_iso_date2($row[4])."</td><td align=right>".$style.$row[5]."</div></td>\n";
      // status
      echo "<td>".$status_arr[$row[6]]."&nbsp;</td>";

      // progress
      // if the recipient is the user, he will be able to fill in the progress itself
      if ($row[1] == $user_ID and ($row[9] > 1 and $row[9] < 5)) {
        echo "<form action=todo.php method=post>\n";
        echo "<input type=hidden name=mode value=data>\n";
        echo "<input type=hidden name=ID value='$row[0]'>\n";
        echo "<input type=hidden name=step value=update_progress>\n";
        echo "<td align=right><input type=text size=3 name=progress value='$row[7]' onBlur='this.form.submit()'>%\n";
        echo "</form></td>\n";
      }
      else { echo "<td align=right>$row[7]%</td>\n"; }

      // priority
      echo "<td>$row[8]</td>\n";                                                                                     
      // contact
      if ($adressen and check_role("contacts") > 0) { echo "<td>".fetch_name("nachname","contacts",$row[9])."&nbsp;</td>\n"; }
      // project
      if ($projekte and check_role("projects") > 0) { echo "<td>".fetch_name("name","projekte",$row[10])."&nbsp;</td>\n"; }
      echo "</tr>\n";
    }
    $b++;
  }
  echo "</table>";


?>