class Admin::Api::BuyerApplicationKeysController < Admin::Api::BuyersBaseController
  ##~ sapi = source2swagger.namespace("Account Management API")
  ##~ e = sapi.apis.add
  ##~ e.path          = "/admin/api/accounts/{account_id}/applications/{application_id}/keys.xml"
  ##~ e.responseClass = "application"
  #
  ##~ op            = e.operations.add
  ##~ op.httpMethod = "GET"
  ##~ op.summary    = "Application Key List"
  ##~ op.description = "Lists app keys of the application."
  ##~ op.group = "application"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_account_id_by_id_name
  ##~ op.parameters.add @parameter_application_id_by_id_name
  #
  def index
    respond_with(application_keys, representer: ApplicationKeysRepresenter)
  end

  ##~ op            = e.operations.add
  ##~ op.nickname   = "key_create"
  ##~ op.httpMethod = "POST"
  ##~ op.summary    = "Application Key Create"
  ##~ op.description = "Adds a key of an application (valid only on the authentication mode app_id/app_key or oauth). There are maximum 5 app_keys per application."
  ##~ op.group = "application"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_account_id_by_id_name
  ##~ op.parameters.add @parameter_application_id_by_id_name
  ##~ op.parameters.add :name => "key", :description => "app_key to be added", :dataType => "string", :required => true, :paramType => "query"
  #
  def create
    key = application_keys.add(params[:key])

    respond_with(key, serialize: application)
  end

  ##~ e = sapi.apis.add
  ##~ e.path          = "/admin/api/accounts/{account_id}/applications/{application_id}/keys/{key}.xml"
  ##~ e.responseClass = "application"
  #
  ##~ op            = e.operations.add
  ##~ op.httpMethod = "DELETE"
  ##~ op.summary    = "Application Key Delete"
  ##~ op.description = "Deletes a key of an application (valid only on the authentication mode app_id/app_key or oauth). An application may have to have at least one app_key (controlled by settings)."
  ##~ op.group = "application"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_account_id_by_id_name
  ##~ op.parameters.add @parameter_application_id_by_id_name
  ##~ op.parameters.add :name => "key", :description => "app_key to be deleted.", :dataType => "string", :required => true, :paramType => "path"
  #
  def destroy
    key = application_keys.remove!(params[:key] || params[:id])

    respond_with(key, serialize: application)
  end

  protected

  def application
    @application ||= accessible_bought_cinstances.find(params[:application_id])
  end

  def application_keys
    @application_keys ||= application.application_keys
  end

end
