class Finance::Provider::LineItemsController < FrontendController
  activate_menu :finance
  before_action :find_invoice
  before_action :find_line_item, :only => :destroy
  layout false

  def new
    @line_item = @invoice.line_items.build

    respond_to do |format|
      format.html
      format.js { render :layout => false, :content_type => :html }
    end
  end

  def create
    @line_item = @invoice.line_items.create!(params[:line_item])

    respond_to do |format|
      format.html do
        redirect_to(admin_finance_account_invoice_url(@buyer, @invoice))
      end

      format.js
    end
  end

  def destroy
    @line_item.destroy

    respond_to do |format|
      format.html do
        redirect_to(admin_finance_account_invoice_url(@invoice.buyer_account, @line_item.invoice))
      end

      format.js
    end
  end

  private

  def find_invoice
    @buyer = current_account.buyer_accounts.find(params[:account_id])
    @invoice = @buyer.invoices.find(params[:invoice_id])
  end

  def find_line_item
    @line_item = @invoice.line_items.find(params[:id])
  end
end
