module LogRequestHelper
  def request_log_response_code_class(code)
    code = code.to_s
    cls = "status-code "
    cls += if code =~ /^2\d\d/
      "success"
           elsif code =~ /^4\d\d/
      "client-error"
           elsif code =~ /^5\d\d/
      "server-error"
           else
      "unknown"
    end
  end

  def format_request_log_usage(usage)
    text = ""
    usage.split(',').each do |value|
      value.split(":").each_slice(2) do |m,v|
        text << content_tag(:span, ("<b>#{m}:</b>#{v}").html_safe)
      end
    end
    text.html_safe
  end

  def search_code_value
    @search.log ? @search.log["code"] : ""
  end
end
