require 'resque-retry'

class BillingJob
  extend ThreeScale::Analytics::ResquePlugin # to flush any analytics calls

  extend Resque::Plugins::Retry
  @retry_limit = 3
  @retry_delay = 40.minutes

  @queue = :billing

  def self.perform(provider_id, time)
    Finance::BillingStrategy.daily(only: [provider_id], now: Time.parse(time))
  end
end
