module AccountRepresenter
  include ThreeScale::JSONRepresenter
  include FieldsRepresenter
  include ExtraFieldsRepresenter

  wraps_resource

  with_options(unless: ->(*) { new_record? }) do | account |
    account.property :id
    account.property :created_at
    account.property :updated_at
  end

  with_options(if: ->(*) { provider? }) do | provider |
    provider.property :admin_domain
    provider.property :domain
    provider.property :from_email
    provider.property :support_email
    provider.property :finance_support_email
  end

  with_options(unless: ->(*) { destroyed? }) do | account |
    property :credit_card_stored
    #
    # TODO: this stuff is in #to_xml, should it be moved here and if so, should we remove links?
    #
    # collection :plans, extend: PlanRepresenter
    # collection :users, extend: UserRepresenter
    #
    #
    # TODO: this one needs to have option passed like in
    #   https://github.com/3scale/system/blob/master/app/representers/cms/page_representer.rb#L8
    #
    # if options[:with_apps]
    #  bought_cinstances.to_xml(:builder => xml, :root => 'applications')
    #end
  end

  property :state

  link :self do
    admin_api_account_url(self) unless provider?
  end

  link :users do
    admin_api_account_users_url(self)
  end

  def credit_card_stored
    self.credit_card_stored?
  end
end
