import $ from 'jquery'

import {StatsSource} from './source'

export class StatsLogsSource extends StatsSource {
  constructor (serviceId) {
    super()
    this.serviceId = serviceId
  }

  logRequests (state) {
    return new Promise((resolve, reject) => {
      this.request = $.getJSON(this.url(), this.params(state))
        .done(response => resolve(response))
        .fail((xhr, status, error) => reject(`Request failed: ${status}, ${error}`))
    })
  }

  params (state) {
    return {
      search: {
        timestamp: {
          '$gt': state.dateRange.since,
          '$lt': state.dateRange.until

        },
        code: (('code' in state) ? state.code : '')
      },
      page: (('pagination' in state) ? state.pagination.page : 1)

    }
  }

  url () {
    return `/services/${this.serviceId}/log_requests.json`
  }

}
