module BackendClient
  extend ActiveSupport::Autoload

  class BackendError < RuntimeError; end
  class TooManyItems < BackendError; end
  class InvalidItem  < BackendError; end

  eager_autoload do
    autoload :Connection
    autoload :Request

    autoload :Provider
    autoload :Service
    autoload :Application

    autoload :ToggleBackend
  end

  def self.config
    System::Application.config.backend_client
  end
end
