namespace :google_experiments do
  task :configuration do
    configuration = JSON.parse($stdin.read)
    $stdin.close

    puts
    puts 'add this to: config/environments/yours.rb'
    puts
    puts "config.three_scale.google_experiments.private_key = #{configuration['private_key'].inspect}"
    puts "config.three_scale.google_experiments.issuer = #{configuration['client_email'].inspect}"
    puts '# needs to be a real account with access to the GA'
    puts "config.three_scale.google_experiments.person = 'someone@3scale.net'"
    puts '# you can find this as Account ID in GA > Admin > Account Settings (left column)'
    puts "config.three_scale.google_experiments.account_id = '7542266'"
    puts '# you can find this as Tracking ID in GA > Admin > Property Settings (middle column)'
    puts "config.three_scale.google_experiments.web_property_id = 'UA-7542266-12'"
    puts '# you can find this as View ID in GA > Admin > View Settings (right column)'
    puts "config.three_scale.google_experiments.profile_id = '97719717' # View ID"
    puts '# you can find this as Experiment ID in GA > Reporting > Behaviour > Experiments'
    puts '#     > Some Experiment > Setting up your experiment code > Manually insert code'
    puts "config.three_scale.google_experiments['Experiment Name'] = 'Experiment-ID'"

    puts
    puts
    puts
    puts "Don't forget to enable the API Client in Google Apps."
    puts 'Go to: https://admin.google.com/3scale.net/ManageOauthClients'
    puts "As a Client Name use #{configuration['client_id']}"
    puts "and as a scope: #{ThreeScale::Analytics::GoogleExperiments::ACCESS_SCOPE}"
  end
end
