def run_command cmd
  puts "--> executing: #{cmd}"
  system cmd
end

namespace :doc do
  namespace :swagger do

    desc "Generates and uploads all swagger docs"
    task all: ["generate:all", "upload:all"]
    task preview_all: ["generate_for_preview:all", "upload_for_preview:all"]

    namespace :generate do

      desc "Generates all swagger docs"
      task all: [:analytics, :finance, :accounts, :cms]

      task :analytics do
        cmd = 'bundle exec source2swagger -i app/controllers/stats -e "rb" -c "##~" -o doc/active_docs/.'
        run_command cmd
      end

      task :accounts do
        cmd = 'bundle exec source2swagger -i app/controllers/admin/api -e "rb" -c "##~" -o doc/active_docs/.'
        run_command cmd
      end

      task :finance do
        cmd = 'bundle exec source2swagger -i app/controllers/finance -e "rb" -c "##~" -o doc/active_docs/.'
        run_command cmd
      end

      task :cms do
        cmd = 'bundle exec sour --comment="##=" app/controllers/admin/api/cms/*.rb > doc/active_docs/cms.json'
        run_command cmd
      end
    end

    namespace :upload do

      desc "Uploads all swagger docs"
      task all: [:analytics, :finance, :accounts, :cms]

      task :analytics do
       cmd = 'curl -v -X PUT -F "body=@doc/active_docs/Analytics API.json" "https://support-admin.3scale.net/admin/api/active_docs/54035.xml?provider_key=bf6dc92fcda709e570b717609bd51047"'
       run_command cmd
      end

      task :accounts do
        cmd = 'curl -v -X PUT -F "body=@doc/active_docs/Account Management API.json" "https://support-admin.3scale.net/admin/api/active_docs/54034.xml?provider_key=bf6dc92fcda709e570b717609bd51047"'
        run_command cmd
      end

      task :finance do
        cmd = 'curl -v -X PUT -F "body=@doc/active_docs/Billing API.json" "https://support-admin.3scale.net/admin/api/active_docs/54036.xml?provider_key=bf6dc92fcda709e570b717609bd51047"'
        run_command cmd
      end

      task :cms do
        cmd = 'curl -v -X PUT -F "body=@doc/active_docs/cms.json" "https://support-admin.3scale.net/admin/api/active_docs/54225.xml?provider_key=bf6dc92fcda709e570b717609bd51047"'
        run_command cmd
      end
    end

    namespace :generate_for_preview do

      desc "Generates all swagger docs for preview purposes"
      task all: [:analytics, :finance, :accounts, :cms]

      task :analytics do
        cmd = 'bundle exec source2swagger -i app/controllers/stats -e "rb" -c "##~" -o doc/active_docs/preview/.'
        run_command cmd
      end

      task :accounts do
        cmd = 'bundle exec source2swagger -i app/controllers/admin/api -e "rb" -c "##~" -o doc/active_docs/preview/.'
        run_command cmd
      end

      task :finance do
        cmd = 'bundle exec source2swagger -i app/controllers/finance -e "rb" -c "##~" -o doc/active_docs/preview/.'
        run_command cmd
      end

      task :cms do
        cmd = 'bundle exec sour --comment="##=" app/controllers/admin/api/cms/*.rb > doc/active_docs/preview/cms.json'
        run_command cmd
      end
    end


    namespace :upload_for_preview do
      desc "Uploads all swagger docs to preview account"
      task all: [:analytics, :finance, :accounts, :cms]

      provider_key = '7abbd2bf16c0aa647c8ce8c1de70bf2c'

      task :analytics do
       cmd = "curl -v -X PUT -F 'body=@doc/active_docs/preview/Analytics API.json' 'https://support-staging-admin.3scale.net/admin/api/active_docs/57900.xml?provider_key=#{provider_key}'"
       run_command cmd
      end

      task :accounts do
        cmd = "curl -v -X PUT -F 'body=@doc/active_docs/preview/Account Management API.json' 'https://support-staging-admin.3scale.net/admin/api/active_docs/57904.xml?provider_key=#{provider_key}'"
        run_command cmd
      end

      task :finance do
        cmd = "curl -v -X PUT -F 'body=@doc/active_docs/preview/Billing API.json' 'https://support-staging-admin.3scale.net/admin/api/active_docs/57901.xml?provider_key=#{provider_key}'"
        run_command cmd
      end

      task :cms do
        cmd = "curl -v -X PUT -F 'body=@doc/active_docs/preview/cms.json' 'https://support-staging-admin.3scale.net/admin/api/active_docs/57902.xml?provider_key=#{provider_key}'"
        run_command cmd
      end
    end

    namespace :validate do
      desc "Validate swagger 2.0 specs"
      task all: [:analytics, :finance, :accounts]
      task :analytics do
        run_command "node_modules/.bin/swagger-tools validate doc/active_docs/analytics-s20.json"
      end

      task :finance do
        run_command "node_modules/.bin/swagger-tools validate doc/active_docs/finance-s20.json"
      end

      task :accounts do
        run_command "node_modules/.bin/swagger-tools validate doc/active_docs/accounts-s20.json"
      end
    end

  end
end
