namespace :master do

  desc 'Create application plans for master - from base up to evilprise'
  task :create_plans => :environment do
    master = Account.master
    service = master.services.first
    plans = service.application_plans

    # Use this huge snippet to generate the inserts. If you do though DON'T
    # FORGET TO HAND EDIT THE PLAN SYSTEM NAMES AND OTHER STUFF!
    #
    # service = Account.master.services.first; hits = service.metrics.first; plans = service.application_plans; service.features.each { |f| puts "service.features.create!( :name => '#{f.name}', :system_name => '#{f.system_name}')" } ; puts '# --- PLANS ---' ; plans.each { |p| puts "p = plans.create!( :issuer => service, :name => '#{p.name}', :system_name => '#{p.system_name}', :cost_per_month => #{p.cost_per_month} )" ; p.features.each { |f| puts "p.enable_feature!('#{f.system_name}')"} ; p.usage_limits.each { |l| puts "p.usage_limits.create!(:period => '#{l.period}', :value => #{l.value}, :metric => hits)" } ; puts "\n" } ; nil
    #
    #
    service.features.create!( :name => 'Base Access Control and Security', :system_name => 'base_access_control_and_security')
    service.features.create!( :name => 'Multiple Applications per Account', :system_name => 'multiple_application_per_account')
    service.features.create!( :name => 'Multiple Developers per Account', :system_name => 'multiple_developers_per_account')
    service.features.create!( :name => 'Multiple Admins and Multiple APIs', :system_name => 'multiple_admins_and_multiple_apis')
    service.features.create!( :name => 'Base Service Contracts and Traffic Policies', :system_name => 'base_service_contracts_and_traffic_policies')
    service.features.create!( :name => 'Account Plans', :system_name => 'account_plans')
    service.features.create!( :name => 'Service Plans and End User Plans', :system_name => 'service_plans_and_end_user_plans')
    service.features.create!( :name => 'Analytics and Reporting', :system_name => 'analytics_and_reporting')
    service.features.create!( :name => 'API Log Tracking', :system_name => 'api_log_tracking')
    service.features.create!( :name => 'Base Developer Portal and Documentation', :system_name => 'base_developer_portal_and_documentation')
    service.features.create!( :name => 'Custom Domain Names (Portal and Emails)', :system_name => 'custom_domain_names_portal_and_emails')
    service.features.create!( :name => 'Role Based Content Access', :system_name => 'role_based_content_access')
    service.features.create!( :name => 'Billing and Payment', :system_name => 'billing_and_payment')
    service.features.create!( :name => 'Account Management API', :system_name => 'account_management_api')
    service.features.create!( :name => 'Analytics API', :system_name => 'analytics_api')
    service.features.create!( :name => 'Billing API', :system_name => 'billing_api')
    service.features.create!( :name => 'Standard SLA and Customer Support', :system_name => 'standard_sla_and_customer_support')
    service.features.create!( :name => 'Pro SLA and Customer Support', :system_name => 'pro_sla_and_customer_support')
    service.features.create!( :name => 'Premium SLA and Customer Support', :system_name => 'premium_sla_and_customer_support')

    # --- PLANS ---
    p = plans.create!( :issuer => service, :name => 'Base', :system_name => 'base', :cost_per_month => 0.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('standard_sla_and_customer_support')

    p.usage_limits.new(:period => 'eternity', :value => 250)
    p.usage_limits.new(:period => 'day', :value => 50000)
    p.usage_limits.new(:period => 'eternity', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Plus', :system_name => 'plus', :cost_per_month => 125.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('standard_sla_and_customer_support')
    p.usage_limits.new(:period => 'eternity', :value => 1000)
    p.usage_limits.new(:period => 'day', :value => 250000)
    p.usage_limits.new(:period => 'minute', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Power 1M', :system_name => 'power1M', :cost_per_month => 250.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('standard_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 1000000)
    p.usage_limits.new(:period => 'minute', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Power 2M', :system_name => 'power2M', :cost_per_month => 350.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('standard_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 2000000)
    p.usage_limits.new(:period => 'minute', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Power 3M', :system_name => 'power3M', :cost_per_month => 450.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('standard_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 3000000)
    p.usage_limits.new(:period => 'minute', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Power 5M', :system_name => 'power5M', :cost_per_month => 650.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('standard_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 5000000)
    p.usage_limits.new(:period => 'minute', :value => 0)

    p = plans.create!( :issuer => service, :name => 'Pro 3M', :system_name => 'pro3M', :cost_per_month => 750.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('multiple_admins_and_multiple_apis')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('service_plans_and_end_user_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('api_log_tracking')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('account_management_api')
    p.enable_feature!('analytics_api')
    p.enable_feature!('billing_api')
    p.enable_feature!('standard_sla_and_customer_support')
    p.enable_feature!('pro_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 3000000)
    p.usage_limits.new(:period => 'eternity', :value => 100000)

    p = plans.create!( :issuer => service, :name => 'Pro 5M', :system_name => 'pro5M', :cost_per_month => 1250.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('multiple_admins_and_multiple_apis')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('service_plans_and_end_user_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('api_log_tracking')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('account_management_api')
    p.enable_feature!('analytics_api')
    p.enable_feature!('billing_api')
    p.enable_feature!('standard_sla_and_customer_support')
    p.enable_feature!('pro_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 5000000)
    p.usage_limits.new(:period => 'eternity', :value => 100000)

    p = plans.create!( :issuer => service, :name => 'Pro 10M', :system_name => 'pro10', :cost_per_month => 1750.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('multiple_admins_and_multiple_apis')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('service_plans_and_end_user_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('api_log_tracking')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('account_management_api')
    p.enable_feature!('analytics_api')
    p.enable_feature!('billing_api')
    p.enable_feature!('standard_sla_and_customer_support')
    p.enable_feature!('pro_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 10000000)
    p.usage_limits.new(:period => 'eternity', :value => 100000)

    p = plans.create!( :issuer => service, :name => 'Pro 20M', :system_name => 'pro20M', :cost_per_month => 2000.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('multiple_admins_and_multiple_apis')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('service_plans_and_end_user_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('api_log_tracking')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('account_management_api')
    p.enable_feature!('analytics_api')
    p.enable_feature!('billing_api')
    p.enable_feature!('standard_sla_and_customer_support')
    p.enable_feature!('pro_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 20000000)
    p.usage_limits.new(:period => 'eternity', :value => 100000)

    p = plans.create!( :issuer => service, :name => 'Enterprise', :system_name => 'enterprise', :cost_per_month => 2500.0 )
    p.enable_feature!('base_access_control_and_security')
    p.enable_feature!('multiple_application_per_account')
    p.enable_feature!('multiple_developers_per_account')
    p.enable_feature!('multiple_admins_and_multiple_apis')
    p.enable_feature!('base_service_contracts_and_traffic_policies')
    p.enable_feature!('account_plans')
    p.enable_feature!('service_plans_and_end_user_plans')
    p.enable_feature!('analytics_and_reporting')
    p.enable_feature!('api_log_tracking')
    p.enable_feature!('base_developer_portal_and_documentation')
    p.enable_feature!('custom_domain_names_portal_and_emails')
    p.enable_feature!('role_based_content_access')
    p.enable_feature!('billing_and_payment')
    p.enable_feature!('account_management_api')
    p.enable_feature!('analytics_api')
    p.enable_feature!('billing_api')
    p.enable_feature!('standard_sla_and_customer_support')
    p.enable_feature!('pro_sla_and_customer_support')
    p.enable_feature!('premium_sla_and_customer_support')
    p.usage_limits.new(:period => 'day', :value => 5000000)
    puts 'Master application plans created.'


    # Manually assigning 'hits' as metric is not mass-assignable
    hits = service.metrics.find_by_name 'hits'

    plans.each do |p|
      p.usage_limits.each do |limit|
        limit.metric = hits
        limit.save!
      end
    end

    puts 'Usage limits saved'
  end


  desc 'Assigns enterprise plan to all providers, Guillaumes Base plan as default'
  task :assign_plans => :environment do
    master = Account.master
    service = master.services.first

    service.default_application_plan = service.application_plans.find_by_system_name('base')
    service.default_service_plan = service.service_plans.first
    service.save!

    master.default_account_plan = master.account_plans.first
    master.save!

    enterprise = service.application_plans.find_by_system_name('enterprise')

    Account.providers.each do |provider|
      contract = provider.bought_cinstance
      contract.change_plan!(enterprise)
      contract.save!
    end
  end

end
