namespace :pdf do

  desc 'Dispatch report for demo.3scale.net'
  task :dispatch => :environment do
    puts "** Dispatching report to demo.3scale.net"
    a = Account.find_by_domain 'demo.3scale.net'
    if a.nil?
      puts "** 3scale Demo account wasn't found"
      return
    end
    Pdf::Report.new(a, :period => :week).generate
    puts "** Report sent to demo.3scale.net"
  end

  # TODO: - remove the task if it is later 31 November 2010 and you
  # still see this comment
  namespace :invoices do

    desc 'Add-hoc task designed to generate PDFs for all invoices'
    task :generate => :environment do
      Invoice.find_each do |invoice|

        unless invoice.pdf.file?
          if invoice.issued_on &&
             #              invoice.cost > 0 &&
             invoice.buyer_account.has_bought_cinstance?
            begin
              invoice.generate_pdf!
              putc 'X'
            rescue => e
              puts "(Failed - #{e.message} - #{invoice.id})"
            end
          else
            putc '.'
          end
        else
          putc '-'
        end
      end
    end

  end
end
