namespace :proxy do
  desc "create proxies for every service"
  task :create_proxies => :environment do
    Service.find_each do |s|
      puts "Creating proxy for #{s.account.name}"
      s.create_proxy unless s.proxy
    end
  end

  desc "rewrite the content types"
  task :rewrite_content_types => :environment do
    Proxy.update_all  "error_headers_over_limit = 'text/plain; charset=us-ascii'"
    Proxy.update_all  "error_headers_auth_failed = 'text/plain; charset=us-ascii'"
    Proxy.update_all  "error_headers_auth_missing = 'text/plain; charset=us-ascii'"
    Proxy.update_all  "error_headers_no_match = 'text/plain; charset=us-ascii'"
  end

  desc "rewrite api_endpoints"
  task :rewrite_endpoints => :environment do
    Proxy.find_each do |p|
      schema = p.endpoint.gsub(/http:\/\//, '')
      schema = schema.gsub(/:80/,'')
      if schema =~ /[^A-Za-z\d.+-]/
        schema =  schema.gsub(/[^A-Za-z\d.+-]/, '-')
        p.endpoint = "http://#{schema}:80"
        p.save
      end
    end
  end

  desc "inject gannett's proxy rules for all services"
  task :gannett_create_rules => :environment do
    unless ENV['FILE'] && ENV['ACCOUNT_ID']
      raise "ENV vars missing: FILE and ACCOUNT_ID (gannet is 2445581155550)"
    end

    file = ENV['FILE'] || File.join(Rails.root, 'gannett.csv')
    gannett_id = ENV['ACCOUNT_ID']

    importer = ThreeScale::Rake::GannettImporter.new(file, gannett_id)

    importer.import
    if importer.valid?
      puts "ok: %i, no ok: %i" % importer.save_all_rules.map(&:size)
    else
      raise "invalid rules when trying to import from csv"
    end
  end

  desc 'Fixing nil endpoint for on_3scale'
  task :set_correct_endpoint_on_3scale => :environment do
    Service.includes(:proxy).where(proxies: {endpoint: nil}, deployment_option: 'on_3scale').find_each(&:deployment_option_changed)
  end
end
