namespace :sidekiq do
  desc 'start sidekiq web interface'
  task monitor: :environment do
    require 'sidekiq/web'
    app = Sidekiq::Web
    app.set :environment, Rails.env
    app.set :bind, '0.0.0.0'
    app.set :port, ENV.fetch('PORT', 9494)
    app.run!
  end

  desc 'start sidekiq worker'
  task :worker do
    exec('sidekiq', '--concurrency', ENV['CONCURRENCY'] || '1', '--index', ENV['INDEX'] || '0', *%w[critical priority default low].flat_map{|queue| ['--queue', queue]})
  end
end

task sidekiq: %w[sidekiq:worker]
