/** @object Stats **/
/* A global object, containing values necessary for a successful Stats API query. */

var Stats = {};

Stats.SearchOptions = {
  metric_name: 'hits',
  period: 'month',
  since: null
};

try {
  // override params by search query
  $.extend(Stats.SearchOptions, document.location.search.replace(/(^\?)/,'').split("&").map(function(n){return n = n.split("="),this[n[0]] = n[1],this}.bind({}))[0])
} catch(e) { }


Stats.hitsMetricID = null;



(function($){

jQuery(document).ready(function() {

  /* Seed Stats.SearchOptions object with default values */
  (function(){
    var s = Stats.SearchOptions;
    s.hitsMetricID = $("ul.metric-list li[data-hits='true']").attr('data-metric');
    s.metric_name  = $('#current-metric').attr('data-metric');
    s.since        = $('div#current-date').attr('data-date');
  })();

  var $metricSelector = $('.metric-list[data-type="metric"]');

  // FIXME: .live() is deprecated/removed - http://api.jquery.com/live/
  $("#current-metric").live('click', function(){
    $metricSelector.toggle();
  });

  $('ul.metric-list li').live('click', function(){
    $metricSelector.hide();
    var $this = $(this);
    Stats.SearchOptions.metric_name = $this.attr('data-metric');
    $("#current-metric").attr("data-metric-unit", $this.data("metric-unit"));
    $("#current-metric").attr("data-metric", $this.data("metric-unit"));
    $('div#current-metric span').html($this.html());
    $('#submit-stats-search').trigger('click');
  });

 /* Buttons for view by method/metric */
  var $metricTypeButtons = $('#metric-type-buttons span');
  $metricTypeButtons.click(function(){
    var reloadChart = true;

    $metricSelector.hide();

    var type = $(this).attr('data-metric-type');
    $metricSelector = $('ul.metric-list[data-type="'+type+'"]');

    var $defaultMetric = $('li:first', $metricSelector);
    var newMetricID = $defaultMetric.attr('data-metric');

    $('div#current-metric span').html($defaultMetric.html());

    if(Stats.SearchOptions.metric_name == newMetricID){
      reloadChart = false;
    } else {
      Stats.SearchOptions.metric_name = newMetricID;
    }

    $metricTypeButtons.removeClass('current');
    $(this).addClass('current');

    if(reloadChart){
      $(window).trigger('metricTypeDidChange', $metricSelector);
      $('#submit-stats-search').trigger('click');
    }
  });


  if(typeof $.datepicker == 'object'){

    $('#current-date').click(function(){
      $('#datepicker-box').toggle();
    });

    $('#datepicker').datepicker({
       onSelect: function(dateText, obj){
         $("#submit-stats-search").show();
         ThreeScale.Helper.Charts.processDateFromDatePicker(dateText);
       }
    });
  }

  $('span#submit-stats-search').click(function(){
    $('span#submit-stats-search').fadeOut();
    $('#selector-widgets .toggle').hide();
    $(window).trigger('apply-selectors');
    return false;
  });

  var $periodButtons = $('#period-buttons span.period');

  $periodButtons.click(function(){
    $("#submit-stats-search").show();
    $this = $(this);
    $periodButtons.removeClass('current');
    $this.addClass('current');
    Stats.SearchOptions.period = $this.attr('data-value');
    $(window).trigger('PeriodDidChange', Stats.SearchOptions.period);
  });

});

})(jQuery);
