require 'spec_helper'
require 'will_paginate/array'

resource "Invoice" do

  let(:buyer) { Factory(:buyer_account, provider_account: provider) }
  let(:resource) { Factory(:invoice, buyer_account: buyer, provider_account: provider) }

  let(:collection) { [resource].paginate(page: 1, per_page: 20) }
  let(:account_id) { buyer.id }

  before { provider.create_billing_strategy! }

  api 'invoices' do
    get '/api/invoices.:format', action: :index
    get '/api/invoices/:id.:format', action: :show
  end

  api 'account invoices' do
    get '/api/accounts/:account_id/invoices.:format', action: :index
    get '/api/accounts/:account_id/invoices/:id.:format', action: :show
  end

  api 'set invoice state' do
    let(:id) { resource.id }

    put '/api/invoices/:id/state.:format', :resource do
      parameter :state, "The destination state you want to transit."
      let(:state){'cancel'}
      request "Set State" do
        resource.reload.state.should == 'cancelled'
      end
    end
  end

  json(:resource) do
    let(:root) { 'invoice' }
    it { should include('id' => resource.id, 'state' => resource.state) }
    it { should include('cost', 'currency', 'period') }
    it { should have_links('self', 'account', 'payment_transactions', 'line_items') }

    # TODO: make it check for paid at and others (in nested context)
    # should include('paid_at', 'due_on', 'issued_on', 'currency', 'cost')
  end

  json(:collection) do
    let(:root) { 'invoices' }
    it { should be_an(Array) }
  end
end

__END__

        api_invoices GET    /api/invoices(.:format)                          finance/api/invoices#index
         api_invoice GET    /api/invoices/:id(.:format)                      finance/api/invoices#show
api_account_invoices GET    /api/accounts/:account_id/invoices(.:format)     finance/api/accounts/invoices#index
 api_account_invoice GET    /api/accounts/:account_id/invoices/:id(.:format) finance/api/accounts/invoices#show
