import $ from 'jquery'

import {StatsStore} from 'stats/lib/store'

describe('StatsStore', () => {
  class FakeHistory {
    pushState (state) {
      this.state = state
    }
  }

  let window = {
    location: {
      hash: '#{"period":{"number":24,"unit":"hour"},"granularity":"hour"}'
    },
    history: new FakeHistory()
  }
  let store = new StatsStore(window)

  it('should update history', () => {
    let state = {
      granularity: 'hour',
      period: {
        number: 24,
        unit: 'hour'
      }
    }

    store.save(state)

    expect(store.window.history.state).toEqual(state)
  })

  it('should get params', () => {
    let expectedParams = {
      period: {
        number: 24,
        unit: 'hour'
      },
      granularity: 'hour'
    }
    let params = store.load()

    expect(params).toEqual(expectedParams)
  })

  it('should call triggerNavigationEvent method when popstate event is triggered', () => {
    let spyOnNavigation = spyOn(store, 'triggerNavigationEvent')

    $(store.window).triggerHandler('popstate')

    expect(spyOnNavigation).toHaveBeenCalled()
  })
})
