require 'test_helper'

class Provider::Admin::CMS::SwitchesControllerTest < ActionDispatch::IntegrationTest
  def setup
    @provider = FactoryGirl.create(:provider_account)
    host! @provider.admin_domain
    login! @provider
    plan = ApplicationPlan.new(issuer: master_account.first_service!, name: 'enterprise')
    @provider.force_upgrade_to_provider_plan!(plan)
  end

  test 'Finance is globally disabled' do
    Settings.stubs(globally_denied_switches: [])
    get provider_admin_cms_switches_path
    assert_response :success
    assert_select '#switch-finance-toggle'

    Settings.stubs(globally_denied_switches: [:finance])
    get provider_admin_cms_switches_path
    assert_response :success
    assert_select '#switch-finance-toggle', false
    assert_select %Q(table#switches th), text: 'Finance', count: 0
  end

  test 'Log requests is globally disabled' do
    Settings.stubs(globally_denied_switches: [])
    get provider_admin_cms_switches_path
    assert_response :success
    assert_select '#switch-log_requests-toggle'

    Settings.stubs(globally_denied_switches: [:log_requests])
    get provider_admin_cms_switches_path
    assert_response :success
    assert_select '#switch-log_requests-toggle', false
    assert_select %Q(table#switches th), text: 'Log Requests', count: 0
  end
end
