require 'test_helper'

class Admin::ApiDocs::ServicesControllerTest < ActionController::TestCase

  def setup
    @provider = FactoryGirl.create(:provider_account)
    login_provider(@provider)
  end

  test '#create sets the system_name' do
    assert_difference '::ApiDocs::Service.count' do
      post :create, {:api_docs_service => { system_name: 'smart_service', name: 'servone', body: '{"basePath":"http://github.com", "apis":[]}'}}
      assert_response :redirect
    end
    assert_equal @provider.api_docs_services.last!.system_name, "smart_service"
  end
end
