require 'test_helper'

class Buyers::AccountPlansControllerTest < ActionController::TestCase
  # we don't have show action
  #

  context 'account_plans switch' do
    setup do
      @provider = Factory :provider_account
      @request.host = @provider.domain

      login_as(@provider.admins.first)
    end

    context 'is denied' do
      setup do
        assert @provider.settings.account_plans_denied?
      end

      should "forbid new" do
        get :new
        assert_template "errors/forbidden"
      end

      should "forbid create" do
        post :create
        assert_template "errors/forbidden"
      end
    end
  end

  test 'destroy account plan, when account plan cant be destroyed, should not raise error' do
    @provider = Factory :provider_account
    @request.host = @provider.domain

    login_as(@provider.first_admin)
    AccountPlan.any_instance.expects(can_be_destroyed?: false).at_least_once
    delete :destroy, id: @provider.account_plans.first.id
  end
end
