require 'test_helper'

class DeveloperPortal::ActivationsControllerTest < DeveloperPortal::ActionController::TestCase

  def setup
    @buyer    = FactoryGirl.create(:buyer_account)
    @provider = @buyer.provider_account
    @user     = FactoryGirl.create(:pending_user, account: @buyer)
    @service  = @provider.first_service!

    @request.host = @provider.domain
  end

  test 'wrong activation code' do
    get :create, activation_code: 'code123'

    assert_response :success
  end

  test 'successfully activate user' do
    get :create, activation_code: @user.activation_code

    assert_response :redirect

    @user.reload

    assert_equal true, @user.active?
  end

  test 'account required approval flash message' do
    Account.any_instance.expects(:approval_required?).returns(true)

    get :create, activation_code: @user.activation_code

    assert_equal flash[:notice], I18n.t('errors.messages.activation_approval_required')
  end

  test 'activation complete flash message' do
    Account.any_instance.expects(:approval_required?).returns(false)

    get :create, activation_code: @user.activation_code

    assert_equal flash[:notice], I18n.t('errors.messages.activation_complete')
  end

  test 'emails has been taken problem' do
    second_user = Factory.build(:pending_user, account: @buyer, email: @user.email)

    second_user.save validate: false

    get :create, activation_code: @user.activation_code

    assert_response :redirect

    assert_equal flash[:error], I18n.t('errors.messages.duplicated_user_buyer_side')
  end
end
