require 'test_helper'

# DEPRECATED: Payment Express is deprecated
class DeveloperPortal::Admin::Account::PaymentExpressControllerTest <DeveloperPortal::AbstractPaymentGatewaysControllerTest

  include ActiveMerchantTestHelpers::PaymentExpress

  test '#show' do
    PaymentGateways::PaymentExpressCrypt.expects(:auth_url).returns('http://example.com/auth_url')
    get :show
    assert_response :success
  end

  test '#hosted_success' do
    ::PaymentGateways::PaymentExpressCrypt.expects(:auth_response)
      .with(
        login: @provider.payment_gateway.options[:hosted_login],
        password: @provider.payment_gateway.options[:hosted_password],
        result: 'a_result'
      ).returns(successful_response)

    get :hosted_success, result: 'a_result'
    assert_redirected_to admin_account_payment_express_path
  end

  test '#hosted_success with plan changes' do
    session[:plan_changes] = {1 => 2}
    ::PaymentGateways::PaymentExpressCrypt.expects(:auth_response)
      .with(
        login: @provider.payment_gateway.options[:hosted_login],
        password: @provider.payment_gateway.options[:hosted_password],
        result: 'a_result'
      ).returns(successful_response)

    get :hosted_success, result: 'a_result'
    assert_redirected_to admin_account_plan_changes_path
  end
end
