require 'test_helper'

class Monitor::EventsControllerTest < ActionController::TestCase

  test "should fail without monitoring set" do
    provider = Factory :provider_account
    login_provider provider

    get :index, :service_id => provider.services.first.id
    assert_response 404
  end

  test "should get to index" do
    provider = Factory :provider_account

    settings = provider.settings
    settings.monitor_app_id= 9
    settings.monitor_api_id= 7
    settings.save!

    login_provider provider

    get :index, :service_id => provider.services.first.id
    assert_response :success
  end

  test "should get json stuff" do
    provider = Factory :provider_account

    settings = provider.settings
    settings.monitor_app_id= 5
    settings.monitor_api_id= 3
    settings.save!

    res = stub :body => "{}", :code => 200
    HTTPClient.expects(:get).with(anything).returns res

    login_provider provider

    get :index, :service_id => provider.services.first.id, :format => "json"
    assert_response :success
  end
end
