class Provider::Admin::Account::InvoicesControllerTest < ActionController::TestCase
  def setup
    provider = FactoryGirl.create(:simple_provider)
    FactoryGirl.create(:active_admin, account: provider)
    login_provider provider
  end

  test '#index with finance enabled' do
    Rails.application.config.three_scale.stubs(finance_enabled: true)
    get :index
    assert_response :success
  end

  test '#index with finance disabled' do
    Rails.application.config.three_scale.stubs(finance_enabled: false)
    get :index
    assert_response :forbidden
  end
end
