require 'test_helper'

class Sites::DnsControllerTest < ActionDispatch::IntegrationTest

  def setup
    @provider = FactoryGirl.create(:provider_account, domain: 'provider.domain.com', from_email: 'support@domain.com')
    login! @provider
  end

  test 'update' do
    account_params = {
      account: {
        site_access_code: 'abcdefgh',
        domain: 'another.dev.domain.com',
        from_email: 'info@dev.domain.com'
      }
    }

    Rails.configuration.three_scale.stubs(readonly_custom_domains_settings: true)
    put admin_site_dns_path, account_params

    @provider.reload
    assert_equal 'abcdefgh', @provider.site_access_code
    assert_equal 'provider.domain.com', @provider.domain
    assert_equal 'support@domain.com', @provider.from_email


    Rails.configuration.three_scale.stubs(readonly_custom_domains_settings: false)
    put admin_site_dns_path, account_params

    @provider.reload
    assert_equal 'abcdefgh', @provider.site_access_code
    assert_equal 'another.dev.domain.com', @provider.domain
    assert_equal 'info@dev.domain.com', @provider.from_email

  end
end
