require 'test_helper'

class EnableServiceRequestLogs < ActiveSupport::TestCase
  disable_transactional_fixtures!

  context 'when the account\'s service is in a plan with log requests available' do
    should 'call to create a cubert bucket' do
      EnableRequestLogsWorker.expects(:enqueue).once

      account = FactoryGirl.create(:simple_provider)
      account.settings.allow_log_requests
      Service.create!(account: account, name: "FooService")
    end
  end

  context 'when the account\'s service is in a plan without log requests available' do
    should 'don\'t call to create a cubert bucket' do
      EnableRequestLogsWorker.expects(:enqueue).never
      Service.create!(account: Factory(:simple_provider), name: "FooService")
    end
  end
end
