require 'test_helper'

class Finance::Api::InvoicesControllerTest < ActionDispatch::IntegrationTest
  include GlobalFinanceHelpers

  def setup
    @provider = FactoryGirl.create(:provider_with_billing)
    login_provider @provider
  end

  test '#index with global finance states' do
    with_gloabl_finance_states_tests do
      get api_invoices_path, nil, accept: Mime::JSON
    end
  end

  test '#show with global finance states' do
    with_gloabl_finance_states_tests do
      get api_invoice_path(invoice), nil, accept: Mime::JSON
    end
  end

  test '#state with global finance states' do
    with_gloabl_finance_states_tests do
      put state_api_invoice_path(invoice, state: 'cancel'), nil, accept: Mime::JSON
    end
  end

  protected

  def invoice
    @invoice ||= FactoryGirl.create(:invoice, provider_account: @provider)
  end
end
