require 'test_helper'

class Finance::Api::LineItemsControllerTest < ActionDispatch::IntegrationTest
  include GlobalFinanceHelpers

  def setup
    @provider = FactoryGirl.create(:provider_with_billing)
    login_provider @provider
  end

  test '#index with global finance states' do
    invoice = FactoryGirl.create(:invoice, provider_account: @provider)

    with_gloabl_finance_states_tests do
      get api_invoice_line_items_path(invoice.id), nil, accept: Mime::JSON
    end
  end
end
