require 'test_helper'

class Finance::Api::PaymentTransactionsControllerTest < ActionDispatch::IntegrationTest
  include GlobalFinanceHelpers

  def setup
    @provider = FactoryGirl.create(:provider_with_billing)
    login_provider @provider
  end

  test '#index' do
    invoice = FactoryGirl.create(:invoice, provider_account: @provider)

    with_gloabl_finance_states_tests do
      get api_invoice_payment_transactions_path(invoice), nil, accept: Mime::JSON
    end
  end
end
